/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.debugging.information;

import org.teavm.debugging.information.DebugInformation;
import org.teavm.debugging.information.GeneratedLocation;

public class FileNameIterator {
    private DebugInformation debugInformation;
    private int index;

    FileNameIterator(DebugInformation debugInformation) {
        this.debugInformation = debugInformation;
    }

    public boolean isEndReached() {
        return this.index < this.debugInformation.fileMapping.size();
    }

    public GeneratedLocation getLocation() {
        if (this.isEndReached()) {
            throw new IllegalStateException("End already reached");
        }
        return DebugInformation.key(this.debugInformation.fileMapping.get(this.index));
    }

    public int getFileNameId() {
        if (this.isEndReached()) {
            throw new IllegalStateException("End already reached");
        }
        return this.debugInformation.fileMapping.get(this.index).get(2);
    }

    public String getFileName() {
        int fileNameId = this.getFileNameId();
        return fileNameId >= 0 ? this.debugInformation.getFileName(fileNameId) : null;
    }

    public void next() {
        if (this.isEndReached()) {
            throw new IllegalStateException("End already reached");
        }
        ++this.index;
    }
}

