/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model;

import java.util.Objects;
import org.teavm.model.InstructionLocation;
import org.teavm.model.MethodReference;

public class CallLocation {
    private MethodReference method;
    private InstructionLocation sourceLocation;

    public CallLocation(MethodReference method) {
        this(method, null);
    }

    public CallLocation(MethodReference method, InstructionLocation sourceLocation) {
        if (method == null) {
            throw new IllegalArgumentException("Method must not be null");
        }
        this.method = method;
        this.sourceLocation = sourceLocation;
    }

    public MethodReference getMethod() {
        return this.method;
    }

    public InstructionLocation getSourceLocation() {
        return this.sourceLocation;
    }

    public int hashCode() {
        return Objects.hash(this.method, this.sourceLocation);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CallLocation)) {
            return false;
        }
        CallLocation other = (CallLocation)obj;
        return Objects.equals(this.method, other.method) && Objects.equals(this.sourceLocation, other.sourceLocation);
    }
}

