/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.javascript;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.teavm.codegen.NamingException;
import org.teavm.codegen.NamingOrderer;
import org.teavm.codegen.NamingStrategy;
import org.teavm.codegen.SourceWriter;
import org.teavm.common.ServiceRepository;
import org.teavm.debugging.information.DebugInformationEmitter;
import org.teavm.debugging.information.DeferredCallSite;
import org.teavm.debugging.information.DummyDebugInformationEmitter;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.javascript.NameFrequencyEstimator;
import org.teavm.javascript.Precedence;
import org.teavm.javascript.RenderingContext;
import org.teavm.javascript.RenderingException;
import org.teavm.javascript.TryCatchFinder;
import org.teavm.javascript.ast.AssignmentStatement;
import org.teavm.javascript.ast.AsyncMethodNode;
import org.teavm.javascript.ast.AsyncMethodPart;
import org.teavm.javascript.ast.BinaryExpr;
import org.teavm.javascript.ast.BinaryOperation;
import org.teavm.javascript.ast.BlockStatement;
import org.teavm.javascript.ast.BreakStatement;
import org.teavm.javascript.ast.ClassNode;
import org.teavm.javascript.ast.ConditionalExpr;
import org.teavm.javascript.ast.ConditionalStatement;
import org.teavm.javascript.ast.ConstantExpr;
import org.teavm.javascript.ast.ContinueStatement;
import org.teavm.javascript.ast.Expr;
import org.teavm.javascript.ast.ExprVisitor;
import org.teavm.javascript.ast.FieldNode;
import org.teavm.javascript.ast.GotoPartStatement;
import org.teavm.javascript.ast.InitClassStatement;
import org.teavm.javascript.ast.InstanceOfExpr;
import org.teavm.javascript.ast.InvocationExpr;
import org.teavm.javascript.ast.InvocationType;
import org.teavm.javascript.ast.MethodNode;
import org.teavm.javascript.ast.MethodNodeVisitor;
import org.teavm.javascript.ast.MonitorEnterStatement;
import org.teavm.javascript.ast.MonitorExitStatement;
import org.teavm.javascript.ast.NativeMethodNode;
import org.teavm.javascript.ast.NewArrayExpr;
import org.teavm.javascript.ast.NewExpr;
import org.teavm.javascript.ast.NewMultiArrayExpr;
import org.teavm.javascript.ast.NodeLocation;
import org.teavm.javascript.ast.NodeModifier;
import org.teavm.javascript.ast.QualificationExpr;
import org.teavm.javascript.ast.RegularMethodNode;
import org.teavm.javascript.ast.ReturnStatement;
import org.teavm.javascript.ast.SequentialStatement;
import org.teavm.javascript.ast.Statement;
import org.teavm.javascript.ast.StatementVisitor;
import org.teavm.javascript.ast.StaticClassExpr;
import org.teavm.javascript.ast.SubscriptExpr;
import org.teavm.javascript.ast.SwitchClause;
import org.teavm.javascript.ast.SwitchStatement;
import org.teavm.javascript.ast.ThrowStatement;
import org.teavm.javascript.ast.TryCatchStatement;
import org.teavm.javascript.ast.UnaryExpr;
import org.teavm.javascript.ast.UnwrapArrayExpr;
import org.teavm.javascript.ast.VariableExpr;
import org.teavm.javascript.ast.WhileStatement;
import org.teavm.javascript.spi.GeneratorContext;
import org.teavm.javascript.spi.InjectedBy;
import org.teavm.javascript.spi.Injector;
import org.teavm.javascript.spi.InjectorContext;
import org.teavm.model.AnnotationHolder;
import org.teavm.model.ClassHolder;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldReference;
import org.teavm.model.ListableClassHolderSource;
import org.teavm.model.ListableClassReaderSource;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class Renderer
implements ExprVisitor,
StatementVisitor,
RenderingContext {
    private static final String variableNames = "abcdefghijkmnopqrstuvwxyz";
    private static final String variablePartNames = "abcdefghijkmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private NamingStrategy naming;
    private SourceWriter writer;
    private ListableClassHolderSource classSource;
    private ClassLoader classLoader;
    private boolean minifying;
    private Map<MethodReference, InjectorHolder> injectorMap = new HashMap<MethodReference, InjectorHolder>();
    private Map<String, Integer> stringPoolMap = new HashMap<String, Integer>();
    private List<String> stringPool = new ArrayList<String>();
    private Properties properties = new Properties();
    private ServiceRepository services;
    private DebugInformationEmitter debugEmitter = new DummyDebugInformationEmitter();
    private Deque<LocationStackEntry> locationStack = new ArrayDeque<LocationStackEntry>();
    private DeferredCallSite lastCallSite;
    private DeferredCallSite prevCallSite;
    private Set<MethodReference> asyncMethods;
    private Set<MethodReference> asyncFamilyMethods;
    private Diagnostics diagnostics;
    private boolean async;
    private Precedence precedence;
    private Map<String, String> blockIdMap = new HashMap<String, String>();
    private List<Set<String>> debugNames = new ArrayList<Set<String>>();
    private List<String> cachedVariableNames = new ArrayList<String>();
    private boolean end;
    private int currentPart;

    public void addInjector(MethodReference method, Injector injector) {
        this.injectorMap.put(method, new InjectorHolder(injector));
    }

    public Renderer(SourceWriter writer, ListableClassHolderSource classSource, ClassLoader classLoader, ServiceRepository services, Set<MethodReference> asyncMethods, Set<MethodReference> asyncFamilyMethods, Diagnostics diagnostics) {
        this.naming = writer.getNaming();
        this.writer = writer;
        this.classSource = classSource;
        this.classLoader = classLoader;
        this.services = services;
        this.asyncMethods = new HashSet<MethodReference>(asyncMethods);
        this.asyncFamilyMethods = new HashSet<MethodReference>(asyncFamilyMethods);
        this.diagnostics = diagnostics;
    }

    @Override
    public SourceWriter getWriter() {
        return this.writer;
    }

    @Override
    public NamingStrategy getNaming() {
        return this.naming;
    }

    @Override
    public boolean isMinifying() {
        return this.minifying;
    }

    public void setMinifying(boolean minifying) {
        this.minifying = minifying;
    }

    @Override
    public ListableClassHolderSource getClassSource() {
        return this.classSource;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Properties getProperties() {
        return new Properties(this.properties);
    }

    public DebugInformationEmitter getDebugEmitter() {
        return this.debugEmitter;
    }

    public void setDebugEmitter(DebugInformationEmitter debugEmitter) {
        this.debugEmitter = debugEmitter;
    }

    public void setProperties(Properties properties) {
        this.properties.clear();
        this.properties.putAll((Map<?, ?>)properties);
    }

    public void renderStringPool() throws RenderingException {
        if (this.stringPool.isEmpty()) {
            return;
        }
        try {
            this.writer.append("$rt_stringPool([");
            for (int i = 0; i < this.stringPool.size(); ++i) {
                if (i > 0) {
                    this.writer.append(',').ws();
                }
                this.writer.append('\"').append(Renderer.escapeString(this.stringPool.get(i))).append('\"');
            }
            this.writer.append("]);").newLine();
        }
        catch (IOException e) {
            throw new RenderingException("IO error", e);
        }
    }

    public void renderRuntime() throws RenderingException {
        try {
            this.renderRuntimeCls();
            this.renderRuntimeString();
            this.renderRuntimeUnwrapString();
            this.renderRuntimeObjcls();
            this.renderRuntimeNullCheck();
            this.renderRuntimeIntern();
            this.renderRuntimeThreads();
        }
        catch (NamingException e) {
            throw new RenderingException("Error rendering runtime methods. See a cause for details", e);
        }
        catch (IOException e) {
            throw new RenderingException("IO error", e);
        }
    }

    private void renderRuntimeCls() throws IOException {
        this.writer.append("function $rt_cls(cls)").ws().append("{").softNewLine().indent();
        this.writer.append("return ").appendMethodBody("java.lang.Class", "getClass", ValueType.object("org.teavm.platform.PlatformClass"), ValueType.object("java.lang.Class")).append("(cls);").softNewLine();
        this.writer.outdent().append("}").newLine();
    }

    private void renderRuntimeString() throws IOException {
        MethodReference stringCons = new MethodReference(String.class, "<init>", char[].class, Void.TYPE);
        this.writer.append("function $rt_str(str) {").indent().softNewLine();
        this.writer.append("if (str===null){").indent().softNewLine();
        this.writer.append("return null;").softNewLine();
        this.writer.outdent().append("}").softNewLine();
        this.writer.append("var characters = $rt_createCharArray(str.length);").softNewLine();
        this.writer.append("var charsBuffer = characters.data;").softNewLine();
        this.writer.append("for (var i = 0; i < str.length; i = (i + 1) | 0) {").indent().softNewLine();
        this.writer.append("charsBuffer[i] = str.charCodeAt(i) & 0xFFFF;").softNewLine();
        this.writer.outdent().append("}").softNewLine();
        this.writer.append("return ").append(this.naming.getNameForInit(stringCons)).append("(characters);").softNewLine();
        this.writer.outdent().append("}").newLine();
    }

    private void renderRuntimeUnwrapString() throws IOException {
        MethodReference stringLen = new MethodReference(String.class, "length", Integer.TYPE);
        MethodReference getChars = new MethodReference(String.class, "getChars", Integer.TYPE, Integer.TYPE, char[].class, Integer.TYPE, Void.TYPE);
        this.writer.append("function $rt_ustr(str) {").indent().softNewLine();
        this.writer.append("var result = \"\";").softNewLine();
        this.writer.append("var sz = ").appendMethodBody(stringLen).append("(str);").softNewLine();
        this.writer.append("var array = $rt_createCharArray(sz);").softNewLine();
        this.writer.appendMethodBody(getChars).append("(str, 0, sz, array, 0);").softNewLine();
        this.writer.append("for (var i = 0; i < sz; i = (i + 1) | 0) {").indent().softNewLine();
        this.writer.append("result += String.fromCharCode(array.data[i]);").softNewLine();
        this.writer.outdent().append("}").softNewLine();
        this.writer.append("return result;").softNewLine();
        this.writer.outdent().append("}").newLine();
    }

    private void renderRuntimeNullCheck() throws IOException {
        this.writer.append("function $rt_nullCheck(val) {").indent().softNewLine();
        this.writer.append("if (val === null) {").indent().softNewLine();
        this.writer.append("$rt_throw(").append(this.naming.getNameForInit(new MethodReference(NullPointerException.class, "<init>", Void.TYPE))).append("());").softNewLine();
        this.writer.outdent().append("}").softNewLine();
        this.writer.append("return val;").softNewLine();
        this.writer.outdent().append("}").newLine();
    }

    private void renderRuntimeIntern() throws IOException {
        this.writer.append("function $rt_intern(str) {").indent().softNewLine();
        this.writer.append("return ").appendMethodBody(new MethodReference(String.class, "intern", String.class)).append("(str);").softNewLine();
        this.writer.outdent().append("}").newLine();
    }

    private void renderRuntimeObjcls() throws IOException {
        this.writer.append("function $rt_objcls() { return ").appendClass("java.lang.Object").append("; }").newLine();
    }

    private void renderRuntimeThreads() throws IOException {
        this.writer.append("function $rt_getThread()").ws().append("{").indent().softNewLine();
        this.writer.append("return ").appendMethodBody(Thread.class, "currentThread", Thread.class).append("();").softNewLine();
        this.writer.outdent().append("}").newLine();
        this.writer.append("function $rt_setThread(t)").ws().append("{").indent().softNewLine();
        this.writer.append("return ").appendMethodBody(Thread.class, "setCurrentThread", Thread.class, Void.TYPE).append("(t);").softNewLine();
        this.writer.outdent().append("}").newLine();
    }

    private void renderRuntimeAliases() throws IOException {
        String[] names = new String[]{"$rt_throw", "$rt_compare", "$rt_nullCheck", "$rt_cls", "$rt_createArray", "$rt_isInstance", "$rt_nativeThread", "$rt_suspending", "$rt_resuming", "$rt_invalidPointer"};
        boolean first = true;
        for (String name : names) {
            if (!first) {
                this.writer.softNewLine();
            }
            first = false;
            this.writer.append("var ").appendFunction(name).ws().append('=').ws().append(name).append(";").softNewLine();
        }
        this.writer.newLine();
    }

    public void render(List<ClassNode> classes) throws RenderingException {
        if (this.minifying) {
            NamingOrderer orderer = new NamingOrderer();
            NameFrequencyEstimator estimator = new NameFrequencyEstimator(orderer, this.classSource, this.asyncMethods, this.asyncFamilyMethods);
            for (ClassNode cls : classes) {
                estimator.estimate(cls);
            }
            orderer.apply(this.naming);
        }
        if (this.minifying) {
            try {
                this.renderRuntimeAliases();
            }
            catch (IOException e) {
                throw new RenderingException(e);
            }
        }
        for (ClassNode cls : classes) {
            this.renderDeclaration(cls);
        }
        for (ClassNode cls : classes) {
            this.renderMethodBodies(cls);
        }
        this.renderClassMetadata(classes);
    }

    private void renderDeclaration(ClassNode cls) throws RenderingException {
        this.debugEmitter.addClass(cls.getName(), cls.getParentName());
        try {
            FieldReference fieldRef;
            Object value;
            this.writer.append("function ").appendClass(cls.getName()).append("()").ws().append("{").indent().softNewLine();
            boolean thisAliased = false;
            ArrayList<FieldNode> nonStaticFields = new ArrayList<FieldNode>();
            ArrayList<FieldNode> staticFields = new ArrayList<FieldNode>();
            for (FieldNode field : cls.getFields()) {
                if (field.getModifiers().contains((Object)NodeModifier.STATIC)) {
                    staticFields.add(field);
                    continue;
                }
                nonStaticFields.add(field);
            }
            if (nonStaticFields.size() > 1) {
                thisAliased = true;
                this.writer.append("var a").ws().append("=").ws().append("this;").ws();
            }
            if (cls.getParentName() != null) {
                this.writer.appendClass(cls.getParentName()).append(".call(").append(thisAliased ? "a" : "this").append(");").softNewLine();
            }
            for (FieldNode field : nonStaticFields) {
                value = field.getInitialValue();
                if (value == null) {
                    value = Renderer.getDefaultValue(field.getType());
                }
                fieldRef = new FieldReference(cls.getName(), field.getName());
                this.writer.append(thisAliased ? "a" : "this").append(".").appendField(fieldRef).ws().append("=").ws().append(this.constantToString(value)).append(";").softNewLine();
                this.debugEmitter.addField(field.getName(), this.naming.getNameFor(fieldRef));
            }
            this.writer.outdent().append("}").newLine();
            for (FieldNode field : staticFields) {
                value = field.getInitialValue();
                if (value == null) {
                    value = Renderer.getDefaultValue(field.getType());
                }
                fieldRef = new FieldReference(cls.getName(), field.getName());
                this.writer.appendClass(cls.getName()).append('.').appendField(fieldRef).ws().append("=").ws().append(this.constantToString(value)).append(";").softNewLine();
            }
        }
        catch (NamingException e) {
            throw new RenderingException("Error rendering class " + cls.getName() + ". See cause for details", e);
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    private void renderMethodBodies(ClassNode cls) throws RenderingException {
        this.debugEmitter.emitClass(cls.getName());
        try {
            boolean needsClinit;
            ArrayList<MethodNode> nonInitMethods = new ArrayList<MethodNode>();
            MethodHolder clinit = this.classSource.get(cls.getName()).getMethod(new MethodDescriptor("<clinit>", ValueType.VOID));
            ArrayList<MethodNode> clinitMethods = new ArrayList<MethodNode>();
            for (MethodNode method : cls.getMethods()) {
                if (clinit == null || !method.getModifiers().contains((Object)NodeModifier.STATIC) && !method.getReference().getName().equals("<init>")) {
                    nonInitMethods.add(method);
                    continue;
                }
                clinitMethods.add(method);
            }
            boolean bl = needsClinit = clinit != null;
            if (needsClinit) {
                this.writer.append("function ").appendClass(cls.getName()).append("_$clinit()").ws().append("{").softNewLine().indent();
                this.writer.appendClass(cls.getName()).append("_$clinit").ws().append("=").ws().append("function(){};").newLine();
                for (MethodNode method : clinitMethods) {
                    this.renderBody(method, true);
                }
                if (clinit != null) {
                    this.writer.appendMethodBody(new MethodReference(cls.getName(), clinit.getDescriptor())).append("();").softNewLine();
                }
                this.writer.outdent().append("}").newLine();
            }
            if (!cls.getModifiers().contains((Object)NodeModifier.INTERFACE)) {
                for (MethodNode method : cls.getMethods()) {
                    cls.getMethods();
                    if (method.getModifiers().contains((Object)NodeModifier.STATIC) || !method.getReference().getName().equals("<init>")) continue;
                    this.renderInitializer(method);
                }
            }
            for (MethodNode method : nonInitMethods) {
                this.renderBody(method, false);
            }
        }
        catch (NamingException e) {
            throw new RenderingException("Error rendering class " + cls.getName() + ". See a cause for details", e);
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
        this.debugEmitter.emitClass(null);
    }

    private void renderClassMetadata(List<ClassNode> classes) {
        try {
            this.writer.append("$rt_metadata([");
            boolean first = true;
            for (ClassNode cls : classes) {
                if (!first) {
                    this.writer.append(',').softNewLine();
                }
                first = false;
                this.writer.appendClass(cls.getName()).append(",").ws();
                this.writer.append("\"").append(Renderer.escapeString(cls.getName())).append("\",").ws();
                if (cls.getParentName() != null) {
                    this.writer.appendClass(cls.getParentName());
                } else {
                    this.writer.append("0");
                }
                this.writer.append(',').ws();
                this.writer.append("[");
                for (int i = 0; i < cls.getInterfaces().size(); ++i) {
                    String iface = cls.getInterfaces().get(i);
                    if (i > 0) {
                        this.writer.append(",").ws();
                    }
                    this.writer.appendClass(iface);
                }
                this.writer.append("],").ws();
                int flags = 0;
                if (cls.getModifiers().contains((Object)NodeModifier.ENUM)) {
                    flags |= 1;
                }
                this.writer.append(flags).append(',').ws();
                MethodHolder clinit = this.classSource.get(cls.getName()).getMethod(new MethodDescriptor("<clinit>", ValueType.VOID));
                if (clinit != null) {
                    this.writer.appendClass(cls.getName()).append("_$clinit");
                } else {
                    this.writer.append('0');
                }
                this.writer.append(',').ws();
                ArrayList<String> stubNames = new ArrayList<String>();
                ArrayList<MethodNode> virtualMethods = new ArrayList<MethodNode>();
                for (MethodNode method : cls.getMethods()) {
                    if (clinit != null && (method.getModifiers().contains((Object)NodeModifier.STATIC) || method.getReference().getName().equals("<init>"))) {
                        stubNames.add(this.naming.getFullNameFor(method.getReference()));
                    }
                    if (method.getModifiers().contains((Object)NodeModifier.STATIC)) continue;
                    virtualMethods.add(method);
                }
                if (stubNames.size() == 1) {
                    this.writer.append("'").append((String)stubNames.get(0)).append("'");
                } else {
                    this.writer.append('[');
                    for (int j = 0; j < stubNames.size(); ++j) {
                        if (j > 0) {
                            this.writer.append(",").ws();
                        }
                        this.writer.append("'").append((String)stubNames.get(j)).append("'");
                    }
                    this.writer.append(']');
                }
                this.writer.append(',').ws();
                this.renderVirtualDeclarations(virtualMethods);
            }
            this.writer.append("]);").newLine();
        }
        catch (NamingException e) {
            throw new RenderingException("Error rendering class metadata. See a cause for details", e);
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    private static Object getDefaultValue(ValueType type) {
        if (type instanceof ValueType.Primitive) {
            ValueType.Primitive primitive = (ValueType.Primitive)type;
            switch (primitive.getKind()) {
                case BOOLEAN: {
                    return false;
                }
                case BYTE: {
                    return (byte)0;
                }
                case SHORT: {
                    return (short)0;
                }
                case INTEGER: {
                    return 0;
                }
                case CHARACTER: {
                    return Character.valueOf('\u0000');
                }
                case LONG: {
                    return 0L;
                }
                case FLOAT: {
                    return Float.valueOf(0.0f);
                }
                case DOUBLE: {
                    return 0.0;
                }
            }
        }
        return null;
    }

    private void renderInitializer(MethodNode method) throws IOException {
        int i;
        MethodReference ref = method.getReference();
        this.debugEmitter.emitMethod(ref.getDescriptor());
        this.writer.append("function ").append(this.naming.getNameForInit(ref)).append("(");
        for (i = 1; i <= ref.parameterCount(); ++i) {
            if (i > 1) {
                this.writer.append(",").ws();
            }
            this.writer.append(this.variableName(i));
        }
        this.writer.append(")").ws().append("{").softNewLine().indent();
        this.writer.append("var $r").ws().append("=").ws().append("new ").appendClass(ref.getClassName()).append("();").softNewLine();
        this.writer.append(this.naming.getFullNameFor(ref)).append("($r");
        for (i = 1; i <= ref.parameterCount(); ++i) {
            this.writer.append(",").ws();
            this.writer.append(this.variableName(i));
        }
        this.writer.append(");").softNewLine();
        this.writer.append("return $r;").softNewLine();
        this.writer.outdent().append("}").newLine();
        this.debugEmitter.emitMethod(null);
    }

    private void renderVirtualDeclarations(List<MethodNode> methods) throws NamingException, IOException {
        this.writer.append("[");
        boolean first = true;
        for (MethodNode method : methods) {
            this.debugEmitter.emitMethod(method.getReference().getDescriptor());
            MethodReference ref = method.getReference();
            if (!first) {
                this.writer.append(",").ws();
            }
            first = false;
            this.emitVirtualDeclaration(ref);
            this.debugEmitter.emitMethod(null);
        }
        this.writer.append("]");
    }

    private void emitVirtualDeclaration(MethodReference ref) throws IOException {
        int i;
        String methodName = this.naming.getNameFor(ref.getDescriptor());
        this.writer.append("\"").append(methodName).append("\"");
        this.writer.append(",").ws().append("function(");
        ArrayList<String> args = new ArrayList<String>();
        for (i = 1; i <= ref.parameterCount(); ++i) {
            args.add(this.variableName(i));
        }
        for (i = 0; i < args.size(); ++i) {
            if (i > 0) {
                this.writer.append(",").ws();
            }
            this.writer.append((String)args.get(i));
        }
        this.writer.append(")").ws().append("{").ws();
        if (ref.getDescriptor().getResultType() != ValueType.VOID) {
            this.writer.append("return ");
        }
        this.writer.appendMethodBody(ref).append("(");
        this.writer.append("this");
        for (i = 0; i < args.size(); ++i) {
            this.writer.append(",").ws().append((String)args.get(i));
        }
        this.writer.append(");").ws().append("}");
    }

    public void renderBody(MethodNode method, boolean inner) throws IOException {
        this.debugNames.clear();
        this.cachedVariableNames.clear();
        this.debugNames.addAll(method.getParameterDebugNames());
        this.blockIdMap.clear();
        MethodReference ref = method.getReference();
        this.debugEmitter.emitMethod(ref.getDescriptor());
        String name = this.naming.getFullNameFor(ref);
        if (inner) {
            this.writer.append(name).ws().append("=").ws().append("function(");
        } else {
            this.writer.append("function ").append(name).append("(");
        }
        int startParam = 0;
        if (method.getModifiers().contains((Object)NodeModifier.STATIC)) {
            startParam = 1;
        }
        for (int i = startParam; i <= ref.parameterCount(); ++i) {
            if (i > startParam) {
                this.writer.append(",").ws();
            }
            this.writer.append(this.variableName(i));
        }
        this.writer.append(")").ws().append("{").softNewLine().indent();
        method.acceptVisitor(new MethodBodyRenderer());
        this.writer.outdent().append("}");
        if (inner) {
            this.writer.append(';');
        }
        this.writer.newLine();
        this.debugEmitter.emitMethod(null);
    }

    private void appendMonitor(MethodNode methodNode) throws IOException {
        if (methodNode.getModifiers().contains((Object)NodeModifier.STATIC)) {
            this.writer.appendFunction("$rt_cls").append("(").appendClass(methodNode.getReference().getClassName()).append(")");
        } else {
            this.writer.append(this.variableName(0));
        }
    }

    private void pushLocation(NodeLocation location) {
        LocationStackEntry prevEntry = this.locationStack.peek();
        if (location != null) {
            if (prevEntry == null || !location.equals(prevEntry.location)) {
                this.debugEmitter.emitLocation(location.getFileName(), location.getLine());
            }
        } else if (prevEntry != null) {
            this.debugEmitter.emitLocation(null, -1);
        }
        this.locationStack.push(new LocationStackEntry(location));
    }

    private void popLocation() {
        LocationStackEntry prevEntry = this.locationStack.pop();
        LocationStackEntry entry = this.locationStack.peek();
        if (entry != null) {
            if (!entry.location.equals(prevEntry.location)) {
                this.debugEmitter.emitLocation(entry.location.getFileName(), entry.location.getLine());
            }
        } else {
            this.debugEmitter.emitLocation(null, -1);
        }
    }

    @Override
    public void visit(AssignmentStatement statement) throws RenderingException {
        try {
            this.debugEmitter.emitStatementStart();
            if (statement.getLocation() != null) {
                this.pushLocation(statement.getLocation());
            }
            this.prevCallSite = this.debugEmitter.emitCallSite();
            if (statement.getLeftValue() != null) {
                if (statement.isAsync()) {
                    this.writer.append(this.tempVarName());
                } else {
                    this.precedence = Precedence.COMMA;
                    statement.getLeftValue().acceptVisitor(this);
                }
                this.writer.ws().append("=").ws();
            }
            this.precedence = Precedence.COMMA;
            statement.getRightValue().acceptVisitor(this);
            this.debugEmitter.emitCallSite();
            this.writer.append(";").softNewLine();
            if (statement.isAsync()) {
                this.emitSuspendChecker();
                if (statement.getLeftValue() != null) {
                    this.precedence = Precedence.COMMA;
                    statement.getLeftValue().acceptVisitor(this);
                    this.writer.ws().append("=").ws().append(this.tempVarName()).append(";").softNewLine();
                }
            }
            if (statement.getLocation() != null) {
                this.popLocation();
            }
            if (statement.getLeftValue() instanceof VariableExpr) {
                VariableExpr receiver = (VariableExpr)statement.getLeftValue();
                this.debugEmitter.emitVariable(statement.getDebugNames().toArray(new String[0]), this.variableName(receiver.getIndex()));
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(SequentialStatement statement) {
        this.visitStatements(statement.getSequence());
    }

    @Override
    public void visit(ConditionalStatement statement) {
        try {
            block5: {
                while (true) {
                    this.debugEmitter.emitStatementStart();
                    if (statement.getCondition().getLocation() != null) {
                        this.pushLocation(statement.getCondition().getLocation());
                    }
                    this.prevCallSite = this.debugEmitter.emitCallSite();
                    this.writer.append("if").ws().append("(");
                    this.precedence = Precedence.COMMA;
                    statement.getCondition().acceptVisitor(this);
                    if (statement.getCondition().getLocation() != null) {
                        this.popLocation();
                    }
                    this.debugEmitter.emitCallSite();
                    this.writer.append(")").ws().append("{").softNewLine().indent();
                    this.visitStatements(statement.getConsequent());
                    if (statement.getAlternative().isEmpty()) break block5;
                    this.writer.outdent().append("}").ws();
                    if (statement.getAlternative().size() != 1 || !(statement.getAlternative().get(0) instanceof ConditionalStatement)) break;
                    statement = (ConditionalStatement)statement.getAlternative().get(0);
                    this.writer.append("else ");
                }
                this.writer.append("else").ws().append("{").indent().softNewLine();
                this.visitStatements(statement.getAlternative());
            }
            this.writer.outdent().append("}").softNewLine();
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(SwitchStatement statement) {
        try {
            this.debugEmitter.emitStatementStart();
            if (statement.getValue().getLocation() != null) {
                this.pushLocation(statement.getValue().getLocation());
            }
            if (statement.getId() != null) {
                this.writer.append(this.mapBlockId(statement.getId())).append(":").ws();
            }
            this.prevCallSite = this.debugEmitter.emitCallSite();
            this.writer.append("switch").ws().append("(");
            this.precedence = Precedence.min();
            statement.getValue().acceptVisitor(this);
            if (statement.getValue().getLocation() != null) {
                this.popLocation();
            }
            this.debugEmitter.emitCallSite();
            this.writer.append(")").ws().append("{").softNewLine().indent();
            for (SwitchClause clause : statement.getClauses()) {
                for (int condition : clause.getConditions()) {
                    this.writer.append("case ").append(condition).append(":").softNewLine();
                }
                this.writer.indent();
                boolean oldEnd = this.end;
                for (Statement part : clause.getBody()) {
                    this.end = false;
                    part.acceptVisitor(this);
                }
                this.end = oldEnd;
                this.writer.outdent();
            }
            if (statement.getDefaultClause() != null) {
                this.writer.append("default:").softNewLine().indent();
                boolean oldEnd = this.end;
                for (Statement part : statement.getDefaultClause()) {
                    this.end = false;
                    part.acceptVisitor(this);
                }
                this.end = oldEnd;
                this.writer.outdent();
            }
            this.writer.outdent().append("}").softNewLine();
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(WhileStatement statement) {
        try {
            this.debugEmitter.emitStatementStart();
            if (statement.getCondition() != null && statement.getCondition().getLocation() != null) {
                this.pushLocation(statement.getCondition().getLocation());
            }
            if (statement.getId() != null) {
                this.writer.append(this.mapBlockId(statement.getId())).append(":").ws();
            }
            this.writer.append("while").ws().append("(");
            if (statement.getCondition() != null) {
                this.prevCallSite = this.debugEmitter.emitCallSite();
                this.precedence = Precedence.min();
                statement.getCondition().acceptVisitor(this);
                this.debugEmitter.emitCallSite();
                if (statement.getCondition().getLocation() != null) {
                    this.popLocation();
                }
            } else {
                this.writer.append("true");
            }
            this.writer.append(")").ws().append("{").softNewLine().indent();
            boolean oldEnd = this.end;
            for (Statement part : statement.getBody()) {
                this.end = false;
                part.acceptVisitor(this);
            }
            this.end = oldEnd;
            this.writer.outdent().append("}").softNewLine();
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    private String mapBlockId(String id) {
        String name = this.blockIdMap.get(id);
        if (name == null) {
            int index = this.blockIdMap.size();
            name = "$b" + this.indexToId(index);
            this.blockIdMap.put(id, name);
        }
        return name;
    }

    private String indexToId(int index) {
        StringBuilder sb = new StringBuilder();
        do {
            sb.append(variablePartNames.charAt(index % variablePartNames.length()));
        } while ((index /= variablePartNames.length()) > 0);
        return sb.toString();
    }

    @Override
    public void visit(BlockStatement statement) {
        try {
            this.writer.append(this.mapBlockId(statement.getId())).append(":").ws().append("{").softNewLine().indent();
            this.visitStatements(statement.getBody());
            this.writer.outdent().append("}").softNewLine();
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(BreakStatement statement) {
        try {
            this.debugEmitter.emitStatementStart();
            if (statement.getLocation() != null) {
                this.pushLocation(statement.getLocation());
            }
            this.writer.append("break");
            if (statement.getTarget() != null) {
                this.writer.append(' ').append(this.mapBlockId(statement.getTarget().getId()));
            }
            this.writer.append(";").softNewLine();
            if (statement.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(ContinueStatement statement) {
        try {
            this.debugEmitter.emitStatementStart();
            if (statement.getLocation() != null) {
                this.pushLocation(statement.getLocation());
            }
            this.writer.append("continue");
            if (statement.getTarget() != null) {
                this.writer.append(' ').append(this.mapBlockId(statement.getTarget().getId()));
            }
            this.writer.append(";").softNewLine();
            if (statement.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(ReturnStatement statement) {
        try {
            this.debugEmitter.emitStatementStart();
            if (statement.getLocation() != null) {
                this.pushLocation(statement.getLocation());
            }
            this.writer.append("return");
            if (statement.getResult() != null) {
                this.writer.append(' ');
                this.prevCallSite = this.debugEmitter.emitCallSite();
                this.precedence = Precedence.min();
                statement.getResult().acceptVisitor(this);
                this.debugEmitter.emitCallSite();
            }
            this.writer.append(";").softNewLine();
            if (statement.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(ThrowStatement statement) {
        try {
            this.debugEmitter.emitStatementStart();
            if (statement.getLocation() != null) {
                this.pushLocation(statement.getLocation());
            }
            this.writer.appendFunction("$rt_throw").append("(");
            this.prevCallSite = this.debugEmitter.emitCallSite();
            this.precedence = Precedence.min();
            statement.getException().acceptVisitor(this);
            this.writer.append(");").softNewLine();
            this.debugEmitter.emitCallSite();
            if (statement.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(InitClassStatement statement) {
        ClassHolder cls = this.classSource.get(statement.getClassName());
        if (cls == null) {
            return;
        }
        MethodReader method = cls.getMethod(new MethodDescriptor("<clinit>", Void.TYPE));
        if (method == null) {
            return;
        }
        try {
            this.debugEmitter.emitStatementStart();
            if (statement.getLocation() != null) {
                this.pushLocation(statement.getLocation());
            }
            this.writer.appendClass(statement.getClassName()).append("_$clinit();").softNewLine();
            if (statement.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    public String variableName(int index) {
        while (index >= this.cachedVariableNames.size()) {
            this.cachedVariableNames.add(null);
        }
        String name = this.cachedVariableNames.get(index);
        if (name == null) {
            name = this.generateVariableName(index);
            this.cachedVariableNames.set(index, name);
        }
        return name;
    }

    private String generateVariableName(int index) {
        if (index == 0) {
            return this.minifying ? "$t" : "$this";
        }
        Set<String> names = index < this.debugNames.size() ? this.debugNames.get(index) : null;
        StringBuilder sb = new StringBuilder();
        if (--index < variableNames.length()) {
            sb.append(Character.toString(variableNames.charAt(index)));
        } else {
            sb.append(Character.toString(variableNames.charAt(index % variableNames.length())) + index / variableNames.length());
        }
        if (!this.minifying && names != null && !names.isEmpty()) {
            ArrayList<String> nameList = new ArrayList<String>(names);
            Collections.sort(nameList);
            for (String name : nameList) {
                sb.append('_').append(name);
            }
        }
        return sb.toString();
    }

    private String pointerName() {
        return this.minifying ? "$p" : "$ptr";
    }

    private String mainLoopName() {
        return this.minifying ? "$m" : "$main";
    }

    private String tempVarName() {
        return this.minifying ? "$z" : "$tmp";
    }

    private String threadName() {
        return this.minifying ? "$T" : "$thread";
    }

    private void visitBinary(BinaryExpr expr, String op) {
        try {
            if (expr.getLocation() != null) {
                this.pushLocation(expr.getLocation());
            }
            Precedence outerPrecedence = this.precedence;
            Precedence innerPrecedence = Renderer.getPrecedence(expr.getOperation());
            if (innerPrecedence.ordinal() < outerPrecedence.ordinal()) {
                this.writer.append('(');
            }
            switch (expr.getOperation()) {
                case ADD: 
                case SUBTRACT: 
                case MULTIPLY: 
                case DIVIDE: 
                case MODULO: 
                case AND: 
                case OR: 
                case BITWISE_AND: 
                case BITWISE_OR: 
                case BITWISE_XOR: 
                case LEFT_SHIFT: 
                case RIGHT_SHIFT: 
                case UNSIGNED_RIGHT_SHIFT: {
                    this.precedence = innerPrecedence;
                    break;
                }
                default: {
                    this.precedence = innerPrecedence.next();
                }
            }
            expr.getFirstOperand().acceptVisitor(this);
            this.writer.ws().append(op).ws();
            switch (expr.getOperation()) {
                case ADD: 
                case MULTIPLY: 
                case AND: 
                case OR: 
                case BITWISE_AND: 
                case BITWISE_OR: 
                case BITWISE_XOR: {
                    this.precedence = innerPrecedence;
                    break;
                }
                default: {
                    this.precedence = innerPrecedence.next();
                }
            }
            expr.getSecondOperand().acceptVisitor(this);
            if (innerPrecedence.ordinal() < outerPrecedence.ordinal()) {
                this.writer.append(')');
            }
            if (expr.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    private static Precedence getPrecedence(BinaryOperation op) {
        switch (op) {
            case ADD: 
            case SUBTRACT: {
                return Precedence.ADDITION;
            }
            case MULTIPLY: 
            case DIVIDE: 
            case MODULO: {
                return Precedence.MULTIPLICATION;
            }
            case AND: {
                return Precedence.LOGICAL_AND;
            }
            case OR: {
                return Precedence.LOGICAL_OR;
            }
            case STRICT_EQUALS: 
            case STRICT_NOT_EQUALS: 
            case EQUALS: 
            case NOT_EQUALS: {
                return Precedence.EQUALITY;
            }
            case GREATER: 
            case GREATER_OR_EQUALS: 
            case LESS: 
            case LESS_OR_EQUALS: {
                return Precedence.COMPARISON;
            }
            case BITWISE_AND: {
                return Precedence.BITWISE_AND;
            }
            case BITWISE_OR: {
                return Precedence.BITWISE_OR;
            }
            case BITWISE_XOR: {
                return Precedence.BITWISE_XOR;
            }
            case LEFT_SHIFT: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: {
                return Precedence.BITWISE_SHIFT;
            }
        }
        return Precedence.GROUPING;
    }

    private void visitBinaryFunction(BinaryExpr expr, String function) {
        try {
            if (expr.getLocation() != null) {
                this.pushLocation(expr.getLocation());
            }
            this.writer.append(function);
            this.writer.append('(');
            this.precedence = Precedence.min();
            expr.getFirstOperand().acceptVisitor(this);
            this.writer.append(",").ws();
            this.precedence = Precedence.min();
            expr.getSecondOperand().acceptVisitor(this);
            this.writer.append(')');
            if (expr.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(BinaryExpr expr) {
        switch (expr.getOperation()) {
            case ADD: {
                this.visitBinary(expr, "+");
                break;
            }
            case ADD_LONG: {
                this.visitBinaryFunction(expr, "Long_add");
                break;
            }
            case SUBTRACT: {
                this.visitBinary(expr, "-");
                break;
            }
            case SUBTRACT_LONG: {
                this.visitBinaryFunction(expr, "Long_sub");
                break;
            }
            case MULTIPLY: {
                this.visitBinary(expr, "*");
                break;
            }
            case MULTIPLY_LONG: {
                this.visitBinaryFunction(expr, "Long_mul");
                break;
            }
            case DIVIDE: {
                this.visitBinary(expr, "/");
                break;
            }
            case DIVIDE_LONG: {
                this.visitBinaryFunction(expr, "Long_div");
                break;
            }
            case MODULO: {
                this.visitBinary(expr, "%");
                break;
            }
            case MODULO_LONG: {
                this.visitBinaryFunction(expr, "Long_rem");
                break;
            }
            case EQUALS: {
                this.visitBinary(expr, "==");
                break;
            }
            case NOT_EQUALS: {
                this.visitBinary(expr, "!=");
                break;
            }
            case GREATER: {
                this.visitBinary(expr, ">");
                break;
            }
            case GREATER_OR_EQUALS: {
                this.visitBinary(expr, ">=");
                break;
            }
            case LESS: {
                this.visitBinary(expr, "<");
                break;
            }
            case LESS_OR_EQUALS: {
                this.visitBinary(expr, "<=");
                break;
            }
            case STRICT_EQUALS: {
                this.visitBinary(expr, "===");
                break;
            }
            case STRICT_NOT_EQUALS: {
                this.visitBinary(expr, "!==");
                break;
            }
            case COMPARE: {
                this.visitBinaryFunction(expr, this.naming.getNameForFunction("$rt_compare"));
                break;
            }
            case COMPARE_LONG: {
                this.visitBinaryFunction(expr, "Long_compare");
                break;
            }
            case OR: {
                this.visitBinary(expr, "||");
                break;
            }
            case AND: {
                this.visitBinary(expr, "&&");
                break;
            }
            case BITWISE_OR: {
                this.visitBinary(expr, "|");
                break;
            }
            case BITWISE_OR_LONG: {
                this.visitBinaryFunction(expr, "Long_or");
                break;
            }
            case BITWISE_AND: {
                this.visitBinary(expr, "&");
                break;
            }
            case BITWISE_AND_LONG: {
                this.visitBinaryFunction(expr, "Long_and");
                break;
            }
            case BITWISE_XOR: {
                this.visitBinary(expr, "^");
                break;
            }
            case BITWISE_XOR_LONG: {
                this.visitBinaryFunction(expr, "Long_xor");
                break;
            }
            case LEFT_SHIFT: {
                this.visitBinary(expr, "<<");
                break;
            }
            case LEFT_SHIFT_LONG: {
                this.visitBinaryFunction(expr, "Long_shl");
                break;
            }
            case RIGHT_SHIFT: {
                this.visitBinary(expr, ">>");
                break;
            }
            case RIGHT_SHIFT_LONG: {
                this.visitBinaryFunction(expr, "Long_shr");
                break;
            }
            case UNSIGNED_RIGHT_SHIFT: {
                this.visitBinary(expr, ">>>");
                break;
            }
            case UNSIGNED_RIGHT_SHIFT_LONG: {
                this.visitBinaryFunction(expr, "Long_shru");
            }
        }
    }

    @Override
    public void visit(UnaryExpr expr) {
        try {
            if (expr.getLocation() != null) {
                this.pushLocation(expr.getLocation());
            }
            Precedence outerPrecedence = this.precedence;
            switch (expr.getOperation()) {
                case NOT: {
                    if (outerPrecedence.ordinal() > Precedence.UNARY.ordinal()) {
                        this.writer.append('(');
                    }
                    this.writer.append("!");
                    this.precedence = Precedence.UNARY;
                    expr.getOperand().acceptVisitor(this);
                    if (outerPrecedence.ordinal() <= Precedence.UNARY.ordinal()) break;
                    this.writer.append(')');
                    break;
                }
                case NEGATE: {
                    if (outerPrecedence.ordinal() > Precedence.UNARY.ordinal()) {
                        this.writer.append('(');
                    }
                    this.writer.append(" -");
                    this.precedence = Precedence.UNARY;
                    expr.getOperand().acceptVisitor(this);
                    if (outerPrecedence.ordinal() <= Precedence.UNARY.ordinal()) break;
                    this.writer.append(')');
                    break;
                }
                case LENGTH: {
                    this.precedence = Precedence.MEMBER_ACCESS;
                    expr.getOperand().acceptVisitor(this);
                    this.writer.append(".length");
                    break;
                }
                case INT_TO_LONG: {
                    this.writer.append("Long_fromInt(");
                    this.precedence = Precedence.min();
                    expr.getOperand().acceptVisitor(this);
                    this.writer.append(')');
                    break;
                }
                case NUM_TO_LONG: {
                    this.writer.append("Long_fromNumber(");
                    this.precedence = Precedence.min();
                    expr.getOperand().acceptVisitor(this);
                    this.writer.append(')');
                    break;
                }
                case LONG_TO_NUM: {
                    this.writer.append("Long_toNumber(");
                    this.precedence = Precedence.min();
                    expr.getOperand().acceptVisitor(this);
                    this.writer.append(')');
                    break;
                }
                case LONG_TO_INT: {
                    this.precedence = Precedence.MEMBER_ACCESS;
                    expr.getOperand().acceptVisitor(this);
                    this.writer.append(".lo");
                    break;
                }
                case NEGATE_LONG: {
                    this.writer.append("Long_neg(");
                    this.precedence = Precedence.min();
                    expr.getOperand().acceptVisitor(this);
                    this.writer.append(')');
                    break;
                }
                case NOT_LONG: {
                    this.writer.append("Long_not(");
                    this.precedence = Precedence.min();
                    expr.getOperand().acceptVisitor(this);
                    this.writer.append(')');
                    break;
                }
                case INT_TO_BYTE: {
                    if (outerPrecedence.ordinal() > Precedence.BITWISE_SHIFT.ordinal()) {
                        this.writer.append('(');
                    }
                    this.precedence = Precedence.BITWISE_SHIFT;
                    expr.getOperand().acceptVisitor(this);
                    this.writer.ws().append("<<").ws().append("24").ws().append(">>").ws().append("24");
                    if (outerPrecedence.ordinal() <= Precedence.BITWISE_SHIFT.ordinal()) break;
                    this.writer.append(')');
                    break;
                }
                case INT_TO_SHORT: {
                    if (outerPrecedence.ordinal() > Precedence.BITWISE_SHIFT.ordinal()) {
                        this.writer.append('(');
                    }
                    this.precedence = Precedence.BITWISE_SHIFT;
                    expr.getOperand().acceptVisitor(this);
                    this.writer.ws().append("<<").ws().append("16").ws().append(">>").ws().append("16");
                    if (outerPrecedence.ordinal() <= Precedence.BITWISE_SHIFT.ordinal()) break;
                    this.writer.append(')');
                    break;
                }
                case INT_TO_CHAR: {
                    if (outerPrecedence.ordinal() > Precedence.BITWISE_AND.ordinal()) {
                        this.writer.append('(');
                    }
                    this.precedence = Precedence.BITWISE_AND;
                    expr.getOperand().acceptVisitor(this);
                    this.writer.ws().append("&").ws().append("65535");
                    if (outerPrecedence.ordinal() <= Precedence.BITWISE_AND.ordinal()) break;
                    this.writer.append(')');
                    break;
                }
                case NULL_CHECK: {
                    this.writer.appendFunction("$rt_nullCheck").append("(");
                    this.precedence = Precedence.min();
                    expr.getOperand().acceptVisitor(this);
                    this.writer.append(')');
                }
            }
            if (expr.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(ConditionalExpr expr) {
        try {
            Precedence outerPrecedence;
            if (expr.getLocation() != null) {
                this.pushLocation(expr.getLocation());
            }
            if ((outerPrecedence = this.precedence).ordinal() > Precedence.CONDITIONAL.ordinal()) {
                this.writer.append('(');
            }
            this.precedence = Precedence.CONDITIONAL.next();
            expr.getCondition().acceptVisitor(this);
            this.writer.ws().append("?").ws();
            this.precedence = Precedence.CONDITIONAL.next();
            expr.getConsequent().acceptVisitor(this);
            this.writer.ws().append(":").ws();
            this.precedence = Precedence.CONDITIONAL;
            expr.getAlternative().acceptVisitor(this);
            if (outerPrecedence.ordinal() > Precedence.CONDITIONAL.ordinal()) {
                this.writer.append('(');
            }
            if (expr.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(ConstantExpr expr) {
        try {
            String str;
            if (expr.getLocation() != null) {
                this.pushLocation(expr.getLocation());
            }
            if ((str = this.constantToString(expr.getValue())).startsWith("-")) {
                this.writer.append(' ');
            }
            this.writer.append(str);
            if (expr.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    public String constantToString(Object cst) {
        if (cst == null) {
            return "null";
        }
        if (cst instanceof ValueType) {
            ValueType type = (ValueType)cst;
            return this.naming.getNameForFunction("$rt_cls") + "(" + Renderer.typeToClsString(this.naming, type) + ")";
        }
        if (cst instanceof String) {
            String string = (String)cst;
            Integer index = this.stringPoolMap.get(string);
            if (index == null) {
                index = this.stringPool.size();
                this.stringPool.add(string);
                this.stringPoolMap.put(string, index);
            }
            return "$rt_s(" + index + ")";
        }
        if (cst instanceof Long) {
            long value = (Long)cst;
            if (value == 0L) {
                return "Long_ZERO";
            }
            if ((long)((int)value) == value) {
                return "Long_fromInt(" + value + ")";
            }
            return "new Long(" + (value & 0xFFFFFFFFL) + ", " + (value >>> 32) + ")";
        }
        if (cst instanceof Character) {
            return Integer.toString(((Character)cst).charValue());
        }
        return cst.toString();
    }

    public static String typeToClsString(NamingStrategy naming, ValueType type) {
        String value;
        int arrayCount = 0;
        while (type instanceof ValueType.Array) {
            ++arrayCount;
            type = ((ValueType.Array)type).getItemType();
        }
        if (type instanceof ValueType.Object) {
            ValueType.Object objType = (ValueType.Object)type;
            value = naming.getNameFor(objType.getClassName());
        } else if (type instanceof ValueType.Void) {
            value = "$rt_voidcls()";
        } else if (type instanceof ValueType.Primitive) {
            ValueType.Primitive primitiveType = (ValueType.Primitive)type;
            switch (primitiveType.getKind()) {
                case BOOLEAN: {
                    value = "$rt_booleancls()";
                    break;
                }
                case CHARACTER: {
                    value = "$rt_charcls()";
                    break;
                }
                case BYTE: {
                    value = "$rt_bytecls()";
                    break;
                }
                case SHORT: {
                    value = "$rt_shortcls()";
                    break;
                }
                case INTEGER: {
                    value = "$rt_intcls()";
                    break;
                }
                case LONG: {
                    value = "$rt_longcls()";
                    break;
                }
                case FLOAT: {
                    value = "$rt_floatcls()";
                    break;
                }
                case DOUBLE: {
                    value = "$rt_doublecls()";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The type is not renderable");
                }
            }
        } else {
            throw new IllegalArgumentException("The type is not renderable");
        }
        for (int i = 0; i < arrayCount; ++i) {
            value = "$rt_arraycls(" + value + ")";
        }
        return value;
    }

    public static String escapeString(String str) {
        StringBuilder sb = new StringBuilder();
        block8: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block8;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block8;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block8;
                }
                default: {
                    if (c < ' ') {
                        sb.append("\\u00").append(Character.forDigit(c / 16, 16)).append(Character.forDigit(c % 16, 16));
                        continue block8;
                    }
                    if (Character.isLowSurrogate(c) || Character.isHighSurrogate(c)) {
                        sb.append("\\u").append(Character.forDigit(c / 4096, 16)).append(Character.forDigit(c / 256 % 16, 16)).append(Character.forDigit(c / 16 % 16, 16)).append(Character.forDigit(c % 16, 16));
                        continue block8;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    @Override
    public void visit(VariableExpr expr) {
        try {
            if (expr.getLocation() != null) {
                this.pushLocation(expr.getLocation());
            }
            this.writer.append(this.variableName(expr.getIndex()));
            if (expr.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(SubscriptExpr expr) {
        try {
            if (expr.getLocation() != null) {
                this.pushLocation(expr.getLocation());
            }
            this.precedence = Precedence.MEMBER_ACCESS;
            expr.getArray().acceptVisitor(this);
            this.writer.append('[');
            this.precedence = Precedence.min();
            expr.getIndex().acceptVisitor(this);
            this.writer.append(']');
            if (expr.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(UnwrapArrayExpr expr) {
        try {
            if (expr.getLocation() != null) {
                this.pushLocation(expr.getLocation());
            }
            this.precedence = Precedence.MEMBER_ACCESS;
            expr.getArray().acceptVisitor(this);
            this.writer.append(".data");
            if (expr.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(InvocationExpr expr) {
        try {
            Injector injector;
            if (expr.getLocation() != null) {
                this.pushLocation(expr.getLocation());
            }
            if ((injector = this.getInjector(expr.getMethod())) != null) {
                injector.generate(new InjectorContextImpl(expr.getArguments()), expr.getMethod());
            } else {
                boolean shouldEraseCallSite;
                if (expr.getType() == InvocationType.DYNAMIC) {
                    this.precedence = Precedence.MEMBER_ACCESS;
                    expr.getArguments().get(0).acceptVisitor(this);
                }
                MethodReference method = expr.getMethod();
                String name = this.naming.getNameFor(method.getDescriptor());
                DeferredCallSite callSite = this.prevCallSite;
                boolean bl = shouldEraseCallSite = this.lastCallSite == null;
                if (this.lastCallSite == null) {
                    this.lastCallSite = callSite;
                }
                boolean virtual = false;
                switch (expr.getType()) {
                    case STATIC: {
                        this.writer.append(this.naming.getFullNameFor(method)).append("(");
                        this.prevCallSite = this.debugEmitter.emitCallSite();
                        for (int i = 0; i < expr.getArguments().size(); ++i) {
                            if (i > 0) {
                                this.writer.append(",").ws();
                            }
                            this.precedence = Precedence.min();
                            expr.getArguments().get(i).acceptVisitor(this);
                        }
                        break;
                    }
                    case SPECIAL: {
                        this.writer.append(this.naming.getFullNameFor(method)).append("(");
                        this.prevCallSite = this.debugEmitter.emitCallSite();
                        this.precedence = Precedence.min();
                        expr.getArguments().get(0).acceptVisitor(this);
                        for (int i = 1; i < expr.getArguments().size(); ++i) {
                            this.writer.append(",").ws();
                            this.precedence = Precedence.min();
                            expr.getArguments().get(i).acceptVisitor(this);
                        }
                        break;
                    }
                    case DYNAMIC: {
                        this.writer.append(".").append(name).append("(");
                        this.prevCallSite = this.debugEmitter.emitCallSite();
                        for (int i = 1; i < expr.getArguments().size(); ++i) {
                            if (i > 1) {
                                this.writer.append(",").ws();
                            }
                            this.precedence = Precedence.min();
                            expr.getArguments().get(i).acceptVisitor(this);
                        }
                        virtual = true;
                        break;
                    }
                    case CONSTRUCTOR: {
                        this.writer.append(this.naming.getNameForInit(expr.getMethod())).append("(");
                        this.prevCallSite = this.debugEmitter.emitCallSite();
                        for (int i = 0; i < expr.getArguments().size(); ++i) {
                            if (i > 0) {
                                this.writer.append(",").ws();
                            }
                            this.precedence = Precedence.min();
                            expr.getArguments().get(i).acceptVisitor(this);
                        }
                        break;
                    }
                }
                this.writer.append(')');
                if (this.lastCallSite != null) {
                    if (virtual) {
                        this.lastCallSite.setVirtualMethod(expr.getMethod());
                    } else {
                        this.lastCallSite.setStaticMethod(expr.getMethod());
                    }
                    this.lastCallSite = callSite;
                }
                if (shouldEraseCallSite) {
                    this.lastCallSite = null;
                }
            }
            if (expr.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(QualificationExpr expr) {
        try {
            if (expr.getLocation() != null) {
                this.pushLocation(expr.getLocation());
            }
            this.precedence = Precedence.MEMBER_ACCESS;
            expr.getQualified().acceptVisitor(this);
            this.writer.append('.').appendField(expr.getField());
            if (expr.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(NewExpr expr) {
        try {
            if (expr.getLocation() != null) {
                this.pushLocation(expr.getLocation());
            }
            this.precedence = Precedence.FUNCTION_CALL;
            this.writer.append("new ").append(this.naming.getNameFor(expr.getConstructedClass()));
            if (expr.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(NewArrayExpr expr) {
        try {
            ValueType type;
            if (expr.getLocation() != null) {
                this.pushLocation(expr.getLocation());
            }
            if ((type = expr.getType()) instanceof ValueType.Primitive) {
                switch (((ValueType.Primitive)type).getKind()) {
                    case BOOLEAN: {
                        this.writer.append("$rt_createBooleanArray(");
                        this.precedence = Precedence.min();
                        expr.getLength().acceptVisitor(this);
                        this.writer.append(")");
                        break;
                    }
                    case BYTE: {
                        this.writer.append("$rt_createByteArray(");
                        this.precedence = Precedence.min();
                        expr.getLength().acceptVisitor(this);
                        this.writer.append(")");
                        break;
                    }
                    case SHORT: {
                        this.writer.append("$rt_createShortArray(");
                        this.precedence = Precedence.min();
                        expr.getLength().acceptVisitor(this);
                        this.writer.append(")");
                        break;
                    }
                    case INTEGER: {
                        this.writer.append("$rt_createIntArray(");
                        this.precedence = Precedence.min();
                        expr.getLength().acceptVisitor(this);
                        this.writer.append(")");
                        break;
                    }
                    case LONG: {
                        this.writer.append("$rt_createLongArray(");
                        this.precedence = Precedence.min();
                        expr.getLength().acceptVisitor(this);
                        this.writer.append(")");
                        break;
                    }
                    case FLOAT: {
                        this.writer.append("$rt_createFloatArray(");
                        this.precedence = Precedence.min();
                        expr.getLength().acceptVisitor(this);
                        this.writer.append(")");
                        break;
                    }
                    case DOUBLE: {
                        this.writer.append("$rt_createDoubleArray(");
                        this.precedence = Precedence.min();
                        expr.getLength().acceptVisitor(this);
                        this.writer.append(")");
                        break;
                    }
                    case CHARACTER: {
                        this.writer.append("$rt_createCharArray(");
                        this.precedence = Precedence.min();
                        expr.getLength().acceptVisitor(this);
                        this.writer.append(")");
                    }
                }
            } else {
                this.writer.appendFunction("$rt_createArray").append("(").append(Renderer.typeToClsString(this.naming, expr.getType())).append(",").ws();
                this.precedence = Precedence.min();
                expr.getLength().acceptVisitor(this);
                this.writer.append(")");
            }
            if (expr.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(NewMultiArrayExpr expr) {
        try {
            if (expr.getLocation() != null) {
                this.pushLocation(expr.getLocation());
            }
            ValueType type = expr.getType();
            for (int i = 0; i < expr.getDimensions().size(); ++i) {
                type = ((ValueType.Array)type).getItemType();
            }
            if (type instanceof ValueType.Primitive) {
                switch (((ValueType.Primitive)type).getKind()) {
                    case BOOLEAN: {
                        this.writer.append("$rt_createBooleanMultiArray(");
                        break;
                    }
                    case BYTE: {
                        this.writer.append("$rt_createByteMultiArray(");
                        break;
                    }
                    case SHORT: {
                        this.writer.append("$rt_createShortMultiArray(");
                        break;
                    }
                    case INTEGER: {
                        this.writer.append("$rt_createIntMultiArray(");
                        break;
                    }
                    case LONG: {
                        this.writer.append("$rt_createLongMultiArray(");
                        break;
                    }
                    case FLOAT: {
                        this.writer.append("$rt_createFloatMultiArray(");
                        break;
                    }
                    case DOUBLE: {
                        this.writer.append("$rt_createDoubleMultiArray(");
                        break;
                    }
                    case CHARACTER: {
                        this.writer.append("$rt_createCharMultiArray(");
                    }
                }
            } else {
                this.writer.append("$rt_createMultiArray(").append(Renderer.typeToClsString(this.naming, expr.getType())).append(",").ws();
            }
            this.writer.append("[");
            boolean first = true;
            ArrayList<Expr> dimensions = new ArrayList<Expr>(expr.getDimensions());
            Collections.reverse(dimensions);
            for (Expr dimension : dimensions) {
                if (!first) {
                    this.writer.append(",").ws();
                }
                first = false;
                this.precedence = Precedence.min();
                dimension.acceptVisitor(this);
            }
            this.writer.append("])");
            if (expr.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(InstanceOfExpr expr) {
        try {
            String clsName;
            ClassHolder cls;
            if (expr.getLocation() != null) {
                this.pushLocation(expr.getLocation());
            }
            if (expr.getType() instanceof ValueType.Object && (cls = this.classSource.get(clsName = ((ValueType.Object)expr.getType()).getClassName())) != null && !cls.getModifiers().contains((Object)ElementModifier.INTERFACE)) {
                this.precedence = Precedence.COMPARISON.next();
                expr.getExpr().acceptVisitor(this);
                this.writer.append(" instanceof ").appendClass(clsName);
                if (expr.getLocation() != null) {
                    this.popLocation();
                }
                return;
            }
            this.writer.appendFunction("$rt_isInstance").append("(");
            this.precedence = Precedence.min();
            expr.getExpr().acceptVisitor(this);
            this.writer.append(",").ws().append(Renderer.typeToClsString(this.naming, expr.getType())).append(")");
            if (expr.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(StaticClassExpr expr) {
        try {
            if (expr.getLocation() != null) {
                this.pushLocation(expr.getLocation());
            }
            this.writer.append(Renderer.typeToClsString(this.naming, expr.getType()));
            if (expr.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    private void visitStatements(List<Statement> statements) {
        if (statements.isEmpty()) {
            return;
        }
        boolean oldEnd = this.end;
        for (int i = 0; i < statements.size() - 1; ++i) {
            this.end = false;
            statements.get(i).acceptVisitor(this);
        }
        this.end = oldEnd;
        statements.get(statements.size() - 1).acceptVisitor(this);
        this.end = oldEnd;
    }

    @Override
    public void visit(TryCatchStatement statement) {
        try {
            this.writer.append("try").ws().append("{").softNewLine().indent();
            ArrayList<TryCatchStatement> sequence = new ArrayList<TryCatchStatement>();
            sequence.add(statement);
            List<Statement> protectedBody = statement.getProtectedBody();
            while (protectedBody.size() == 1 && protectedBody.get(0) instanceof TryCatchStatement) {
                TryCatchStatement nextStatement = (TryCatchStatement)protectedBody.get(0);
                sequence.add(nextStatement);
                protectedBody = nextStatement.getProtectedBody();
            }
            this.visitStatements(protectedBody);
            this.writer.outdent().append("}").ws().append("catch").ws().append("($e)").ws().append("{").indent().softNewLine();
            this.writer.append("$je").ws().append("=").ws().append("$e.$javaException;").softNewLine();
            for (TryCatchStatement catchClause : sequence) {
                this.writer.append("if").ws().append("($je");
                if (catchClause.getExceptionType() != null) {
                    this.writer.ws().append("&&").ws().append("$je instanceof ").appendClass(catchClause.getExceptionType());
                }
                this.writer.append(")").ws().append("{").indent().softNewLine();
                if (catchClause.getExceptionVariable() != null) {
                    this.writer.append(this.variableName(catchClause.getExceptionVariable())).ws().append("=").ws().append("$je;").softNewLine();
                }
                this.visitStatements(catchClause.getHandler());
                this.writer.outdent().append("}").ws().append("else ");
            }
            this.writer.append("{").indent().softNewLine();
            this.writer.append("throw $e;").softNewLine();
            this.writer.outdent().append("}").softNewLine();
            this.writer.outdent().append("}").softNewLine();
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(GotoPartStatement statement) {
        try {
            if (statement.getPart() != this.currentPart) {
                this.writer.append(this.pointerName()).ws().append("=").ws().append(statement.getPart()).append(";").softNewLine();
            }
            if (!this.end || statement.getPart() != this.currentPart + 1) {
                this.writer.append("continue ").append(this.mainLoopName()).append(";").softNewLine();
            }
        }
        catch (IOException ex) {
            throw new RenderingException("IO error occured", ex);
        }
    }

    @Override
    public void visit(MonitorEnterStatement statement) {
        try {
            if (this.async) {
                MethodReference monitorEnterRef = new MethodReference(Object.class, "monitorEnter", Object.class, Void.TYPE);
                this.writer.appendMethodBody(monitorEnterRef).append("(");
                this.precedence = Precedence.min();
                statement.getObjectRef().acceptVisitor(this);
                this.writer.append(");").softNewLine();
                this.emitSuspendChecker();
            } else {
                MethodReference monitorEnterRef = new MethodReference(Object.class, "monitorEnterSync", Object.class, Void.TYPE);
                this.writer.appendMethodBody(monitorEnterRef).append('(');
                this.precedence = Precedence.min();
                statement.getObjectRef().acceptVisitor(this);
                this.writer.append(");").softNewLine();
            }
        }
        catch (IOException ex) {
            throw new RenderingException("IO error occured", ex);
        }
    }

    private void emitSuspendChecker() throws IOException {
        this.writer.append("if").ws().append("(").appendFunction("$rt_suspending").append("())").ws().append("{").indent().softNewLine();
        this.writer.append("break ").append(this.mainLoopName()).append(";").softNewLine();
        this.writer.outdent().append("}").softNewLine();
    }

    @Override
    public void visit(MonitorExitStatement statement) {
        try {
            if (this.async) {
                MethodReference monitorExitRef = new MethodReference(Object.class, "monitorExit", Object.class, Void.TYPE);
                this.writer.appendMethodBody(monitorExitRef).append("(");
                this.precedence = Precedence.min();
                statement.getObjectRef().acceptVisitor(this);
                this.writer.append(");").softNewLine();
            } else {
                MethodReference monitorEnterRef = new MethodReference(Object.class, "monitorExitSync", Object.class, Void.TYPE);
                this.writer.appendMethodBody(monitorEnterRef).append('(');
                this.precedence = Precedence.min();
                statement.getObjectRef().acceptVisitor(this);
                this.writer.append(");").softNewLine();
            }
        }
        catch (IOException ex) {
            throw new RenderingException("IO error occured", ex);
        }
    }

    private Injector getInjector(MethodReference ref) {
        InjectorHolder holder = this.injectorMap.get(ref);
        if (holder == null) {
            AnnotationHolder injectedByAnnot;
            MethodHolder method;
            holder = new InjectorHolder(null);
            ClassHolder cls = this.classSource.get(ref.getClassName());
            if (cls != null && (method = cls.getMethod(ref.getDescriptor())) != null && (injectedByAnnot = method.getAnnotations().get(InjectedBy.class.getName())) != null) {
                ValueType type = injectedByAnnot.getValues().get("value").getJavaClass();
                holder = new InjectorHolder(this.instantiateInjector(((ValueType.Object)type).getClassName()));
            }
            this.injectorMap.put(ref, holder);
        }
        return holder.injector;
    }

    private Injector instantiateInjector(String type) {
        try {
            Class<Injector> cls = Class.forName(type, true, this.classLoader).asSubclass(Injector.class);
            Constructor<Injector> cons = cls.getConstructor(new Class[0]);
            return cons.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Illegal injector: " + type, e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Default constructor was not found in the " + type + " injector", e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Error instantiating injector " + type, e);
        }
    }

    @Override
    public <T> T getService(Class<T> type) {
        return this.services.getService(type);
    }

    private class InjectorContextImpl
    implements InjectorContext {
        private List<Expr> arguments;
        private Precedence precedence;

        public InjectorContextImpl(List<Expr> arguments) {
            this.precedence = Renderer.this.precedence;
            this.arguments = arguments;
        }

        @Override
        public Expr getArgument(int index) {
            return this.arguments.get(index);
        }

        @Override
        public boolean isMinifying() {
            return Renderer.this.minifying;
        }

        @Override
        public SourceWriter getWriter() {
            return Renderer.this.writer;
        }

        @Override
        public void writeEscaped(String str) throws IOException {
            Renderer.this.writer.append(Renderer.escapeString(str));
        }

        @Override
        public void writeType(ValueType type) throws IOException {
            Renderer.this.writer.append(Renderer.typeToClsString(Renderer.this.naming, type));
        }

        @Override
        public void writeExpr(Expr expr) throws IOException {
            this.writeExpr(expr, Precedence.GROUPING);
        }

        @Override
        public void writeExpr(Expr expr, Precedence precedence) throws IOException {
            Renderer.this.precedence = precedence;
            expr.acceptVisitor(Renderer.this);
        }

        @Override
        public int argumentCount() {
            return this.arguments.size();
        }

        @Override
        public <T> T getService(Class<T> type) {
            return Renderer.this.services.getService(type);
        }

        @Override
        public Properties getProperties() {
            return new Properties(Renderer.this.properties);
        }

        @Override
        public Precedence getPrecedence() {
            return this.precedence;
        }
    }

    private class MethodBodyRenderer
    implements MethodNodeVisitor,
    GeneratorContext {
        private boolean async;

        private MethodBodyRenderer() {
        }

        @Override
        public void visit(NativeMethodNode methodNode) {
            try {
                this.async = methodNode.isAsync();
                Renderer.this.async = methodNode.isAsync();
                methodNode.getGenerator().generate(this, Renderer.this.writer, methodNode.getReference());
            }
            catch (IOException e) {
                throw new RenderingException("IO error occured", e);
            }
        }

        @Override
        public void visit(RegularMethodNode method) {
            try {
                int i;
                Renderer.this.async = false;
                this.async = false;
                MethodReference ref = method.getReference();
                for (int i2 = 0; i2 < method.getParameterDebugNames().size(); ++i2) {
                    Renderer.this.debugEmitter.emitVariable(method.getParameterDebugNames().get(i2).toArray(new String[0]), Renderer.this.variableName(i2));
                }
                int variableCount = 0;
                for (int var : method.getVariables()) {
                    variableCount = Math.max(variableCount, var + 1);
                }
                TryCatchFinder tryCatchFinder = new TryCatchFinder();
                method.getBody().acceptVisitor(tryCatchFinder);
                boolean hasTryCatch = tryCatchFinder.tryCatchFound;
                ArrayList<String> variableNames = new ArrayList<String>();
                for (i = ref.parameterCount() + 1; i < variableCount; ++i) {
                    variableNames.add(Renderer.this.variableName(i));
                }
                if (hasTryCatch) {
                    variableNames.add("$je");
                }
                if (!variableNames.isEmpty()) {
                    Renderer.this.writer.append("var ");
                    for (i = 0; i < variableNames.size(); ++i) {
                        if (i > 0) {
                            Renderer.this.writer.append(",").ws();
                        }
                        Renderer.this.writer.append((String)variableNames.get(i));
                    }
                    Renderer.this.writer.append(";").softNewLine();
                }
                Renderer.this.end = true;
                Renderer.this.currentPart = 0;
                method.getBody().acceptVisitor(Renderer.this);
            }
            catch (IOException e) {
                throw new RenderingException("IO error occured", e);
            }
        }

        @Override
        public void visit(AsyncMethodNode methodNode) {
            try {
                int i;
                Renderer.this.async = true;
                this.async = true;
                MethodReference ref = methodNode.getReference();
                for (int i2 = 0; i2 < methodNode.getParameterDebugNames().size(); ++i2) {
                    Renderer.this.debugEmitter.emitVariable(methodNode.getParameterDebugNames().get(i2).toArray(new String[0]), Renderer.this.variableName(i2));
                }
                int variableCount = 0;
                for (int var : methodNode.getVariables()) {
                    variableCount = Math.max(variableCount, var + 1);
                }
                ArrayList<String> variableNames = new ArrayList<String>();
                for (int i3 = ref.parameterCount() + 1; i3 < variableCount; ++i3) {
                    variableNames.add(Renderer.this.variableName(i3));
                }
                TryCatchFinder tryCatchFinder = new TryCatchFinder();
                for (AsyncMethodPart part : methodNode.getBody()) {
                    if (tryCatchFinder.tryCatchFound) continue;
                    part.getStatement().acceptVisitor(tryCatchFinder);
                }
                boolean hasTryCatch = tryCatchFinder.tryCatchFound;
                if (hasTryCatch) {
                    variableNames.add("$je");
                }
                variableNames.add(Renderer.this.pointerName());
                variableNames.add(Renderer.this.tempVarName());
                if (!variableNames.isEmpty()) {
                    Renderer.this.writer.append("var ");
                    for (int i4 = 0; i4 < variableNames.size(); ++i4) {
                        if (i4 > 0) {
                            Renderer.this.writer.append(",").ws();
                        }
                        Renderer.this.writer.append((String)variableNames.get(i4));
                    }
                    Renderer.this.writer.append(";").softNewLine();
                }
                int firstToSave = 0;
                if (methodNode.getModifiers().contains((Object)NodeModifier.STATIC)) {
                    firstToSave = 1;
                }
                String popName = Renderer.this.minifying ? "l" : "pop";
                String pushName = Renderer.this.minifying ? "s" : "push";
                Renderer.this.writer.append(Renderer.this.pointerName()).ws().append('=').ws().append("0;").softNewLine();
                Renderer.this.writer.append("if").ws().append("(").appendFunction("$rt_resuming").append("())").ws().append("{").indent().softNewLine();
                Renderer.this.writer.append("var ").append(Renderer.this.threadName()).ws().append('=').ws().appendFunction("$rt_nativeThread").append("();").softNewLine();
                Renderer.this.writer.append(Renderer.this.pointerName()).ws().append('=').ws().append(Renderer.this.threadName()).append(".").append(popName).append("();");
                for (i = variableCount - 1; i >= firstToSave; --i) {
                    Renderer.this.writer.append(Renderer.this.variableName(i)).ws().append('=').ws().append(Renderer.this.threadName()).append(".").append(popName).append("();");
                }
                Renderer.this.writer.softNewLine();
                Renderer.this.writer.outdent().append("}").softNewLine();
                if (methodNode.getModifiers().contains((Object)NodeModifier.SYNCHRONIZED)) {
                    Renderer.this.writer.append("try").ws().append('{').indent().softNewLine();
                }
                Renderer.this.writer.append(Renderer.this.mainLoopName()).append(":").ws().append("while").ws().append("(true)").ws().append("{").ws();
                Renderer.this.writer.append("switch").ws().append("(").append(Renderer.this.pointerName()).append(")").ws().append('{').softNewLine();
                for (i = 0; i < methodNode.getBody().size(); ++i) {
                    Renderer.this.writer.append("case ").append(i).append(":").indent().softNewLine();
                    if (i == 0 && methodNode.getModifiers().contains((Object)NodeModifier.SYNCHRONIZED)) {
                        Renderer.this.writer.appendMethodBody(new MethodReference(Object.class, "monitorEnter", Object.class, Void.TYPE));
                        Renderer.this.writer.append("(");
                        Renderer.this.appendMonitor(methodNode);
                        Renderer.this.writer.append(");").softNewLine();
                        Renderer.this.emitSuspendChecker();
                    }
                    AsyncMethodPart part = methodNode.getBody().get(i);
                    Renderer.this.end = true;
                    Renderer.this.currentPart = i;
                    part.getStatement().acceptVisitor(Renderer.this);
                    Renderer.this.writer.outdent();
                }
                Renderer.this.writer.append("default:").ws().appendFunction("$rt_invalidPointer").append("();").softNewLine();
                Renderer.this.writer.append("}}").softNewLine();
                if (methodNode.getModifiers().contains((Object)NodeModifier.SYNCHRONIZED)) {
                    Renderer.this.writer.outdent().append("}").ws().append("finally").ws().append('{').indent().softNewLine();
                    Renderer.this.writer.append("if").ws().append("(!").appendFunction("$rt_suspending").append("())").ws().append("{").indent().softNewLine();
                    Renderer.this.writer.appendMethodBody(new MethodReference(Object.class, "monitorExit", Object.class, Void.TYPE));
                    Renderer.this.writer.append("(");
                    Renderer.this.appendMonitor(methodNode);
                    Renderer.this.writer.append(");").softNewLine();
                    Renderer.this.writer.outdent().append('}').softNewLine();
                    Renderer.this.writer.outdent().append('}').softNewLine();
                }
                Renderer.this.writer.appendFunction("$rt_nativeThread").append("().").append(pushName).append("(");
                for (i = firstToSave; i < variableCount; ++i) {
                    Renderer.this.writer.append(Renderer.this.variableName(i)).append(',').ws();
                }
                Renderer.this.writer.append(Renderer.this.pointerName()).append(");");
                Renderer.this.writer.softNewLine();
            }
            catch (IOException e) {
                throw new RenderingException("IO error occured", e);
            }
        }

        @Override
        public String getParameterName(int index) {
            return Renderer.this.variableName(index);
        }

        @Override
        public ListableClassReaderSource getClassSource() {
            return Renderer.this.classSource;
        }

        @Override
        public ClassLoader getClassLoader() {
            return Renderer.this.classLoader;
        }

        @Override
        public Properties getProperties() {
            return new Properties(Renderer.this.properties);
        }

        @Override
        public <T> T getService(Class<T> type) {
            return Renderer.this.services.getService(type);
        }

        @Override
        public boolean isAsync() {
            return this.async;
        }

        @Override
        public boolean isAsync(MethodReference method) {
            return Renderer.this.asyncMethods.contains(method);
        }

        @Override
        public boolean isAsyncFamily(MethodReference method) {
            return Renderer.this.asyncFamilyMethods.contains(method);
        }

        @Override
        public Diagnostics getDiagnostics() {
            return Renderer.this.diagnostics;
        }
    }

    private static class LocationStackEntry {
        NodeLocation location;

        public LocationStackEntry(NodeLocation location) {
            this.location = location;
        }
    }

    private static class InjectorHolder {
        public final Injector injector;

        public InjectorHolder(Injector injector) {
            this.injector = injector;
        }
    }
}

