/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.javascript;

import java.util.BitSet;
import java.util.List;
import org.teavm.common.Graph;
import org.teavm.javascript.BreakEliminator;
import org.teavm.javascript.OptimizingVisitor;
import org.teavm.javascript.ReadWriteStatsBuilder;
import org.teavm.javascript.RedundantLabelEliminator;
import org.teavm.javascript.UnusedVariableEliminator;
import org.teavm.javascript.ast.AsyncMethodNode;
import org.teavm.javascript.ast.AsyncMethodPart;
import org.teavm.javascript.ast.RegularMethodNode;
import org.teavm.model.Instruction;
import org.teavm.model.Program;
import org.teavm.model.Variable;
import org.teavm.model.util.AsyncProgramSplitter;
import org.teavm.model.util.DefinitionExtractor;
import org.teavm.model.util.LivenessAnalyzer;
import org.teavm.model.util.ProgramUtils;
import org.teavm.model.util.UsageExtractor;

public class Optimizer {
    public void optimize(RegularMethodNode method, Program program) {
        ReadWriteStatsBuilder stats = new ReadWriteStatsBuilder(method.getVariables().size());
        stats.analyze(program);
        boolean[] preservedVars = new boolean[stats.writes.length];
        for (int i = 0; i < preservedVars.length; ++i) {
            if (stats.writes[i] == 1) continue;
            preservedVars[i] = true;
        }
        BreakEliminator breakEliminator = new BreakEliminator();
        breakEliminator.eliminate(method.getBody());
        OptimizingVisitor optimizer = new OptimizingVisitor(preservedVars, stats.reads);
        method.getBody().acceptVisitor(optimizer);
        method.setBody(optimizer.resultStmt);
        int paramCount = method.getReference().parameterCount();
        UnusedVariableEliminator unusedEliminator = new UnusedVariableEliminator(paramCount, method.getVariables());
        method.getBody().acceptVisitor(unusedEliminator);
        method.getVariables().subList(unusedEliminator.lastIndex, method.getVariables().size()).clear();
        RedundantLabelEliminator labelEliminator = new RedundantLabelEliminator();
        method.getBody().acceptVisitor(labelEliminator);
        for (int i = 0; i < method.getVariables().size(); ++i) {
            method.getVariables().set(i, i);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void optimize(AsyncMethodNode method, AsyncProgramSplitter splitter) {
        void var8_15;
        LivenessAnalyzer liveness = new LivenessAnalyzer();
        liveness.analyze(splitter.getOriginalProgram());
        Graph cfg = ProgramUtils.buildControlFlowGraph(splitter.getOriginalProgram());
        for (int i = 0; i < splitter.size(); ++i) {
            void var8_10;
            boolean[] preservedVars = new boolean[method.getVariables().size()];
            ReadWriteStatsBuilder stats = new ReadWriteStatsBuilder(method.getVariables().size());
            stats.analyze(splitter.getProgram(i));
            boolean bl = false;
            while (var8_10 < stats.writes.length) {
                if (stats.writes[var8_10] != 1 && stats.reads[var8_10] > 0) {
                    preservedVars[var8_10] = true;
                }
                ++var8_10;
            }
            AsyncMethodPart asyncMethodPart = method.getBody().get(i);
            BreakEliminator breakEliminator = new BreakEliminator();
            breakEliminator.eliminate(asyncMethodPart.getStatement());
            this.findEscapingLiveVars(liveness, cfg, splitter, i, preservedVars);
            OptimizingVisitor optimizer = new OptimizingVisitor(preservedVars, stats.reads);
            asyncMethodPart.getStatement().acceptVisitor(optimizer);
            asyncMethodPart.setStatement(optimizer.resultStmt);
        }
        int paramCount = method.getReference().parameterCount();
        UnusedVariableEliminator unusedEliminator = new UnusedVariableEliminator(paramCount, method.getVariables());
        for (AsyncMethodPart asyncMethodPart : method.getBody()) {
            asyncMethodPart.getStatement().acceptVisitor(unusedEliminator);
        }
        method.getVariables().subList(unusedEliminator.lastIndex, method.getVariables().size()).clear();
        RedundantLabelEliminator labelEliminator = new RedundantLabelEliminator();
        for (AsyncMethodPart part : method.getBody()) {
            part.getStatement().acceptVisitor(labelEliminator);
        }
        boolean bl = false;
        while (var8_15 < method.getVariables().size()) {
            method.getVariables().set((int)var8_15, (int)var8_15);
            ++var8_15;
        }
    }

    private void findEscapingLiveVars(LivenessAnalyzer liveness, Graph cfg, AsyncProgramSplitter splitter, int partIndex, boolean[] output) {
        Program originalProgram = splitter.getOriginalProgram();
        Program program = splitter.getProgram(partIndex);
        int[] successors = splitter.getBlockSuccessors(partIndex);
        int[] splitPoints = splitter.getSplitPoints(partIndex);
        int[] originalBlocks = splitter.getOriginalBlocks(partIndex);
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            int j;
            if (successors[i] < 0 || originalBlocks[i] < 0) continue;
            BitSet liveVars = new BitSet();
            for (int succ : cfg.outgoingEdges(originalBlocks[i])) {
                liveVars.or(liveness.liveIn(succ));
            }
            DefinitionExtractor defExtractor = new DefinitionExtractor();
            UsageExtractor useExtractor = new UsageExtractor();
            List<Instruction> instructions = originalProgram.basicBlockAt(originalBlocks[i]).getInstructions();
            int splitPoint = splitPoints[i];
            for (j = instructions.size() - 1; j >= splitPoint; --j) {
                instructions.get(j).acceptVisitor(defExtractor);
                instructions.get(j).acceptVisitor(useExtractor);
                for (Variable var : defExtractor.getDefinedVariables()) {
                    liveVars.clear(var.getIndex());
                }
                for (Variable var : useExtractor.getUsedVariables()) {
                    liveVars.set(var.getIndex());
                }
            }
            j = liveVars.nextSetBit(0);
            while (j >= 0) {
                output[j] = true;
                j = liveVars.nextSetBit(j + 1);
            }
        }
    }
}

