/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.tooling.sources;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.teavm.debugging.information.SourceFileResolver;
import org.teavm.tooling.TeaVMSourceFilePolicy;
import org.teavm.tooling.sources.SourceFileInfo;
import org.teavm.tooling.sources.SourceFileProvider;

public class DefaultSourceFileResolver
implements SourceFileResolver {
    private File targetDir;
    private String srcSubdir = "";
    private List<SourceFileProvider> sourceFileProviders;
    private TeaVMSourceFilePolicy sourceFilePolicy = TeaVMSourceFilePolicy.DO_NOTHING;

    public DefaultSourceFileResolver(File targetDir, List<SourceFileProvider> sourceFileProviders) {
        this.targetDir = targetDir;
        this.sourceFileProviders = sourceFileProviders;
    }

    public void setSrcSubdir(String srcSubdir) {
        this.srcSubdir = srcSubdir;
    }

    public void setSourceFilePolicy(TeaVMSourceFilePolicy sourceFilePolicy) {
        this.sourceFilePolicy = sourceFilePolicy;
    }

    public void open() throws IOException {
        for (SourceFileProvider provider : this.sourceFileProviders) {
            provider.open();
        }
    }

    public String resolveFile(String file) throws IOException {
        File outputDir = this.srcSubdir.isEmpty() ? this.targetDir : new File(this.targetDir, this.srcSubdir);
        for (SourceFileProvider provider : this.sourceFileProviders) {
            SourceFileInfo sourceFile = provider.getSourceFile(file);
            if (sourceFile == null) continue;
            if (this.sourceFilePolicy == TeaVMSourceFilePolicy.COPY || sourceFile.getFile() == null) {
                File outputFile = new File(outputDir, file);
                outputFile.getParentFile().mkdirs();
                try (InputStream input = sourceFile.open();
                     FileOutputStream output = new FileOutputStream(outputFile);){
                    input.transferTo(output);
                }
                if (this.sourceFilePolicy == TeaVMSourceFilePolicy.LINK_LOCAL_FILES) {
                    return DefaultSourceFileResolver.fileToUrl(outputFile);
                }
                if (this.srcSubdir.isEmpty()) {
                    return file;
                }
                if (this.srcSubdir.endsWith("/")) {
                    return this.srcSubdir + file;
                }
                return this.srcSubdir + "/" + file;
            }
            return DefaultSourceFileResolver.fileToUrl(sourceFile.getFile());
        }
        return null;
    }

    public void close() throws IOException {
        for (SourceFileProvider provider : this.sourceFileProviders) {
            provider.close();
        }
    }

    private static String fileToUrl(File file) throws IOException {
        Object path = file.getCanonicalPath();
        path = !((String)path).startsWith("/") ? "file:///" + ((String)path).replace('\\', '/') : "file://" + (String)path;
        return path;
    }
}

