/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.tooling.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class FileSystemWatcher {
    private WatchService watchService;
    private Map<WatchKey, Path> keysToPath = new HashMap<WatchKey, Path>();
    private Map<Path, WatchKey> pathsToKey = new HashMap<Path, WatchKey>();
    private Map<Path, Integer> refCount = new HashMap<Path, Integer>();
    private Set<File> changedFiles = new LinkedHashSet<File>();

    public FileSystemWatcher(String[] classPath) throws IOException {
        this.watchService = FileSystems.getDefault().newWatchService();
        for (String entry : classPath) {
            Path path = Paths.get(entry, new String[0]);
            File file = path.toFile();
            if (!file.exists() || !file.isDirectory()) continue;
            this.register(path);
        }
    }

    public void dispose() throws IOException {
        this.watchService.close();
    }

    private List<Path> register(Path path) throws IOException {
        final ArrayList<Path> files = new ArrayList<Path>();
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                FileSystemWatcher.this.registerSingle(dir);
                files.addAll(Arrays.stream(dir.toFile().listFiles(File::isFile)).map(File::toPath).collect(Collectors.toList()));
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                Path parent = file.getParent();
                FileSystemWatcher.this.refCount.put(parent, FileSystemWatcher.this.refCount.getOrDefault(parent, 0) + 1);
                return FileVisitResult.CONTINUE;
            }
        });
        return files;
    }

    private void registerSingle(Path path) throws IOException {
        WatchKey key = path.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        this.keysToPath.put(key, path);
        this.pathsToKey.put(path, key);
        this.refCount.put(path, this.refCount.getOrDefault(path, 0) + 1);
        Path parent = path.getParent();
        this.refCount.put(parent, this.refCount.getOrDefault(parent, 0) + 1);
    }

    public boolean hasChanges() throws IOException {
        return !this.changedFiles.isEmpty() || this.pollNow();
    }

    public void pollChanges() throws IOException {
        while (this.pollNow()) {
        }
    }

    public void waitForChange(int timeout) throws InterruptedException, IOException {
        if (!this.hasChanges()) {
            this.take();
        }
        if (timeout > 0) {
            while (this.poll(timeout)) {
            }
        }
        this.pollChanges();
    }

    public List<File> grabChangedFiles() {
        ArrayList<File> result = new ArrayList<File>(this.changedFiles);
        this.changedFiles.clear();
        return result;
    }

    private void take() throws InterruptedException, IOException {
        WatchKey key;
        while ((key = this.watchService.take()) == null || !this.filter(key)) {
        }
    }

    private boolean poll(int milliseconds) throws IOException, InterruptedException {
        int timeToWait;
        WatchKey key;
        long end = System.currentTimeMillis() + (long)milliseconds;
        do {
            if ((timeToWait = (int)(end - System.currentTimeMillis())) > 0) continue;
            return false;
        } while ((key = this.watchService.poll(timeToWait, TimeUnit.MILLISECONDS)) == null || !this.filter(key));
        return true;
    }

    private boolean pollNow() throws IOException {
        WatchKey key = this.watchService.poll();
        if (key == null) {
            return false;
        }
        return this.filter(key);
    }

    private boolean filter(WatchKey key) throws IOException {
        boolean hasNew = false;
        for (WatchEvent<?> event : key.pollEvents()) {
            List<Path> paths = this.filter(key, event);
            if (paths.isEmpty()) continue;
            this.changedFiles.addAll(paths.stream().map(Path::toFile).collect(Collectors.toList()));
            hasNew = true;
        }
        key.reset();
        return hasNew;
    }

    private List<Path> filter(WatchKey baseKey, WatchEvent<?> event) throws IOException {
        if (!(event.context() instanceof Path)) {
            return Collections.emptyList();
        }
        Path basePath = this.keysToPath.get(baseKey);
        Path path = basePath.resolve((Path)event.context());
        WatchKey key = this.pathsToKey.get(path);
        ArrayList<Path> result = new ArrayList<Path>();
        result.add(path);
        if (event.kind() == StandardWatchEventKinds.ENTRY_DELETE) {
            if (key != null) {
                key.cancel();
                this.releasePath(path);
            }
        } else if (event.kind() == StandardWatchEventKinds.ENTRY_CREATE && Files.isDirectory(path, new LinkOption[0])) {
            result.addAll(this.register(path));
        }
        return result;
    }

    private void releasePath(Path path) {
        WatchKey key;
        this.refCount.put(path, this.refCount.getOrDefault(path, 0) - 1);
        while (this.refCount.getOrDefault(path, 0) <= 0 && (key = this.pathsToKey.get(path)) != null) {
            this.pathsToKey.remove(path);
            this.keysToPath.remove(key);
            path = path.getParent();
            this.refCount.put(path, this.refCount.getOrDefault(path, 0) - 1);
        }
    }
}

