/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.hppc;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.teavm.hppc.ObjectCollection;
import org.teavm.hppc.ObjectLookupContainer;
import org.teavm.hppc.cursors.ObjectCursor;
import org.teavm.hppc.predicates.ObjectPredicate;

abstract class AbstractObjectCollection<KType>
implements ObjectCollection<KType> {
    AbstractObjectCollection() {
    }

    @Override
    public int removeAll(ObjectLookupContainer<? super KType> c) {
        return this.removeAll(c::contains);
    }

    @Override
    public int retainAll(ObjectLookupContainer<? super KType> c) {
        return this.removeAll((? super KType k) -> !c.contains(k));
    }

    @Override
    public int retainAll(ObjectPredicate<? super KType> predicate) {
        return this.removeAll((? super KType value) -> !predicate.apply(value));
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        int i = 0;
        for (ObjectCursor c : this) {
            array[i++] = c.value;
        }
        return array;
    }

    @Override
    public <T> T[] toArray(Class<T> componentClass) {
        int size = this.size();
        Object[] array = (Object[])Array.newInstance(componentClass, size);
        int i = 0;
        for (ObjectCursor c : this) {
            array[i++] = c.value;
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    protected boolean equals(Object v1, Object v2) {
        return v1 == v2 || v1 != null && v1.equals(v2);
    }
}

