/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.apachecommons.cli;

import java.io.File;
import java.io.FileInputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.file.Path;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.teavm.apachecommons.cli.Converter;
import org.teavm.apachecommons.cli.ParseException;

public class TypeHandler {
    private static final TypeHandler DEFAULT = new TypeHandler();
    private static final int HEX_RADIX = 16;
    private final Map<Class<?>, Converter<?, ? extends Throwable>> converterMap;

    public static Class<?> createClass(String className) throws ParseException {
        return TypeHandler.createValue(className, Class.class);
    }

    public static Date createDate(String string) {
        return TypeHandler.createValueUnchecked(string, Date.class);
    }

    public static Map<Class<?>, Converter<?, ? extends Throwable>> createDefaultMap() {
        return TypeHandler.putDefaultMap(new HashMap());
    }

    public static File createFile(String string) {
        return TypeHandler.createValueUnchecked(string, File.class);
    }

    @Deprecated
    public static File[] createFiles(String string) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Deprecated
    public static Number createNumber(String string) throws ParseException {
        return TypeHandler.createValue(string, Number.class);
    }

    @Deprecated
    public static Object createObject(String className) throws ParseException {
        return TypeHandler.createValue(className, Object.class);
    }

    public static URL createURL(String string) throws ParseException {
        return TypeHandler.createValue(string, URL.class);
    }

    public static <T> T createValue(String string, Class<T> clazz) throws ParseException {
        try {
            return TypeHandler.getDefault().getConverter(clazz).apply(string);
        }
        catch (Exception e) {
            throw ParseException.wrap(e);
        }
    }

    @Deprecated
    public static Object createValue(String string, Object obj) throws ParseException {
        return TypeHandler.createValue(string, (Class)obj);
    }

    private static <T> T createValueUnchecked(String string, Class<T> clazz) {
        try {
            return TypeHandler.createValue(string, clazz);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static TypeHandler getDefault() {
        return DEFAULT;
    }

    @Deprecated
    public static FileInputStream openFile(String string) throws ParseException {
        return TypeHandler.createValue(string, FileInputStream.class);
    }

    private static Map<Class<?>, Converter<?, ? extends Throwable>> putDefaultMap(Map<Class<?>, Converter<?, ? extends Throwable>> map) {
        map.put(Object.class, Converter.OBJECT);
        map.put(Class.class, Converter.CLASS);
        map.put(Date.class, Converter.DATE);
        map.put(File.class, Converter.FILE);
        map.put(Path.class, Converter.PATH);
        map.put(Number.class, Converter.NUMBER);
        map.put(URL.class, Converter.URL);
        map.put(FileInputStream.class, FileInputStream::new);
        map.put(Long.class, Long::parseLong);
        map.put(Integer.class, Integer::parseInt);
        map.put(Short.class, Short::parseShort);
        map.put(Byte.class, Byte::parseByte);
        map.put(Character.class, s -> Character.valueOf(s.startsWith("\\u") ? Character.toChars(Integer.parseInt(s.substring(2), 16))[0] : s.charAt(0)));
        map.put(Double.class, Double::parseDouble);
        map.put(Float.class, Float::parseFloat);
        map.put(BigInteger.class, BigInteger::new);
        map.put(BigDecimal.class, BigDecimal::new);
        return map;
    }

    public TypeHandler() {
        this(TypeHandler.createDefaultMap());
    }

    public TypeHandler(Map<Class<?>, Converter<?, ? extends Throwable>> converterMap) {
        this.converterMap = Objects.requireNonNull(converterMap, "converterMap");
    }

    public <T> Converter<T, ?> getConverter(Class<T> clazz) {
        return this.converterMap.getOrDefault(clazz, Converter.DEFAULT);
    }
}

