/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.apachecommons.cli.help;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.teavm.apachecommons.cli.Option;
import org.teavm.apachecommons.cli.OptionGroup;
import org.teavm.apachecommons.cli.Options;
import org.teavm.apachecommons.cli.help.HelpAppendable;
import org.teavm.apachecommons.cli.help.OptionFormatter;
import org.teavm.apachecommons.cli.help.TableDefinition;
import org.teavm.apachecommons.cli.help.TextHelpAppendable;
import org.teavm.apachecommons.cli.help.Util;

public abstract class AbstractHelpFormatter {
    public static final Comparator<Option> DEFAULT_COMPARATOR = (opt1, opt2) -> opt1.getKey().compareToIgnoreCase(opt2.getKey());
    public static final String DEFAULT_OPTION_GROUP_SEPARATOR = " | ";
    public static final String DEFAULT_SYNTAX_PREFIX = "usage: ";
    private final Comparator<Option> comparator;
    private final HelpAppendable helpAppendable;
    private final OptionFormatter.Builder optionFormatBuilder;
    private final String optionGroupSeparator;
    private String syntaxPrefix = "usage: ";

    protected AbstractHelpFormatter(Builder<?, ?> builder) {
        this.helpAppendable = Objects.requireNonNull(builder.getHelpAppendable(), "helpAppendable");
        this.optionFormatBuilder = Objects.requireNonNull(builder.getOptionFormatBuilder(), "optionFormatBuilder");
        this.comparator = Objects.requireNonNull(builder.getComparator(), "comparator");
        this.optionGroupSeparator = Util.defaultValue(builder.getOptionGroupSeparator(), "");
    }

    protected Comparator<Option> getComparator() {
        return this.comparator;
    }

    protected HelpAppendable getHelpAppendable() {
        return this.helpAppendable;
    }

    protected OptionFormatter.Builder getOptionFormatBuilder() {
        return this.optionFormatBuilder;
    }

    public final OptionFormatter getOptionFormatter(Option option) {
        return this.optionFormatBuilder.build(option);
    }

    protected String getOptionGroupSeparator() {
        return this.optionGroupSeparator;
    }

    public final HelpAppendable getSerializer() {
        return this.helpAppendable;
    }

    public final String getSyntaxPrefix() {
        return this.syntaxPrefix;
    }

    protected abstract TableDefinition getTableDefinition(Iterable<Option> var1);

    public void printHelp(String cmdLineSyntax, String header, Iterable<Option> options, String footer, boolean autoUsage) throws IOException {
        if (Util.isEmpty(cmdLineSyntax)) {
            throw new IllegalArgumentException("cmdLineSyntax not provided");
        }
        if (autoUsage) {
            this.helpAppendable.appendParagraphFormat("%s %s %s", this.syntaxPrefix, cmdLineSyntax, this.toSyntaxOptions(options));
        } else {
            this.helpAppendable.appendParagraphFormat("%s %s", this.syntaxPrefix, cmdLineSyntax);
        }
        if (!Util.isEmpty(header)) {
            this.helpAppendable.appendParagraph(header);
        }
        this.helpAppendable.appendTable(this.getTableDefinition(options));
        if (!Util.isEmpty(footer)) {
            this.helpAppendable.appendParagraph(footer);
        }
    }

    public final void printHelp(String cmdLineSyntax, String header, Options options, String footer, boolean autoUsage) throws IOException {
        this.printHelp(cmdLineSyntax, header, options.getOptions(), footer, autoUsage);
    }

    public final void printOptions(Iterable<Option> options) throws IOException {
        this.printOptions(this.getTableDefinition(options));
    }

    public final void printOptions(Options options) throws IOException {
        this.printOptions(options.getOptions());
    }

    public final void printOptions(TableDefinition tableDefinition) throws IOException {
        this.helpAppendable.appendTable(tableDefinition);
    }

    public final void setSyntaxPrefix(String prefix) {
        this.syntaxPrefix = prefix;
    }

    public List<Option> sort(Iterable<Option> options) {
        ArrayList<Option> result = new ArrayList<Option>();
        if (options != null) {
            options.forEach(result::add);
            result.sort(this.comparator);
        }
        return result;
    }

    public List<Option> sort(Options options) {
        return this.sort(options == null ? null : options.getOptions());
    }

    public final String toArgName(String argName) {
        return this.optionFormatBuilder.toArgName(argName);
    }

    public String toSyntaxOptions(Iterable<Option> options) {
        return this.toSyntaxOptions(options, o -> null);
    }

    protected String toSyntaxOptions(Iterable<Option> options, Function<Option, OptionGroup> lookup) {
        ArrayList<OptionGroup> processedGroups = new ArrayList<OptionGroup>();
        List<Option> optList = this.sort(options);
        StringBuilder buff = new StringBuilder();
        String prefix = "";
        for (Option option : optList) {
            OptionGroup optionGroup = lookup.apply(option);
            if (optionGroup != null) {
                if (processedGroups.contains(optionGroup)) continue;
                processedGroups.add(optionGroup);
                buff.append(prefix).append(this.toSyntaxOptions(optionGroup));
                prefix = " ";
                continue;
            }
            buff.append(prefix).append(this.optionFormatBuilder.build(option).toSyntaxOption());
            prefix = " ";
        }
        return buff.toString();
    }

    public String toSyntaxOptions(OptionGroup group) {
        StringBuilder buff = new StringBuilder();
        List<Option> optList = this.sort(group.getOptions());
        OptionFormatter formatter = null;
        Iterator<Option> iter = optList.iterator();
        while (iter.hasNext()) {
            formatter = this.optionFormatBuilder.build(iter.next());
            buff.append(formatter.toSyntaxOption(true));
            if (!iter.hasNext()) continue;
            buff.append(this.optionGroupSeparator);
        }
        if (formatter != null) {
            return group.isRequired() ? buff.toString() : formatter.toOptional(buff.toString());
        }
        return "";
    }

    public String toSyntaxOptions(Options options) {
        return this.toSyntaxOptions(options.getOptions(), options::getOptionGroup);
    }

    public static abstract class Builder<B extends Builder<B, T>, T extends AbstractHelpFormatter>
    implements Supplier<T> {
        private Comparator<Option> comparator = DEFAULT_COMPARATOR;
        private HelpAppendable helpAppendable = TextHelpAppendable.systemOut();
        private OptionFormatter.Builder optionFormatBuilder = OptionFormatter.builder();
        private String optionGroupSeparator = " | ";

        protected Builder() {
        }

        protected B asThis() {
            return (B)this;
        }

        protected Comparator<Option> getComparator() {
            return this.comparator;
        }

        protected HelpAppendable getHelpAppendable() {
            return this.helpAppendable;
        }

        protected OptionFormatter.Builder getOptionFormatBuilder() {
            return this.optionFormatBuilder;
        }

        protected String getOptionGroupSeparator() {
            return this.optionGroupSeparator;
        }

        public B setComparator(Comparator<Option> comparator) {
            this.comparator = comparator;
            return this.asThis();
        }

        public B setHelpAppendable(HelpAppendable helpAppendable) {
            this.helpAppendable = helpAppendable != null ? helpAppendable : TextHelpAppendable.systemOut();
            return this.asThis();
        }

        public B setOptionFormatBuilder(OptionFormatter.Builder optionFormatBuilder) {
            this.optionFormatBuilder = optionFormatBuilder != null ? optionFormatBuilder : OptionFormatter.builder();
            return this.asThis();
        }

        public B setOptionGroupSeparator(String optionGroupSeparator) {
            this.optionGroupSeparator = Util.defaultValue(optionGroupSeparator, "");
            return this.asThis();
        }
    }
}

