/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import org.teavm.backend.javascript.spi.GeneratedBy;
import org.teavm.cache.NoCache;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.model.AccessLevel;
import org.teavm.model.AnnotationContainer;
import org.teavm.model.AnnotationContainerReader;
import org.teavm.model.AnnotationHolder;
import org.teavm.model.AnnotationValue;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldHolder;
import org.teavm.model.MethodHolder;
import org.teavm.model.ValueType;
import org.teavm.model.emit.ProgramEmitter;
import org.teavm.model.emit.ValueEmitter;
import org.teavm.model.util.ModelUtils;
import org.teavm.platform.PlatformClass;
import org.teavm.platform.metadata.ClassScopedMetadataProvider;
import org.teavm.platform.metadata.MetadataProvider;
import org.teavm.platform.plugin.ClassScopedMetadataProviderNativeGenerator;
import org.teavm.platform.plugin.MetadataProviderNativeGenerator;
import org.teavm.platform.plugin.MetadataProviderRef;

class MetadataProviderTransformer
implements ClassHolderTransformer {
    static int fieldIdGen;

    MetadataProviderTransformer() {
    }

    public void transformClass(ClassHolder cls, ClassReaderSource innerSource, Diagnostics diagnostics) {
        for (MethodHolder method : cls.getMethods().toArray(new MethodHolder[0])) {
            AnnotationHolder providerAnnot = method.getAnnotations().get(MetadataProvider.class.getName());
            if (providerAnnot != null) {
                this.transformMetadataMethod(cls, method, diagnostics, innerSource);
            }
            if ((providerAnnot = method.getAnnotations().get(ClassScopedMetadataProvider.class.getName())) == null) continue;
            ValueType[] params = method.getParameterTypes();
            if (params.length != 1 && params[0].isObject(PlatformClass.class.getName())) {
                diagnostics.error(new CallLocation(method.getReference()), "Method {{m0}} marked with {{c1}} must take exactly one parameter of type {{c2}}", new Object[]{method.getReference(), ClassScopedMetadataProvider.class.getName(), PlatformClass.class.getName()});
            }
            AnnotationHolder genAnnot = new AnnotationHolder(GeneratedBy.class.getName());
            genAnnot.getValues().put("value", new AnnotationValue(ValueType.object((String)ClassScopedMetadataProviderNativeGenerator.class.getName())));
            method.getAnnotations().add(genAnnot);
            AnnotationHolder noCacheAnnot = new AnnotationHolder(NoCache.class.getName());
            method.getAnnotations().add(noCacheAnnot);
        }
    }

    private void transformMetadataMethod(ClassHolder cls, MethodHolder method, Diagnostics diagnostics, ClassReaderSource classSource) {
        if (!this.validate(method, diagnostics)) {
            return;
        }
        FieldHolder field = new FieldHolder("$$metadata$$" + fieldIdGen++);
        field.setType(method.getResultType());
        field.setLevel(AccessLevel.PRIVATE);
        field.getModifiers().add(ElementModifier.STATIC);
        cls.addField(field);
        MethodHolder createMethod = new MethodHolder(method.getName() + "$$create", method.getSignature());
        createMethod.setLevel(AccessLevel.PRIVATE);
        createMethod.getModifiers().add(ElementModifier.NATIVE);
        createMethod.getModifiers().add(ElementModifier.STATIC);
        cls.addMethod(createMethod);
        AnnotationHolder genAnnot = new AnnotationHolder(GeneratedBy.class.getName());
        genAnnot.getValues().put("value", new AnnotationValue(ValueType.object((String)MetadataProviderNativeGenerator.class.getName())));
        createMethod.getAnnotations().add(genAnnot);
        ModelUtils.copyAnnotations((AnnotationContainerReader)method.getAnnotations(), (AnnotationContainer)createMethod.getAnnotations());
        AnnotationHolder refAnnot = new AnnotationHolder(MetadataProviderRef.class.getName());
        refAnnot.getValues().put("value", new AnnotationValue(method.getReference().toString()));
        createMethod.getAnnotations().add(refAnnot);
        method.getModifiers().remove(ElementModifier.NATIVE);
        ProgramEmitter pe = ProgramEmitter.create((MethodHolder)method, (ClassReaderSource)classSource);
        pe.when(pe.getField(field.getReference(), field.getType()).isNull()).thenDo(() -> pe.setField(field.getReference(), pe.invoke(createMethod.getReference().getClassName(), createMethod.getReference().getName(), createMethod.getResultType(), new ValueEmitter[0])));
        pe.getField(field.getReference(), field.getType()).returnValue();
        AnnotationHolder noCacheAnnot = new AnnotationHolder(NoCache.class.getName());
        method.getAnnotations().add(noCacheAnnot);
    }

    private boolean validate(MethodHolder method, Diagnostics diagnostics) {
        AnnotationHolder providerAnnot = method.getAnnotations().get(MetadataProvider.class.getName());
        if (providerAnnot == null) {
            return false;
        }
        if (!method.hasModifier(ElementModifier.NATIVE)) {
            diagnostics.error(new CallLocation(method.getReference()), "Method {{m0}} is marked with {{c1}} annotation, but it is not native", new Object[]{method.getReference(), MetadataProvider.class.getName()});
            return false;
        }
        return true;
    }
}

