/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.model.AnnotationReader;
import org.teavm.model.CallLocation;
import org.teavm.model.MethodReader;
import org.teavm.model.ValueType;
import org.teavm.platform.metadata.MetadataGenerator;
import org.teavm.platform.metadata.MetadataProvider;

public final class MetadataUtils {
    private MetadataUtils() {
    }

    public static MetadataGenerator createMetadataGenerator(ClassLoader classLoader, MethodReader method, CallLocation callLocation, Diagnostics diagnostics) {
        MetadataGenerator generator;
        Constructor<?> cons;
        Class<?> generatorClass;
        AnnotationReader annot = method.getAnnotations().get(MetadataProvider.class.getName());
        ValueType generatorType = annot.getValue("value").getJavaClass();
        String generatorClassName = ((ValueType.Object)generatorType).getClassName();
        try {
            generatorClass = Class.forName(generatorClassName, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            diagnostics.error(callLocation, "Can't find metadata provider class {{c0}}", new Object[]{generatorClassName});
            return null;
        }
        try {
            cons = generatorClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            diagnostics.error(callLocation, "Metadata generator {{c0}} does not have a public no-arg constructor", new Object[]{generatorClassName});
            return null;
        }
        try {
            generator = (MetadataGenerator)cons.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            diagnostics.error(callLocation, "Error instantiating metadata generator {{c0}}", new Object[]{generatorClassName});
            return null;
        }
        return generator;
    }
}

