/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import java.util.Map;
import org.teavm.backend.javascript.codegen.SourceWriter;
import org.teavm.backend.javascript.rendering.RenderingUtil;
import org.teavm.platform.metadata.builders.ObjectResourceBuilder;
import org.teavm.platform.metadata.builders.ResourceArrayBuilder;
import org.teavm.platform.metadata.builders.ResourceBuilder;
import org.teavm.platform.metadata.builders.ResourceMapBuilder;

final class ResourceWriterHelper {
    private ResourceWriterHelper() {
    }

    public static void write(SourceWriter writer, ResourceBuilder resource) {
        if (resource instanceof ResourceArrayBuilder) {
            ResourceArrayBuilder data = (ResourceArrayBuilder)resource;
            writer.append('[').tokenBoundary();
            for (int i = 0; i < data.values.size(); ++i) {
                if (i > 0) {
                    writer.append(',').ws();
                }
                ResourceWriterHelper.write(writer, (ResourceBuilder)data.values.get(i));
            }
            writer.append(']').tokenBoundary();
        } else if (resource instanceof ResourceMapBuilder) {
            ResourceMapBuilder data = (ResourceMapBuilder)resource;
            writer.append('{');
            boolean first = true;
            for (Map.Entry entry : data.values.entrySet()) {
                if (!first) {
                    writer.append(",").ws();
                }
                first = false;
                RenderingUtil.writeString((SourceWriter)writer, (String)entry.getKey());
                writer.append(':').ws();
                ResourceWriterHelper.write(writer, (ResourceBuilder)entry.getValue());
            }
            writer.append('}').tokenBoundary();
        } else if (resource instanceof ObjectResourceBuilder) {
            ObjectResourceBuilder data = (ObjectResourceBuilder)resource;
            writer.append('{');
            String[] fieldNames = data.fieldNames();
            for (int i = 0; i < fieldNames.length; ++i) {
                if (i > 0) {
                    writer.append(',').ws();
                }
                ResourceWriterHelper.writeIdentifier(writer, fieldNames[i]);
                writer.ws().append(':').ws();
                ResourceWriterHelper.writeValue(writer, data.getValue(i));
            }
            writer.append('}').tokenBoundary();
        } else {
            throw new RuntimeException("Error compiling resources. Value of illegal type found: " + String.valueOf(resource.getClass()));
        }
    }

    public static void writeValue(SourceWriter writer, Object value) {
        if (value instanceof ResourceBuilder) {
            ResourceWriterHelper.write(writer, (ResourceBuilder)value);
        } else if (value instanceof Number) {
            writer.append(value.toString());
        } else if (value instanceof Boolean) {
            writer.append(value == Boolean.TRUE ? "true" : "false");
        } else if (value instanceof String) {
            RenderingUtil.writeString((SourceWriter)writer, (String)((String)value));
        } else if (value == null) {
            writer.append("null");
        }
    }

    public static void writeIdentifier(SourceWriter writer, String id) {
        if (id.isEmpty() || !ResourceWriterHelper.isIdentifierStart(id.charAt(0))) {
            RenderingUtil.writeString((SourceWriter)writer, (String)id);
            return;
        }
        for (int i = 1; i < id.length(); ++i) {
            if (!ResourceWriterHelper.isIdentifierPart(id.charAt(i))) continue;
            RenderingUtil.writeString((SourceWriter)writer, (String)id);
            return;
        }
        writer.append(id);
    }

    private static boolean isIdentifierStart(char c) {
        if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
            return true;
        }
        return c == '$' || c == '_';
    }

    private static boolean isIdentifierPart(char c) {
        if (ResourceWriterHelper.isIdentifierStart(c)) {
            return true;
        }
        return c >= '0' && c <= '9';
    }
}

