/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin.wasmgc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.generate.gc.strings.WasmGCStringConstant;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsic;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsicContext;
import org.teavm.backend.wasm.model.WasmArray;
import org.teavm.backend.wasm.model.WasmEntity;
import org.teavm.backend.wasm.model.WasmGlobal;
import org.teavm.backend.wasm.model.WasmStructure;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmArrayNewFixed;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmFloat32Constant;
import org.teavm.backend.wasm.model.expression.WasmFloat64Constant;
import org.teavm.backend.wasm.model.expression.WasmGetGlobal;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmInt64Constant;
import org.teavm.backend.wasm.model.expression.WasmNullConstant;
import org.teavm.backend.wasm.model.expression.WasmStructNew;
import org.teavm.common.HashUtils;
import org.teavm.common.ServiceRepository;
import org.teavm.model.AnnotationReader;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.platform.metadata.MetadataGenerator;
import org.teavm.platform.metadata.Resource;
import org.teavm.platform.metadata.ResourceArray;
import org.teavm.platform.metadata.ResourceMap;
import org.teavm.platform.plugin.DefaultMetadataGeneratorContext;
import org.teavm.platform.plugin.ResourceAccessorType;
import org.teavm.platform.plugin.ResourceMethodDescriptor;
import org.teavm.platform.plugin.ResourceTypeDescriptor;
import org.teavm.platform.plugin.ResourceTypeDescriptorProvider;
import org.teavm.platform.plugin.wasmgc.FieldMarker;
import org.teavm.platform.plugin.wasmgc.ResourceMapEntry;

class MetadataIntrinsic
implements WasmGCIntrinsic {
    private Properties properties;
    private ServiceRepository services;
    private MetadataGenerator generator;
    private WasmGlobal global;

    MetadataIntrinsic(Properties properties, ServiceRepository services, MetadataGenerator generator) {
        this.properties = properties;
        this.services = services;
        this.generator = generator;
    }

    public WasmExpression apply(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        WasmGlobal global = this.getGlobal(invocation.getMethod(), context);
        return new WasmGetGlobal(global);
    }

    private WasmGlobal getGlobal(MethodReference method, WasmGCIntrinsicContext context) {
        if (this.global == null) {
            DefaultMetadataGeneratorContext genContext = new DefaultMetadataGeneratorContext(context.hierarchy().getClassSource(), context.classLoader(), this.properties, this.services);
            Resource metadata = this.generator.generateMetadata(genContext, method);
            WasmType type = context.typeMapper().mapType(method.getReturnType());
            String name = context.names().topLevel(context.names().suggestForMethod(method));
            WasmExpression initialValue = this.generateMetadata(context, metadata, type);
            this.global = new WasmGlobal(name, type, initialValue);
            context.module().globals.add((WasmEntity)this.global);
        }
        return this.global;
    }

    private WasmExpression generateMetadata(WasmGCIntrinsicContext context, Object value, WasmType expectedType) {
        if (value == null) {
            return new WasmNullConstant((WasmType.Reference)expectedType);
        }
        if (value instanceof String) {
            return new WasmGetGlobal(context.strings().getStringConstant((String)((String)value)).global);
        }
        if (value instanceof Boolean) {
            return new WasmInt32Constant((Boolean)value != false ? 1 : 0);
        }
        if (value instanceof Integer) {
            return new WasmInt32Constant(((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return new WasmInt64Constant(((Long)value).longValue());
        }
        if (value instanceof Byte) {
            return new WasmInt32Constant((int)((Byte)value).byteValue());
        }
        if (value instanceof Short) {
            return new WasmInt32Constant((int)((Short)value).shortValue());
        }
        if (value instanceof Character) {
            return new WasmInt32Constant((int)((Character)value).charValue());
        }
        if (value instanceof Float) {
            return new WasmFloat32Constant(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return new WasmFloat64Constant(((Double)value).doubleValue());
        }
        if (value instanceof ResourceArray) {
            ResourceArray array = (ResourceArray)value;
            WasmType.CompositeReference type = (WasmType.CompositeReference)context.typeMapper().mapType((ValueType)ValueType.object((String)ResourceArray.class.getName()));
            WasmArray arrayType = (WasmArray)type.composite;
            WasmArrayNewFixed result = new WasmArrayNewFixed(arrayType);
            for (int i = 0; i < array.size(); ++i) {
                result.getElements().add(this.generateMetadata(context, array.get(i), arrayType.getElementType().asUnpackedType()));
            }
            return result;
        }
        if (value instanceof ResourceMap) {
            return this.generateMapResource(context, (ResourceMap)value);
        }
        if (value instanceof ResourceTypeDescriptorProvider) {
            ResourceTypeDescriptor descriptor = ((ResourceTypeDescriptorProvider)value).getDescriptor();
            return this.generateObjectResource(context, value, descriptor);
        }
        throw new IllegalArgumentException("Don't know how to write resource: " + String.valueOf(value));
    }

    private WasmExpression generateMapResource(WasmGCIntrinsicContext context, ResourceMap<?> map) {
        String[] hashTable = HashUtils.createHashTable((String[])map.keys());
        WasmType.CompositeReference type = (WasmType.CompositeReference)context.typeMapper().mapType((ValueType)ValueType.object((String)ResourceMap.class.getName()));
        WasmArray arrayType = (WasmArray)type.composite;
        WasmType.CompositeReference entryType = (WasmType.CompositeReference)context.typeMapper().mapType((ValueType)ValueType.object((String)ResourceMapEntry.class.getName()));
        WasmStructure entryStruct = (WasmStructure)entryType.composite;
        WasmArrayNewFixed expr = new WasmArrayNewFixed(arrayType);
        for (String key : hashTable) {
            if (key == null) {
                expr.getElements().add(new WasmNullConstant((WasmType.Reference)entryType));
                continue;
            }
            Object value = map.get(key);
            WasmExpression wasmValue = this.generateMetadata(context, value, (WasmType)WasmType.Reference.EQ);
            WasmStructNew entryExpr = new WasmStructNew(entryStruct);
            WasmGCStringConstant keyConstant = context.strings().getStringConstant(key);
            entryExpr.getInitializers().add(new WasmGetGlobal(keyConstant.global));
            entryExpr.getInitializers().add(wasmValue);
            expr.getElements().add(entryExpr);
        }
        return expr;
    }

    private WasmExpression generateObjectResource(WasmGCIntrinsicContext context, Object value, ResourceTypeDescriptor descriptor) {
        Class<?> javaItf = descriptor.getRootInterface();
        ClassReader cls = context.hierarchy().getClassSource().get(javaItf.getName());
        HashMap<String, Method> getterMap = new HashMap<String, Method>();
        for (Map.Entry<Method, ResourceMethodDescriptor> entry : descriptor.getMethods().entrySet()) {
            if (entry.getValue().getType() != ResourceAccessorType.GETTER) continue;
            getterMap.put(entry.getValue().getPropertyName(), entry.getKey());
        }
        WasmType.CompositeReference wasmType = (WasmType.CompositeReference)context.typeMapper().mapType((ValueType)ValueType.object((String)cls.getName()));
        WasmStructure wasmStruct = (WasmStructure)wasmType.composite;
        WasmStructNew expr = new WasmStructNew(wasmStruct);
        for (FieldDescriptor field : this.collectFields(context.hierarchy().getClassSource(), cls)) {
            Object fieldValue;
            Method getter = (Method)getterMap.get(field.name);
            try {
                fieldValue = getter.invoke(value, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            expr.getInitializers().add(this.generateMetadata(context, fieldValue, context.typeMapper().mapType(field.type)));
        }
        return expr;
    }

    private List<FieldDescriptor> collectFields(ClassReaderSource classes, ClassReader cls) {
        ArrayList<FieldDescriptor> fields = new ArrayList<FieldDescriptor>();
        while (cls != null) {
            for (MethodReader method : cls.getMethods()) {
                AnnotationReader annot = method.getAnnotations().get(FieldMarker.class.getName());
                if (annot == null) continue;
                fields.add(new FieldDescriptor(annot.getValue("index").getInt(), annot.getValue("value").getString(), method.getResultType()));
            }
            if (!(cls = classes.get(cls.getParent())).getName().equals(Resource.class.getName())) continue;
        }
        fields.sort(Comparator.comparingInt(f -> f.index));
        return fields;
    }

    private static class FieldDescriptor {
        final int index;
        final String name;
        final ValueType type;

        FieldDescriptor(int index, String name, ValueType type) {
            this.index = index;
            this.name = name;
            this.type = type;
        }
    }
}

