/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.metaprogramming.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.teavm.metaprogramming.CompileTime;
import org.teavm.metaprogramming.impl.MetaprogrammingInstrumentation;

public class MetaprogrammingClassLoader
extends ClassLoader {
    private MetaprogrammingInstrumentation instrumentation = new MetaprogrammingInstrumentation();
    private Map<String, Boolean> compileTimeClasses = new HashMap<String, Boolean>();
    private Map<String, Boolean> compileTimePackages = new HashMap<String, Boolean>();

    public MetaprogrammingClassLoader(ClassLoader parent) {
        super(parent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (!this.isCompileTimeClass(name)) {
            return super.loadClass(name, resolve);
        }
        try (InputStream input = this.getResourceAsStream(name.replace('.', '/') + ".class");){
            byte[] array = this.instrumentation.instrument(IOUtils.toByteArray((InputStream)new BufferedInputStream(input)));
            Class<?> clazz = this.defineClass(name, array, 0, array.length);
            return clazz;
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Error reading bytecode of class " + name, e);
        }
    }

    public boolean isCompileTimeClass(String name) {
        return this.compileTimeClasses.computeIfAbsent(name, n -> this.checkIfCompileTime((String)n));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkIfCompileTime(String name) {
        CompileTimeClassVisitor visitor;
        block22: {
            int index;
            block21: {
                int index2;
                String packageName = name;
                do {
                    if ((index2 = packageName.lastIndexOf(46)) < 0) break block21;
                } while (!this.isCompileTimePackage(packageName = packageName.substring(0, index2)));
                return true;
            }
            String outerName = name;
            do {
                if ((index = outerName.lastIndexOf(36)) >= 0) continue;
                visitor = new CompileTimeClassVisitor();
                try (InputStream input = this.getResourceAsStream(name.replace('.', '/') + ".class");){
                    if (input == null) {
                        boolean bl = false;
                        return bl;
                    }
                    new ClassReader((InputStream)new BufferedInputStream(input)).accept((ClassVisitor)visitor, 3);
                    break block22;
                }
                catch (IOException e) {
                    return false;
                }
            } while (!this.isCompileTimeClass(outerName = outerName.substring(0, index)));
            return true;
        }
        if (visitor.compileTime) {
            return true;
        }
        if (visitor.parent == null) return false;
        if (visitor.parent.equals(name)) return false;
        return this.isCompileTimeClass(visitor.parent);
    }

    private boolean isCompileTimePackage(String name) {
        return this.compileTimePackages.computeIfAbsent(name, n -> this.checkIfCompileTimePackage((String)n));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkIfCompileTimePackage(String name) {
        CompileTimeClassVisitor visitor = new CompileTimeClassVisitor();
        try (InputStream input = this.getResourceAsStream(name.replace('.', '/') + "/package-info.class");){
            if (input == null) {
                boolean bl = false;
                return bl;
            }
            new ClassReader((InputStream)new BufferedInputStream(input)).accept((ClassVisitor)visitor, 3);
            return visitor.compileTime;
        }
        catch (IOException e) {
            return false;
        }
    }

    static class CompileTimeClassVisitor
    extends ClassVisitor {
        String parent;
        boolean compileTime;

        CompileTimeClassVisitor() {
            super(327680, null);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.parent = superName != null ? superName.replace('/', '.') : null;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (desc.equals(Type.getDescriptor(CompileTime.class))) {
                this.compileTime = true;
            }
            return null;
        }
    }
}

