/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.maven;

import java.io.File;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.teavm.backend.wasm.render.WasmBinaryVersion;
import org.teavm.callgraph.CallGraph;
import org.teavm.diagnostics.ProblemProvider;
import org.teavm.maven.MavenSourceFileProviderLookup;
import org.teavm.maven.MavenTeaVMToolLog;
import org.teavm.tooling.TeaVMProblemRenderer;
import org.teavm.tooling.TeaVMTargetType;
import org.teavm.tooling.TeaVMToolLog;
import org.teavm.tooling.builder.BuildException;
import org.teavm.tooling.builder.BuildResult;
import org.teavm.tooling.builder.BuildStrategy;
import org.teavm.tooling.builder.InProcessBuildStrategy;
import org.teavm.tooling.builder.RemoteBuildStrategy;
import org.teavm.tooling.daemon.BuildDaemon;
import org.teavm.tooling.daemon.DaemonInfo;
import org.teavm.tooling.daemon.DaemonLog;
import org.teavm.tooling.daemon.RemoteBuildService;
import org.teavm.vm.TeaVMOptimizationLevel;

@Mojo(name="compile", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class TeaVMCompileMojo
extends AbstractMojo {
    @Component
    private MavenProject project;
    @Component
    private RepositorySystem repositorySystem;
    @Parameter(required=true, readonly=true, defaultValue="${localRepository}")
    private MavenArtifactRepository localRepository;
    @Parameter(required=true, readonly=true, defaultValue="${project.remoteArtifactRepositories}")
    private List<MavenArtifactRepository> remoteRepositories;
    @Parameter(readonly=true, defaultValue="${plugin.artifacts}")
    private List<Artifact> pluginArtifacts;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File classFiles;
    @Parameter
    private List<String> compileScopes;
    @Parameter(property="teavm.minifying", defaultValue="true")
    private boolean minifying = true;
    @Parameter(property="teavm.strict", defaultValue="false")
    private boolean strict;
    @Parameter(property="teavm.maxTopLevelNames", defaultValue="10000")
    private int maxTopLevelNames = 10000;
    @Parameter
    private Properties properties;
    @Parameter(property="teavm.debugInformationGenerated", defaultValue="false")
    private boolean debugInformationGenerated;
    @Parameter(property="teavm.sourceMapsGenerated", defaultValue="false")
    private boolean sourceMapsGenerated;
    @Parameter(property="teavm.sourceFilesCopied", defaultValue="false")
    private boolean sourceFilesCopied;
    @Parameter(property="teavm.incremental", defaultValue="false")
    private boolean incremental;
    @Parameter
    private String[] transformers;
    @Parameter(defaultValue="${project.build.directory}/javascript")
    private File targetDirectory;
    @Parameter(defaultValue="${project.build.sourceDirectory}")
    private File sourceDirectory;
    @Parameter(property="teavm.targetFileName", defaultValue="")
    private String targetFileName = "";
    @Parameter(property="teavm.mainClass")
    private String mainClass;
    @Parameter(property="teavm.entryPointName", defaultValue="main")
    private String entryPointName;
    @Parameter
    private String[] classesToPreserve;
    @Parameter(property="teavm.stopOnErrors", defaultValue="true")
    private boolean stopOnErrors = true;
    @Parameter(property="teavm.optimizationLevel", defaultValue="SIMPLE")
    private TeaVMOptimizationLevel optimizationLevel = TeaVMOptimizationLevel.SIMPLE;
    @Parameter(property="teavm.fastGlobalAnalysis", defaultValue="false")
    private boolean fastGlobalAnalysis;
    @Parameter(property="teavm.targetType", defaultValue="JAVASCRIPT")
    private TeaVMTargetType targetType = TeaVMTargetType.JAVASCRIPT;
    @Parameter(defaultValue="${project.build.directory}/teavm-cache")
    private File cacheDirectory;
    @Parameter(property="teavm.wasmVersion", defaultValue="V_0x1")
    private WasmBinaryVersion wasmVersion = WasmBinaryVersion.V_0x1;
    @Parameter(property="teavm.minHeapSize", defaultValue="4")
    private int minHeapSize;
    @Parameter(property="teavm.maxHeapSize", defaultValue="128")
    private int maxHeapSize;
    @Parameter(property="teavm.outOfProcess", defaultValue="false")
    private boolean outOfProcess;
    @Parameter(property="teavm.processMemory", defaultValue="512")
    private int processMemory;
    @Parameter(property="teavm.heapDump", defaultValue="false")
    private boolean heapDump;
    @Parameter(property="teavm.shortFileNames", defaultValue="false")
    private boolean shortFileNames;
    @Parameter(property="teavm.assertionsRemoved", defaultValue="false")
    private boolean assertionsRemoved;

    private void setupBuilder(BuildStrategy builder) throws MojoExecutionException {
        builder.setLog((TeaVMToolLog)new MavenTeaVMToolLog(this.getLog()));
        try {
            builder.setClassPathEntries(this.prepareClassPath());
            builder.setObfuscated(this.minifying);
            builder.setStrict(this.strict);
            builder.setMaxTopLevelNames(this.maxTopLevelNames);
            builder.setTargetDirectory(this.targetDirectory.getAbsolutePath());
            if (this.transformers != null) {
                builder.setTransformers(this.transformers);
            }
            if (this.sourceFilesCopied) {
                this.getSourceFileProviders(builder);
                builder.addSourcesDirectory(this.sourceDirectory.getAbsolutePath());
            }
            if (this.properties != null) {
                builder.setProperties(this.properties);
            }
            builder.setIncremental(this.incremental);
            builder.setDebugInformationGenerated(this.debugInformationGenerated);
            builder.setSourceMapsFileGenerated(this.sourceMapsGenerated);
            builder.setSourceFilesCopied(this.sourceFilesCopied);
            builder.setMinHeapSize(this.minHeapSize * 1024 * 1024);
            builder.setMaxHeapSize(this.maxHeapSize * 1024 * 1024);
            builder.setShortFileNames(this.shortFileNames);
            builder.setAssertionsRemoved(this.assertionsRemoved);
        }
        catch (RuntimeException e) {
            throw new MojoExecutionException("Unexpected error occurred", (Exception)e);
        }
    }

    private List<String> prepareClassPath() {
        Log log = this.getLog();
        log.info((CharSequence)"Preparing classpath for TeaVM");
        ArrayList<String> paths = new ArrayList<String>();
        StringBuilder classpath = new StringBuilder();
        for (Artifact artifact : this.project.getArtifacts()) {
            if (!this.filterByScope(artifact)) continue;
            File file = artifact.getFile();
            if (classpath.length() > 0) {
                classpath.append(':');
            }
            classpath.append(file.getPath());
            paths.add(file.getAbsolutePath());
        }
        if (classpath.length() > 0) {
            classpath.append(':');
        }
        classpath.append(this.classFiles.getPath());
        paths.add(this.classFiles.getAbsolutePath());
        log.info((CharSequence)("Using the following classpath for TeaVM: " + String.valueOf(classpath)));
        return paths;
    }

    private boolean filterByScope(Artifact artifact) {
        return this.compileScopes == null ? this.isSupportedScope(artifact.getScope()) : this.compileScopes.contains(artifact.getScope());
    }

    protected boolean isSupportedScope(String scope) {
        switch (scope) {
            case "compile": 
            case "provided": 
            case "system": {
                return true;
            }
        }
        return false;
    }

    private void getSourceFileProviders(BuildStrategy builder) {
        MavenSourceFileProviderLookup lookup = new MavenSourceFileProviderLookup();
        lookup.setMavenProject(this.project);
        lookup.setRepositorySystem(this.repositorySystem);
        lookup.setLocalRepository((ArtifactRepository)this.localRepository);
        lookup.setRemoteRepositories(this.remoteRepositories);
        lookup.setPluginDependencies(this.pluginArtifacts);
        lookup.resolve(builder);
    }

    public void execute() throws MojoExecutionException {
        if (this.outOfProcess) {
            this.executeInSeparateProcess();
        } else {
            this.executeWithBuilder((BuildStrategy)new InProcessBuildStrategy());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInSeparateProcess() throws MojoExecutionException {
        DaemonInfo daemon;
        try {
            daemon = BuildDaemon.start((boolean)false, (int)this.processMemory, (DaemonLog)new DaemonLogImpl(), (String[])this.createDaemonClassPath());
        }
        catch (Throwable e) {
            throw new MojoExecutionException("Error starting TeaVM process", e);
        }
        try {
            RemoteBuildService buildService;
            try {
                Registry registry = LocateRegistry.getRegistry("localhost", daemon.getPort());
                buildService = (RemoteBuildService)registry.lookup("TeaVM-Daemon");
            }
            catch (NotBoundException | RemoteException e) {
                throw new MojoExecutionException("Error connecting TeaVM process", e);
            }
            RemoteBuildStrategy builder = new RemoteBuildStrategy(buildService);
            this.executeWithBuilder((BuildStrategy)builder);
        }
        finally {
            daemon.getProcess().destroy();
        }
    }

    private void executeWithBuilder(BuildStrategy builder) throws MojoExecutionException {
        builder.init();
        Log log = this.getLog();
        this.setupBuilder(builder);
        MavenTeaVMToolLog toolLog = new MavenTeaVMToolLog(log);
        builder.setLog((TeaVMToolLog)toolLog);
        try {
            builder.setMainClass(this.mainClass);
            builder.setEntryPointName(this.entryPointName);
            if (!this.targetFileName.isEmpty()) {
                builder.setTargetFileName(this.targetFileName);
            }
            builder.setOptimizationLevel(this.optimizationLevel);
            builder.setFastDependencyAnalysis(this.fastGlobalAnalysis);
            if (this.classesToPreserve != null) {
                builder.setClassesToPreserve(this.classesToPreserve);
            }
            builder.setCacheDirectory(this.cacheDirectory.getAbsolutePath());
            builder.setTargetType(this.targetType);
            builder.setWasmVersion(this.wasmVersion);
            builder.setHeapDump(this.heapDump);
            BuildResult result = builder.build();
            TeaVMProblemRenderer.describeProblems((CallGraph)result.getCallGraph(), (ProblemProvider)result.getProblems(), (TeaVMToolLog)toolLog);
            if (this.stopOnErrors && !result.getProblems().getSevereProblems().isEmpty()) {
                throw new MojoExecutionException("Build error");
            }
        }
        catch (BuildException e) {
            throw new MojoExecutionException("Unexpected error occurred", e.getCause());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unexpected error occurred", e);
        }
    }

    private String[] createDaemonClassPath() {
        Artifact toolArtifact = this.pluginArtifacts.stream().filter(artifact -> artifact.getGroupId().equals("org.teavm") && artifact.getArtifactId().equals("teavm-tooling")).findFirst().orElse(null);
        if (toolArtifact == null) {
            return new String[0];
        }
        ArtifactResolutionResult resolutionResult = this.repositorySystem.resolve(new ArtifactResolutionRequest().setLocalRepository((ArtifactRepository)this.localRepository).setRemoteRepositories(new ArrayList<MavenArtifactRepository>(this.remoteRepositories)).setResolveTransitively(true).setResolveRoot(true).setArtifact(toolArtifact));
        if (!resolutionResult.isSuccess()) {
            return new String[0];
        }
        return (String[])resolutionResult.getArtifacts().stream().map(artifact -> artifact.getFile().getAbsolutePath()).toArray(String[]::new);
    }

    class DaemonLogImpl
    implements DaemonLog {
        DaemonLogImpl() {
        }

        public void error(String message) {
            TeaVMCompileMojo.this.getLog().error((CharSequence)message);
        }

        public void error(String message, Throwable e) {
            TeaVMCompileMojo.this.getLog().error((CharSequence)message, e);
        }

        public void info(String message) {
            TeaVMCompileMojo.this.getLog().info((CharSequence)message);
        }
    }
}

