/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.maven;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.teavm.backend.wasm.render.WasmBinaryVersion;
import org.teavm.maven.AbstractTeaVMMojo;
import org.teavm.maven.MavenTeaVMToolLog;
import org.teavm.tooling.BaseTeaVMTool;
import org.teavm.tooling.ClassAlias;
import org.teavm.tooling.MethodAlias;
import org.teavm.tooling.RuntimeCopyOperation;
import org.teavm.tooling.TeaVMTargetType;
import org.teavm.tooling.TeaVMTool;
import org.teavm.tooling.TeaVMToolException;
import org.teavm.tooling.TeaVMToolLog;
import org.teavm.tooling.sources.DirectorySourceFileProvider;
import org.teavm.tooling.sources.SourceFileProvider;
import org.teavm.vm.TeaVMOptimizationLevel;

@Mojo(name="compile", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class TeaVMCompileMojo
extends AbstractTeaVMMojo {
    @Parameter(defaultValue="${project.build.directory}/javascript")
    private File targetDirectory;
    @Parameter(defaultValue="${project.build.sourceDirectory}")
    private File sourceDirectory;
    @Parameter
    private String targetFileName = "";
    @Parameter
    private String mainClass;
    @Parameter
    private ClassAlias[] classAliases;
    @Parameter
    private MethodAlias[] methodAliases;
    @Parameter
    private boolean stopOnErrors = true;
    @Parameter
    protected RuntimeCopyOperation runtime = RuntimeCopyOperation.SEPARATE;
    @Parameter
    private TeaVMOptimizationLevel optimizationLevel = TeaVMOptimizationLevel.SIMPLE;
    @Parameter
    private TeaVMTargetType targetType = TeaVMTargetType.JAVASCRIPT;
    @Parameter(defaultValue="${project.build.directory}/teavm-cache")
    protected File cacheDirectory;
    private TeaVMTool tool = new TeaVMTool();
    @Parameter
    private WasmBinaryVersion wasmVersion = WasmBinaryVersion.V_0x1;

    @Override
    protected File getTargetDirectory() {
        return this.targetDirectory;
    }

    public void execute() throws MojoExecutionException {
        Log log = this.getLog();
        this.setupTool((BaseTeaVMTool)this.tool);
        this.tool.setLog((TeaVMToolLog)new MavenTeaVMToolLog(log));
        try {
            this.tool.setMainClass(this.mainClass);
            this.tool.setRuntime(this.runtime);
            if (!this.targetFileName.isEmpty()) {
                this.tool.setTargetFileName(this.targetFileName);
            }
            this.tool.setOptimizationLevel(this.optimizationLevel);
            if (this.classAliases != null) {
                this.tool.getClassAliases().addAll(Arrays.asList(this.classAliases));
            }
            if (this.methodAliases != null) {
                this.tool.getMethodAliases().addAll(Arrays.asList(this.methodAliases));
            }
            this.tool.setCacheDirectory(this.cacheDirectory);
            this.tool.setTargetType(this.targetType);
            this.tool.setWasmVersion(this.wasmVersion);
            this.tool.generate();
            if (this.stopOnErrors && !this.tool.getProblemProvider().getSevereProblems().isEmpty()) {
                throw new MojoExecutionException("Build error");
            }
        }
        catch (RuntimeException e) {
            throw new MojoExecutionException("Unexpected error occured", (Exception)e);
        }
        catch (TeaVMToolException e) {
            throw new MojoExecutionException("IO error occured", (Exception)((Object)e));
        }
    }

    @Override
    protected void addSourceProviders(List<SourceFileProvider> providers) {
        providers.add((SourceFileProvider)new DirectorySourceFileProvider(this.sourceDirectory));
    }
}

