/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.maven;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.teavm.maven.MavenSourceFileProviderLookup;
import org.teavm.maven.MavenTeaVMToolLog;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.tooling.BaseTeaVMTool;
import org.teavm.tooling.TeaVMToolLog;
import org.teavm.tooling.sources.SourceFileProvider;

public abstract class AbstractTeaVMMojo
extends AbstractMojo {
    @Component
    protected MavenProject project;
    @Component
    protected RepositorySystem repositorySystem;
    @Parameter(required=true, readonly=true, defaultValue="${localRepository}")
    protected MavenArtifactRepository localRepository;
    @Parameter(required=true, readonly=true, defaultValue="${project.remoteArtifactRepositories}")
    protected List<MavenArtifactRepository> remoteRepositories;
    @Parameter(readonly=true, defaultValue="${plugin.artifacts}")
    protected List<Artifact> pluginArtifacts;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    protected File classFiles;
    @Parameter
    protected List<String> compileScopes;
    @Parameter
    protected boolean minifying = true;
    @Parameter
    protected Properties properties;
    @Parameter
    protected boolean debugInformationGenerated;
    @Parameter
    protected boolean sourceMapsGenerated;
    @Parameter
    protected boolean sourceFilesCopied;
    @Parameter
    protected boolean incremental;
    @Parameter
    protected String[] transformers;
    protected ClassLoader classLoader;

    protected abstract File getTargetDirectory();

    protected final List<ClassHolderTransformer> instantiateTransformers(ClassLoader classLoader) throws MojoExecutionException {
        ArrayList<ClassHolderTransformer> transformerInstances = new ArrayList<ClassHolderTransformer>();
        if (this.transformers == null) {
            return transformerInstances;
        }
        for (String transformerName : this.transformers) {
            Constructor<ClassHolderTransformer> ctor;
            Class<?> transformerRawType;
            try {
                transformerRawType = Class.forName(transformerName, true, classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new MojoExecutionException("Transformer not found: " + transformerName, (Exception)e);
            }
            if (!ClassHolderTransformer.class.isAssignableFrom(transformerRawType)) {
                throw new MojoExecutionException("Transformer " + transformerName + " is not subtype of " + ClassHolderTransformer.class.getName());
            }
            Class<ClassHolderTransformer> transformerType = transformerRawType.asSubclass(ClassHolderTransformer.class);
            try {
                ctor = transformerType.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new MojoExecutionException("Transformer " + transformerName + " has no default constructor");
            }
            try {
                ClassHolderTransformer transformer = ctor.newInstance(new Object[0]);
                transformerInstances.add(transformer);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new MojoExecutionException("Error instantiating transformer " + transformerName, (Exception)e);
            }
        }
        return transformerInstances;
    }

    protected void setupTool(BaseTeaVMTool tool) throws MojoExecutionException {
        tool.setLog((TeaVMToolLog)new MavenTeaVMToolLog(this.getLog()));
        try {
            ClassLoader classLoader = this.prepareClassLoader();
            tool.setClassLoader(classLoader);
            tool.setMinifying(this.minifying);
            tool.setTargetDirectory(this.getTargetDirectory());
            tool.getTransformers().addAll(this.instantiateTransformers(classLoader));
            if (this.sourceFilesCopied) {
                for (SourceFileProvider provider : this.getSourceFileProviders()) {
                    tool.addSourceFileProvider(provider);
                }
            }
            if (this.properties != null) {
                tool.getProperties().putAll((Map<?, ?>)this.properties);
            }
            tool.setIncremental(this.incremental);
            tool.setDebugInformationGenerated(this.debugInformationGenerated);
            tool.setSourceMapsFileGenerated(this.sourceMapsGenerated);
            tool.setSourceFilesCopied(this.sourceFilesCopied);
        }
        catch (RuntimeException e) {
            throw new MojoExecutionException("Unexpected error occured", (Exception)e);
        }
    }

    protected final ClassLoader prepareClassLoader() throws MojoExecutionException {
        try {
            Log log = this.getLog();
            log.info((CharSequence)"Preparing classpath for JavaScript generation");
            ArrayList<URL> urls = new ArrayList<URL>();
            StringBuilder classpath = new StringBuilder();
            for (Artifact artifact : this.project.getArtifacts()) {
                if (!this.filterByScope(artifact)) continue;
                File file = artifact.getFile();
                if (classpath.length() > 0) {
                    classpath.append(':');
                }
                classpath.append(file.getPath());
                urls.add(file.toURI().toURL());
            }
            if (classpath.length() > 0) {
                classpath.append(':');
            }
            classpath.append(this.classFiles.getPath());
            urls.add(this.classFiles.toURI().toURL());
            for (File additionalEntry : this.getAdditionalClassPath()) {
                classpath.append(':').append(additionalEntry.getPath());
                urls.add(additionalEntry.toURI().toURL());
            }
            log.info((CharSequence)("Using the following classpath for JavaScript generation: " + classpath));
            this.classLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), AbstractTeaVMMojo.class.getClassLoader());
            return this.classLoader;
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Error gathering classpath information", (Exception)e);
        }
    }

    protected List<File> getAdditionalClassPath() {
        return Collections.emptyList();
    }

    protected boolean filterByScope(Artifact artifact) {
        return this.compileScopes == null ? this.isSupportedScope(artifact.getScope()) : this.compileScopes.contains(artifact.getScope());
    }

    protected boolean isSupportedScope(String scope) {
        switch (scope) {
            case "compile": 
            case "provided": 
            case "system": {
                return true;
            }
        }
        return false;
    }

    protected final List<SourceFileProvider> getSourceFileProviders() {
        MavenSourceFileProviderLookup lookup = new MavenSourceFileProviderLookup();
        lookup.setMavenProject(this.project);
        lookup.setRepositorySystem(this.repositorySystem);
        lookup.setLocalRepository((ArtifactRepository)this.localRepository);
        lookup.setRemoteRepositories(this.remoteRepositories);
        lookup.setPluginDependencies(this.pluginArtifacts);
        List<SourceFileProvider> providers = lookup.resolve();
        this.addSourceProviders(providers);
        return providers;
    }

    protected void addSourceProviders(List<SourceFileProvider> providers) {
    }
}

