/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.teavm.maven.BuildJavascriptTestMojo;
import org.teavm.maven.TestRunStrategy;
import org.teavm.tooling.testing.TestCase;

public class SeleniumRunStrategy
implements TestRunStrategy {
    private URL url;
    private File directory;
    private ThreadLocal<WebDriver> webDriver = new ThreadLocal();
    private ThreadLocal<Integer> commandsSent = new ThreadLocal();

    public SeleniumRunStrategy(URL url, File directory) {
        this.url = url;
        this.directory = directory;
    }

    @Override
    public void beforeThread() {
        RemoteWebDriver driver = new RemoteWebDriver(this.url, (Capabilities)DesiredCapabilities.firefox());
        this.webDriver.set((WebDriver)driver);
        this.commandsSent.set(0);
    }

    @Override
    public void afterThread() {
        this.webDriver.get().close();
        this.webDriver.get().quit();
        this.webDriver.remove();
    }

    @Override
    public String runTest(Log log, String runtimeScript, TestCase testCase) throws IOException {
        this.commandsSent.set(this.commandsSent.get() + 1);
        if (this.commandsSent.get().equals(20)) {
            this.commandsSent.set(0);
            this.webDriver.get().close();
            this.webDriver.get().quit();
            this.webDriver.set((WebDriver)new RemoteWebDriver(this.url, (Capabilities)DesiredCapabilities.firefox()));
        }
        this.webDriver.get().manage().timeouts().setScriptTimeout(2L, TimeUnit.SECONDS);
        JavascriptExecutor js = (JavascriptExecutor)this.webDriver.get();
        try {
            return (String)js.executeAsyncScript(this.readResource("teavm-selenium.js"), new Object[]{this.readFile(new File(this.directory, runtimeScript)), this.readFile(new File(this.directory, testCase.getTestScript())), this.readResource("teavm-selenium-adapter.js")});
        }
        catch (WebDriverException e) {
            log.error((CharSequence)("Error occured running test " + testCase.getTestMethod()), (Throwable)e);
            List errors = (List)js.executeScript("return window.jsErrors;", new Object[0]);
            if (errors != null) {
                for (Object error : errors) {
                    log.error((CharSequence)("  -- additional error: " + error));
                }
            }
            return null;
        }
    }

    private String readFile(File file) throws IOException {
        try (FileInputStream input = new FileInputStream(file);){
            String string = IOUtils.toString((InputStream)input, (String)"UTF-8");
            return string;
        }
    }

    private String readResource(String resourceName) throws IOException {
        try (InputStream input = BuildJavascriptTestMojo.class.getClassLoader().getResourceAsStream(resourceName);){
            if (input == null) {
                String string = "";
                return string;
            }
            String string = IOUtils.toString((InputStream)input, (String)"UTF-8");
            return string;
        }
    }
}

