/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.teavm.tooling.sources.DirectorySourceFileProvider;
import org.teavm.tooling.sources.JarSourceFileProvider;
import org.teavm.tooling.sources.SourceFileProvider;

public class MavenSourceFileProviderLookup {
    private MavenProject mavenProject;
    private RepositorySystem repositorySystem;
    private ArtifactRepository localRepository;
    private List<? extends ArtifactRepository> remoteRepositories;
    private List<Artifact> pluginDependencies;

    public void setMavenProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
    }

    public void setRepositorySystem(RepositorySystem repositorySystem) {
        this.repositorySystem = repositorySystem;
    }

    public void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    public void setRemoteRepositories(List<? extends ArtifactRepository> remoteRepositories) {
        this.remoteRepositories = remoteRepositories;
    }

    public void setPluginDependencies(List<Artifact> pluginDependencies) {
        this.pluginDependencies = pluginDependencies;
    }

    public List<SourceFileProvider> resolve() {
        ArrayList<Artifact> initialArtifacts = new ArrayList<Artifact>();
        initialArtifacts.addAll(this.mavenProject.getArtifacts());
        if (this.pluginDependencies != null) {
            initialArtifacts.addAll(this.pluginDependencies);
        }
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        for (Artifact artifact : initialArtifacts) {
            if (artifact.getClassifier() != null && artifact.getClassifier().equals("sources")) {
                artifacts.add(artifact);
                continue;
            }
            artifacts.add(this.repositorySystem.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), "sources"));
        }
        ArrayList<SourceFileProvider> providers = new ArrayList<SourceFileProvider>();
        for (Artifact artifact : artifacts) {
            ArtifactResolutionRequest request = new ArtifactResolutionRequest().setLocalRepository(this.localRepository).setRemoteRepositories(new ArrayList<ArtifactRepository>(this.remoteRepositories)).setArtifact(artifact);
            ArtifactResolutionResult result = this.repositorySystem.resolve(request);
            for (Artifact resolvedArtifact : result.getArtifacts()) {
                if (resolvedArtifact.getFile() == null) continue;
                File file = resolvedArtifact.getFile();
                if (!file.isDirectory()) {
                    providers.add((SourceFileProvider)new JarSourceFileProvider(file));
                    continue;
                }
                providers.add((SourceFileProvider)new DirectorySourceFileProvider(file));
            }
        }
        for (String sourceRoot : this.mavenProject.getCompileSourceRoots()) {
            providers.add((SourceFileProvider)new DirectorySourceFileProvider(new File(sourceRoot)));
        }
        return providers;
    }
}

