/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.maven;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.NativeJavaObject;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;
import org.teavm.maven.BuildJavascriptTestMojo;
import org.teavm.maven.TestRunStrategy;
import org.teavm.tooling.testing.TestCase;

public class HtmlUnitRunStrategy
implements TestRunStrategy {
    private File directory;

    public HtmlUnitRunStrategy(File directory) {
        this.directory = directory;
    }

    @Override
    public void beforeThread() {
    }

    @Override
    public void afterThread() {
    }

    @Override
    public String runTest(Log log, String runtimeScript, TestCase testCase) throws IOException {
        try (WebClient webClient = new WebClient(BrowserVersion.CHROME);){
            HtmlPage page = (HtmlPage)webClient.getPage("about:blank");
            page.executeJavaScript(this.readFile(new File(this.directory, runtimeScript)));
            AsyncResult asyncResult = new AsyncResult();
            Function function = (Function)page.executeJavaScript(this.readResource("teavm-htmlunit-adapter.js")).getJavaScriptResult();
            Object[] args = new Object[]{new NativeJavaObject((Scriptable)function, (Object)asyncResult, AsyncResult.class)};
            page.executeJavaScriptFunctionIfPossible(function, (Scriptable)function, args, (DomNode)page);
            page.executeJavaScript(this.readFile(new File(this.directory, testCase.getTestScript())));
            page.cleanUp();
            for (WebWindow window : webClient.getWebWindows()) {
                window.getJobManager().removeAllJobs();
            }
            String string = (String)asyncResult.getResult();
            return string;
        }
    }

    private String readFile(File file) throws IOException {
        try (FileInputStream input = new FileInputStream(file);){
            String string = IOUtils.toString((InputStream)input, (String)"UTF-8");
            return string;
        }
    }

    private String readResource(String resourceName) throws IOException {
        try (InputStream input = BuildJavascriptTestMojo.class.getClassLoader().getResourceAsStream(resourceName);){
            if (input == null) {
                String string = "";
                return string;
            }
            String string = IOUtils.toString((InputStream)input, (String)"UTF-8");
            return string;
        }
    }

    public class AsyncResult {
        private CountDownLatch latch = new CountDownLatch(1);
        private Object result;

        public void complete(Object result) {
            this.result = result;
            this.latch.countDown();
        }

        public Object getResult() {
            try {
                this.latch.await(5L, TimeUnit.SECONDS);
                return this.result;
            }
            catch (InterruptedException e) {
                return null;
            }
        }
    }
}

