/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.maven;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.teavm.common.FiniteExecutor;
import org.teavm.common.SimpleFiniteExecutor;
import org.teavm.common.ThreadPoolFiniteExecutor;
import org.teavm.maven.TestExceptionPlugin;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderSource;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.CopyClassHolderSource;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.parsing.ClasspathClassHolderSource;
import org.teavm.testing.JUnitTestAdapter;
import org.teavm.testing.TestAdapter;
import org.teavm.vm.BuildTarget;
import org.teavm.vm.DirectoryBuildTarget;
import org.teavm.vm.TeaVM;
import org.teavm.vm.TeaVMBuilder;
import org.teavm.vm.spi.TeaVMHost;

@Mojo(name="build-test-javascript", requiresDependencyResolution=ResolutionScope.TEST, requiresDependencyCollection=ResolutionScope.TEST)
public class BuildJavascriptTestMojo
extends AbstractMojo {
    private static Set<String> testScopes = new HashSet<String>(Arrays.asList("compile", "test", "system", "runtime", "provided"));
    private Map<String, List<MethodReference>> groupedMethods = new HashMap<String, List<MethodReference>>();
    private Map<MethodReference, String> fileNames = new HashMap<MethodReference, String>();
    private List<MethodReference> testMethods = new ArrayList<MethodReference>();
    private List<String> testClasses = new ArrayList<String>();
    private TestAdapter adapter;
    @Component
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/javascript-test")
    private File outputDir;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File classFiles;
    @Parameter(defaultValue="${project.build.testOutputDirectory}")
    private File testFiles;
    @Parameter
    private String[] wildcards = new String[]{"**.*Test", "**.*UnitTest"};
    @Parameter
    private boolean minifying = true;
    @Parameter
    private boolean scanDependencies;
    @Parameter
    private int numThreads = 1;
    @Parameter
    private String adapterClass = JUnitTestAdapter.class.getName();
    @Parameter
    private String[] transformers;
    private List<ClassHolderTransformer> transformerInstances;
    @Parameter
    private String[] additionalScripts;
    private List<String> additionalScriptLocalPaths = new ArrayList<String>();

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public void setClassFiles(File classFiles) {
        this.classFiles = classFiles;
    }

    public void setTestFiles(File testFiles) {
        this.testFiles = testFiles;
    }

    public void setMinifying(boolean minifying) {
        this.minifying = minifying;
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public void setAdapterClass(String adapterClass) {
        this.adapterClass = adapterClass;
    }

    public void setWildcards(String[] wildcards) {
        this.wildcards = wildcards;
    }

    public String[] getTransformers() {
        return this.transformers;
    }

    public void setTransformers(String[] transformers) {
        this.transformers = transformers;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (System.getProperty("maven.test.skip", "false").equals("true") || System.getProperty("skipTests") != null) {
            this.getLog().info((CharSequence)"Tests build skipped as specified by system property");
            return;
        }
        Runnable finalizer = null;
        try {
            Object classHolder;
            final ClassLoader classLoader = this.prepareClassLoader();
            this.createAdapter(classLoader);
            this.getLog().info((CharSequence)("Searching for tests in the directory `" + this.testFiles.getAbsolutePath() + "'"));
            this.findTestClasses(classLoader, this.testFiles, "");
            if (this.scanDependencies) {
                this.findTestsInDependencies(classLoader);
            }
            final Log log = this.getLog();
            new File(this.outputDir, "tests").mkdirs();
            new File(this.outputDir, "res").mkdirs();
            this.resourceToFile("org/teavm/javascript/runtime.js", "res/runtime.js");
            this.resourceToFile("org/teavm/maven/res/junit-support.js", "res/junit-support.js");
            this.resourceToFile("org/teavm/maven/res/junit.css", "res/junit.css");
            this.resourceToFile("org/teavm/maven/res/class_obj.png", "res/class_obj.png");
            this.resourceToFile("org/teavm/maven/res/control-000-small.png", "res/control-000-small.png");
            this.resourceToFile("org/teavm/maven/res/methpub_obj.png", "res/methpub_obj.png");
            this.resourceToFile("org/teavm/maven/res/package_obj.png", "res/package_obj.png");
            this.resourceToFile("org/teavm/maven/res/tick-small-red.png", "res/tick-small-red.png");
            this.resourceToFile("org/teavm/maven/res/tick-small.png", "res/tick-small.png");
            this.resourceToFile("org/teavm/maven/res/toggle-small-expand.png", "res/toggle-small-expand.png");
            this.resourceToFile("org/teavm/maven/res/toggle-small.png", "res/toggle-small.png");
            this.resourceToFile("org/teavm/maven/junit.html", "junit.html");
            ClasspathClassHolderSource classSource = new ClasspathClassHolderSource(classLoader);
            for (String testClass : this.testClasses) {
                classHolder = classSource.get(testClass);
                if (classHolder == null) {
                    throw new MojoFailureException("Could not find class " + testClass);
                }
                this.findTests((ClassHolder)classHolder);
            }
            this.transformerInstances = this.instantiateTransformers(classLoader);
            this.includeAdditionalScripts(classLoader);
            File allTestsFile = new File(this.outputDir, "tests/all.js");
            OutputStreamWriter allTestsWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(allTestsFile), "UTF-8");
            classHolder = null;
            try {
                allTestsWriter.write("prepare = function() {\n");
                allTestsWriter.write("    return new JUnitServer(document.body).readTests([");
                boolean first = true;
                for (String testClass : this.testClasses) {
                    if (!first) {
                        ((Writer)allTestsWriter).append(",");
                    }
                    first = false;
                    ((Writer)allTestsWriter).append("\n        { name : \"").append(testClass).append("\", methods : [");
                    boolean firstMethod = true;
                    for (MethodReference methodRef : this.groupedMethods.get(testClass)) {
                        String scriptName = "tests/" + this.fileNames.size() + ".js";
                        this.fileNames.put(methodRef, scriptName);
                        if (!firstMethod) {
                            ((Writer)allTestsWriter).append(",");
                        }
                        firstMethod = false;
                        ((Writer)allTestsWriter).append("\n            { name : \"" + methodRef.getName() + "\", script : \"" + scriptName + "\", expected : [");
                        MethodHolder methodHolder = classSource.get(testClass).getMethod(methodRef.getDescriptor());
                        boolean firstException = true;
                        for (String exception : this.adapter.getExpectedExceptions((MethodReader)methodHolder)) {
                            if (!firstException) {
                                ((Writer)allTestsWriter).append(", ");
                            }
                            firstException = false;
                            ((Writer)allTestsWriter).append("\"" + exception + "\"");
                        }
                        ((Writer)allTestsWriter).append("], additionalScripts : [");
                        for (int i = 0; i < this.additionalScriptLocalPaths.size(); ++i) {
                            if (i > 0) {
                                ((Writer)allTestsWriter).append(", ");
                            }
                            this.escapeString(this.additionalScriptLocalPaths.get(i), allTestsWriter);
                        }
                        ((Writer)allTestsWriter).append("] }");
                    }
                    ((Writer)allTestsWriter).append("] }");
                }
                allTestsWriter.write("], function() {}); }");
            }
            catch (Throwable x2) {
                classHolder = x2;
                throw x2;
            }
            finally {
                if (allTestsWriter != null) {
                    if (classHolder != null) {
                        try {
                            ((Writer)allTestsWriter).close();
                        }
                        catch (Throwable x2) {
                            ((Throwable)classHolder).addSuppressed(x2);
                        }
                    } else {
                        ((Writer)allTestsWriter).close();
                    }
                }
            }
            int methodsGenerated = 0;
            log.info((CharSequence)"Generating test files");
            SimpleFiniteExecutor executor = new SimpleFiniteExecutor();
            if (this.numThreads != 1) {
                int threads = this.numThreads != 0 ? this.numThreads : Runtime.getRuntime().availableProcessors();
                final ThreadPoolFiniteExecutor threadedExecutor = new ThreadPoolFiniteExecutor(threads);
                finalizer = new Runnable(){

                    @Override
                    public void run() {
                        threadedExecutor.stop();
                    }
                };
                executor = threadedExecutor;
            }
            for (final MethodReference method : this.testMethods) {
                executor.execute(new Runnable((ClassHolderSource)classSource){
                    final /* synthetic */ ClassHolderSource val$classSource;
                    {
                        this.val$classSource = classHolderSource;
                    }

                    @Override
                    public void run() {
                        log.debug((CharSequence)("Building test for " + method));
                        try {
                            BuildJavascriptTestMojo.this.decompileClassesForTest(classLoader, (ClassHolderSource)new CopyClassHolderSource(this.val$classSource), method, (String)BuildJavascriptTestMojo.this.fileNames.get(method), (FiniteExecutor)new SimpleFiniteExecutor());
                        }
                        catch (IOException e) {
                            log.error((CharSequence)"Error generating JavaScript", (Throwable)e);
                        }
                    }
                });
                ++methodsGenerated;
            }
            executor.complete();
            log.info((CharSequence)("Test files successfully generated for " + methodsGenerated + " method(s)."));
        }
        catch (IOException e) {
            throw new MojoFailureException("IO error occured generating JavaScript files", (Throwable)e);
        }
        finally {
            if (finalizer != null) {
                finalizer.run();
            }
        }
    }

    private void createAdapter(ClassLoader classLoader) throws MojoExecutionException {
        Constructor<TestAdapter> cons;
        Class<?> adapterClsRaw;
        try {
            adapterClsRaw = Class.forName(this.adapterClass, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Adapter not found: " + this.adapterClass, (Exception)e);
        }
        if (!TestAdapter.class.isAssignableFrom(adapterClsRaw)) {
            throw new MojoExecutionException("Adapter " + this.adapterClass + " does not implement " + TestAdapter.class.getName());
        }
        Class<TestAdapter> adapterCls = adapterClsRaw.asSubclass(TestAdapter.class);
        try {
            cons = adapterCls.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new MojoExecutionException("No default constructor found for test adapter " + this.adapterClass, (Exception)e);
        }
        try {
            this.adapter = cons.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new MojoExecutionException("Error creating test adapter", (Exception)e);
        }
        catch (InvocationTargetException e) {
            throw new MojoExecutionException("Error creating test adapter", e.getTargetException());
        }
    }

    private ClassLoader prepareClassLoader() throws MojoExecutionException {
        try {
            Log log = this.getLog();
            log.info((CharSequence)"Preparing classpath for JavaScript test generation");
            ArrayList<URL> urls = new ArrayList<URL>();
            StringBuilder classpath = new StringBuilder();
            for (Artifact artifact : this.project.getArtifacts()) {
                if (!testScopes.contains(artifact.getScope())) continue;
                File file = artifact.getFile();
                if (classpath.length() > 0) {
                    classpath.append(':');
                }
                classpath.append(file.getPath());
                urls.add(file.toURI().toURL());
            }
            if (classpath.length() > 0) {
                classpath.append(':');
            }
            classpath.append(this.testFiles.getPath());
            urls.add(this.testFiles.toURI().toURL());
            classpath.append(':').append(this.classFiles.getPath());
            urls.add(this.classFiles.toURI().toURL());
            log.info((CharSequence)("Using the following classpath for JavaScript test generation: " + classpath));
            return new URLClassLoader(urls.toArray(new URL[urls.size()]), BuildJavascriptTestMojo.class.getClassLoader());
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Error gathering classpath information", (Exception)e);
        }
    }

    private void decompileClassesForTest(ClassLoader classLoader, ClassHolderSource classSource, MethodReference methodRef, String targetName, FiniteExecutor executor) throws IOException {
        TeaVM vm = new TeaVMBuilder().setClassLoader(classLoader).setClassSource(classSource).setExecutor(executor).build();
        vm.setMinifying(this.minifying);
        vm.installPlugins();
        new TestExceptionPlugin().install((TeaVMHost)vm);
        for (ClassHolderTransformer transformer : this.transformerInstances) {
            vm.add(transformer);
        }
        File file = new File(this.outputDir, targetName);
        try (OutputStreamWriter innerWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");){
            MethodReference cons = new MethodReference(methodRef.getClassName(), new MethodDescriptor("<init>", new ValueType[]{ValueType.VOID}));
            MethodReference exceptionMsg = new MethodReference("java.lang.Throwable", "getMessage", new ValueType[]{ValueType.object((String)"java.lang.String")});
            vm.entryPoint("initInstance", cons);
            vm.entryPoint("runTest", methodRef).withValue(0, cons.getClassName());
            vm.entryPoint("extractException", exceptionMsg);
            vm.exportType("TestClass", cons.getClassName());
            vm.build((Appendable)innerWriter, (BuildTarget)new DirectoryBuildTarget(this.outputDir));
            if (!vm.hasMissingItems()) {
                ((Writer)innerWriter).append("\n");
                ((Writer)innerWriter).append("\nJUnitClient.run();");
                ((Writer)innerWriter).close();
            } else {
                ((Writer)innerWriter).append("JUnitClient.reportError(\n");
                StringBuilder sb = new StringBuilder();
                vm.showMissingItems((Appendable)sb);
                this.escapeStringLiteral(sb.toString(), innerWriter);
                ((Writer)innerWriter).append(");");
                this.getLog().warn((CharSequence)("Error building test " + methodRef));
                this.getLog().warn((CharSequence)sb);
            }
        }
    }

    private void escapeStringLiteral(String text, Writer writer) throws IOException {
        int next;
        int index = 0;
        while ((next = text.indexOf(10, index)) >= 0) {
            this.escapeString(text.substring(index, next + 1), writer);
            writer.append(" +\n");
            index = next + 1;
        }
        this.escapeString(text.substring(index), writer);
    }

    private void escapeString(String string, Writer writer) throws IOException {
        writer.append('\"');
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    writer.append("\\\"");
                    continue block7;
                }
                case '\\': {
                    writer.append("\\\\");
                    continue block7;
                }
                case '\n': {
                    writer.append("\\n");
                    continue block7;
                }
                case '\r': {
                    writer.append("\\r");
                    continue block7;
                }
                case '\t': {
                    writer.append("\\t");
                    continue block7;
                }
                default: {
                    writer.append(c);
                }
            }
        }
        writer.append('\"');
    }

    private void findTestsInDependencies(ClassLoader classLoader) throws MojoExecutionException {
        try {
            Log log = this.getLog();
            log.info((CharSequence)"Scanning dependencies for tests");
            for (Artifact artifact : this.project.getArtifacts()) {
                if (!testScopes.contains(artifact.getScope())) continue;
                File file = artifact.getFile();
                if (file.isDirectory()) {
                    this.findTestClasses(classLoader, file, "");
                    continue;
                }
                if (!file.getName().endsWith(".jar")) continue;
                this.findTestClassesInJar(classLoader, new JarFile(file));
            }
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Error gathering classpath information", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error scanning dependencies for tests", (Exception)e);
        }
    }

    private void findTestClasses(ClassLoader classLoader, File folder, String prefix) {
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                String newPrefix = prefix.isEmpty() ? file.getName() : prefix + "." + file.getName();
                this.findTestClasses(classLoader, file, newPrefix);
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            String className = file.getName().substring(0, file.getName().length() - ".class".length());
            if (!prefix.isEmpty()) {
                className = prefix + "." + className;
            }
            this.addCandidate(classLoader, className);
        }
    }

    private void findTestClassesInJar(ClassLoader classLoader, JarFile jarFile) {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
            String className = entry.getName().substring(0, entry.getName().length() - ".class".length()).replace('/', '.');
            this.addCandidate(classLoader, className);
        }
    }

    private void addCandidate(ClassLoader classLoader, String className) {
        boolean matches = false;
        String simpleName = className.replace('.', '/');
        for (String wildcard : this.wildcards) {
            if (!FilenameUtils.wildcardMatch((String)simpleName, (String)wildcard.replace('.', '/'))) continue;
            matches = true;
            break;
        }
        if (!matches) {
            return;
        }
        try {
            Class<?> candidate = Class.forName(className, true, classLoader);
            if (this.adapter.acceptClass(candidate)) {
                this.testClasses.add(candidate.getName());
                this.getLog().info((CharSequence)("Test class detected: " + candidate.getName()));
            }
        }
        catch (ClassNotFoundException e) {
            this.getLog().info((CharSequence)("Could not load class `" + className + "' to search for tests"));
        }
    }

    private void findTests(ClassHolder cls) {
        for (MethodHolder method : cls.getMethods()) {
            if (!this.adapter.acceptMethod((MethodReader)method)) continue;
            MethodReference ref = new MethodReference(cls.getName(), method.getDescriptor());
            this.testMethods.add(ref);
            List<MethodReference> group = this.groupedMethods.get(cls.getName());
            if (group == null) {
                group = new ArrayList<MethodReference>();
                this.groupedMethods.put(cls.getName(), group);
            }
            group.add(ref);
        }
    }

    private void resourceToFile(String resource, String fileName) throws IOException {
        try (InputStream input = BuildJavascriptTestMojo.class.getClassLoader().getResourceAsStream(resource);
             FileOutputStream output = new FileOutputStream(new File(this.outputDir, fileName));){
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
    }

    private List<ClassHolderTransformer> instantiateTransformers(ClassLoader classLoader) throws MojoExecutionException {
        ArrayList<ClassHolderTransformer> transformerInstances = new ArrayList<ClassHolderTransformer>();
        if (this.transformers == null) {
            return transformerInstances;
        }
        for (String transformerName : this.transformers) {
            Constructor<ClassHolderTransformer> ctor;
            Class<?> transformerRawType;
            try {
                transformerRawType = Class.forName(transformerName, true, classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new MojoExecutionException("Transformer not found: " + transformerName, (Exception)e);
            }
            if (!ClassHolderTransformer.class.isAssignableFrom(transformerRawType)) {
                throw new MojoExecutionException("Transformer " + transformerName + " is not subtype of " + ClassHolderTransformer.class.getName());
            }
            Class<ClassHolderTransformer> transformerType = transformerRawType.asSubclass(ClassHolderTransformer.class);
            try {
                ctor = transformerType.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new MojoExecutionException("Transformer " + transformerName + " has no default constructor");
            }
            try {
                ClassHolderTransformer transformer = ctor.newInstance(new Object[0]);
                transformerInstances.add(transformer);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new MojoExecutionException("Error instantiating transformer " + transformerName, (Exception)e);
            }
        }
        return transformerInstances;
    }

    private void includeAdditionalScripts(ClassLoader classLoader) throws MojoExecutionException {
        if (this.additionalScripts == null) {
            return;
        }
        for (String script : this.additionalScripts) {
            String simpleName = script.substring(script.lastIndexOf(47) + 1);
            this.additionalScriptLocalPaths.add("tests/" + simpleName);
            if (classLoader.getResource(script) == null) {
                throw new MojoExecutionException("Additional script " + script + " was not found");
            }
            File file = new File(this.outputDir, "tests/" + simpleName);
            try (InputStream in = classLoader.getResourceAsStream(script);){
                if (!file.exists()) {
                    file.createNewFile();
                }
                try (FileOutputStream out = new FileOutputStream(file);){
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error copying additional script " + script, (Exception)e);
            }
        }
    }
}

