/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.maven;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.teavm.common.FiniteExecutor;
import org.teavm.common.ThreadPoolFiniteExecutor;
import org.teavm.javascript.RenderingContext;
import org.teavm.maven.RuntimeCopyOperation;
import org.teavm.model.ClassHolderSource;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.parsing.ClasspathClassHolderSource;
import org.teavm.vm.BuildTarget;
import org.teavm.vm.DirectoryBuildTarget;
import org.teavm.vm.TeaVM;
import org.teavm.vm.TeaVMBuilder;
import org.teavm.vm.spi.AbstractRendererListener;
import org.teavm.vm.spi.RendererListener;

@Mojo(name="build-javascript", requiresDependencyResolution=ResolutionScope.COMPILE, requiresDependencyCollection=ResolutionScope.COMPILE)
public class BuildJavascriptMojo
extends AbstractMojo {
    private static Set<String> compileScopes = new HashSet<String>(Arrays.asList("compile", "provided", "system"));
    @Component
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/javascript")
    private File targetDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File classFiles;
    @Parameter
    private String targetFileName = "classes.js";
    @Parameter
    private boolean minifying = true;
    @Parameter
    private String mainClass;
    @Parameter
    private RuntimeCopyOperation runtime = RuntimeCopyOperation.SEPARATE;
    @Parameter
    private Properties properties;
    @Parameter
    private boolean mainPageIncluded;
    @Parameter
    private boolean bytecodeLogging;
    @Parameter(required=false)
    private int numThreads = 1;
    @Parameter
    private String[] transformers;
    private AbstractRendererListener runtimeInjector = new AbstractRendererListener(){

        public void begin(RenderingContext context, BuildTarget buildTarget) throws IOException {
            StringWriter writer = new StringWriter();
            BuildJavascriptMojo.this.resourceToWriter("org/teavm/javascript/runtime.js", writer);
            writer.close();
            context.getWriter().append(writer.toString()).newLine();
        }
    };

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setTargetDirectory(File targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public void setTargetFileName(String targetFileName) {
        this.targetFileName = targetFileName;
    }

    public void setClassFiles(File classFiles) {
        this.classFiles = classFiles;
    }

    public void setMinifying(boolean minifying) {
        this.minifying = minifying;
    }

    public void setBytecodeLogging(boolean bytecodeLogging) {
        this.bytecodeLogging = bytecodeLogging;
    }

    public void setRuntimeCopy(RuntimeCopyOperation runtimeCopy) {
        this.runtime = runtimeCopy;
    }

    public void setMainPageIncluded(boolean mainPageIncluded) {
        this.mainPageIncluded = mainPageIncluded;
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public String[] getTransformers() {
        return this.transformers;
    }

    public void setTransformers(String[] transformers) {
        this.transformers = transformers;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void execute() throws MojoExecutionException {
        block49: {
            Log log = this.getLog();
            Runnable finalizer = null;
            try {
                String text;
                ClassLoader classLoader = this.prepareClassLoader();
                log.info((CharSequence)"Building JavaScript file");
                TeaVMBuilder vmBuilder = new TeaVMBuilder();
                vmBuilder.setClassLoader(classLoader).setClassSource((ClassHolderSource)new ClasspathClassHolderSource(classLoader));
                if (this.numThreads != 1) {
                    int threads = this.numThreads != 0 ? this.numThreads : Runtime.getRuntime().availableProcessors();
                    final ThreadPoolFiniteExecutor executor = new ThreadPoolFiniteExecutor(threads);
                    finalizer = new Runnable(){

                        @Override
                        public void run() {
                            executor.stop();
                        }
                    };
                    vmBuilder.setExecutor((FiniteExecutor)executor);
                }
                TeaVM vm = vmBuilder.build();
                vm.setMinifying(this.minifying);
                vm.setBytecodeLogging(this.bytecodeLogging);
                vm.setProperties(this.properties);
                vm.installPlugins();
                for (ClassHolderTransformer classHolderTransformer : this.instantiateTransformers(classLoader)) {
                    vm.add(classHolderTransformer);
                }
                if (this.mainClass != null) {
                    MethodDescriptor mainMethodDesc = new MethodDescriptor("main", new ValueType[]{ValueType.arrayOf((ValueType)ValueType.object((String)"java.lang.String")), ValueType.VOID});
                    vm.entryPoint("main", new MethodReference(this.mainClass, mainMethodDesc)).withValue(1, "java.lang.String");
                }
                this.targetDirectory.mkdirs();
                Throwable throwable = null;
                try (FileWriter writer = new FileWriter(new File(this.targetDirectory, this.targetFileName));){
                    if (this.runtime == RuntimeCopyOperation.MERGED) {
                        vm.add((RendererListener)this.runtimeInjector);
                    }
                    vm.build((Appendable)writer, (BuildTarget)new DirectoryBuildTarget(this.targetDirectory));
                    vm.checkForMissingItems();
                    log.info((CharSequence)"JavaScript file successfully built");
                }
                catch (Throwable x2) {
                    Throwable throwable2 = x2;
                    throw x2;
                }
                if (this.runtime == RuntimeCopyOperation.SEPARATE) {
                    this.resourceToFile("org/teavm/javascript/runtime.js", "runtime.js");
                }
                if (!this.mainPageIncluded) break block49;
                try (InputStreamReader inputStreamReader = new InputStreamReader(classLoader.getResourceAsStream("org/teavm/maven/main.html"), "UTF-8");){
                    text = IOUtils.toString((Reader)inputStreamReader).replace("${classes.js}", this.targetFileName);
                }
                File file = new File(this.targetDirectory, "main.html");
                try (OutputStreamWriter writer2 = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");){
                    ((Writer)writer2).append(text);
                }
            }
            catch (RuntimeException e) {
                throw new MojoExecutionException("Unexpected error occured", (Exception)e);
            }
            catch (IOException e) {
                throw new MojoExecutionException("IO error occured", (Exception)e);
            }
            finally {
                if (finalizer != null) {
                    finalizer.run();
                }
            }
        }
    }

    private List<ClassHolderTransformer> instantiateTransformers(ClassLoader classLoader) throws MojoExecutionException {
        ArrayList<ClassHolderTransformer> transformerInstances = new ArrayList<ClassHolderTransformer>();
        if (this.transformers == null) {
            return transformerInstances;
        }
        for (String transformerName : this.transformers) {
            Constructor<ClassHolderTransformer> ctor;
            Class<?> transformerRawType;
            try {
                transformerRawType = Class.forName(transformerName, true, classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new MojoExecutionException("Transformer not found: " + transformerName, (Exception)e);
            }
            if (!ClassHolderTransformer.class.isAssignableFrom(transformerRawType)) {
                throw new MojoExecutionException("Transformer " + transformerName + " is not subtype of " + ClassHolderTransformer.class.getName());
            }
            Class<ClassHolderTransformer> transformerType = transformerRawType.asSubclass(ClassHolderTransformer.class);
            try {
                ctor = transformerType.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new MojoExecutionException("Transformer " + transformerName + " has no default constructor");
            }
            try {
                ClassHolderTransformer transformer = ctor.newInstance(new Object[0]);
                transformerInstances.add(transformer);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new MojoExecutionException("Error instantiating transformer " + transformerName, (Exception)e);
            }
        }
        return transformerInstances;
    }

    private ClassLoader prepareClassLoader() throws MojoExecutionException {
        try {
            Log log = this.getLog();
            log.info((CharSequence)"Preparing classpath for JavaScript generation");
            ArrayList<URL> urls = new ArrayList<URL>();
            StringBuilder classpath = new StringBuilder();
            for (Artifact artifact : this.project.getArtifacts()) {
                if (!compileScopes.contains(artifact.getScope())) continue;
                File file = artifact.getFile();
                if (classpath.length() > 0) {
                    classpath.append(':');
                }
                classpath.append(file.getPath());
                urls.add(file.toURI().toURL());
            }
            if (classpath.length() > 0) {
                classpath.append(':');
            }
            classpath.append(this.classFiles.getPath());
            urls.add(this.classFiles.toURI().toURL());
            log.info((CharSequence)("Using the following classpath for JavaScript generation: " + classpath));
            return new URLClassLoader(urls.toArray(new URL[urls.size()]), BuildJavascriptMojo.class.getClassLoader());
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Error gathering classpath information", (Exception)e);
        }
    }

    private void resourceToFile(String resource, String fileName) throws IOException {
        try (InputStream input = BuildJavascriptMojo.class.getClassLoader().getResourceAsStream(resource);
             FileOutputStream output = new FileOutputStream(new File(this.targetDirectory, fileName));){
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
    }

    private void resourceToWriter(String resource, Writer writer) throws IOException {
        try (InputStream input = BuildJavascriptMojo.class.getClassLoader().getResourceAsStream(resource);){
            IOUtils.copy((InputStream)input, (Writer)writer, (String)"UTF-8");
        }
    }
}

