/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.junit;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.teavm.junit.TestRun;
import org.teavm.junit.TestRunStrategy;

class WasiRunStrategy
implements TestRunStrategy {
    private String runCommand;

    WasiRunStrategy(String runCommand) {
        this.runCommand = runCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runTest(TestRun run) throws IOException {
        try {
            ArrayList<String> commandLine = new ArrayList<String>();
            commandLine.add(this.runCommand);
            commandLine.add(new File(run.getBaseDirectory(), run.getFileName()).getAbsolutePath());
            if (run.getArgument() != null) {
                commandLine.add(run.getArgument());
            }
            ArrayList<String> runtimeOutput = new ArrayList<String>();
            ArrayList<String> stdout = new ArrayList<String>();
            WasiRunStrategy wasiRunStrategy = this;
            synchronized (wasiRunStrategy) {
                this.runProcess(new ProcessBuilder(commandLine.toArray(new String[0])).start(), runtimeOutput, stdout);
            }
            if (stdout.isEmpty() || !((String)stdout.get(stdout.size() - 1)).equals("SUCCESS")) {
                throw new RuntimeException("Test failed:\n" + this.mergeLines(runtimeOutput));
            }
            this.writeLines(runtimeOutput);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private String mergeLines(List<String> lines) {
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(line).append('\n');
        }
        return sb.toString();
    }

    private void writeLines(List<String> lines) {
        for (String line : lines) {
            System.out.println(line);
        }
    }

    private boolean runProcess(Process process, List<String> output, List<String> stdout) throws InterruptedException {
        BufferedReader stdin = new BufferedReader(new InputStreamReader(process.getInputStream()));
        BufferedReader stderr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        ConcurrentLinkedQueue<String> lines = new ConcurrentLinkedQueue<String>();
        Thread thread = new Thread(() -> {
            try {
                String line;
                while ((line = stderr.readLine()) != null) {
                    lines.add(line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        thread.setDaemon(true);
        thread.start();
        try {
            String line;
            while ((line = stdin.readLine()) != null) {
                lines.add(line);
                stdout.add(line);
                if (lines.size() <= 10000) continue;
                output.addAll(lines);
                process.destroy();
                return false;
            }
        }
        catch (IOException line) {
            // empty catch block
        }
        boolean result = process.waitFor() == 0;
        output.addAll(lines);
        return result;
    }
}

