/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.junit;

import org.teavm.jso.JSBody;
import org.teavm.junit.TestEntryPoint;

final class TestJsEntryPoint {
    private TestJsEntryPoint() {
    }

    public static void main(String[] args) throws Throwable {
        try {
            TestEntryPoint.run(args.length > 0 ? args[0] : null);
        }
        catch (Throwable e) {
            StringBuilder sb = new StringBuilder();
            TestJsEntryPoint.printStackTrace(e, sb);
            TestJsEntryPoint.saveJavaException(sb.toString());
            throw e;
        }
    }

    private static void printStackTrace(Throwable e, StringBuilder stream) {
        stream.append(e.getClass().getName());
        String message = e.getLocalizedMessage();
        if (message != null) {
            stream.append(": " + message);
        }
        stream.append("\n");
        StackTraceElement[] stackTrace = e.getStackTrace();
        if (stackTrace != null) {
            for (StackTraceElement element : stackTrace) {
                stream.append("\tat ");
                stream.append(element).append("\n");
            }
        }
        if (e.getCause() != null && e.getCause() != e) {
            stream.append("Caused by: ");
            TestJsEntryPoint.printStackTrace(e.getCause(), stream);
        }
    }

    @JSBody(params={"e"}, script="teavmException = e")
    private static native void saveJavaException(String var0);
}

