/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.junit;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.teavm.junit.AttachJavaScript;
import org.teavm.junit.TestRun;
import org.teavm.junit.TestRunCallback;
import org.teavm.junit.TestRunStrategy;

class BrowserRunStrategy
implements TestRunStrategy {
    private boolean decodeStack = Boolean.parseBoolean(System.getProperty("teavm.junit.js.decodeStack", "true"));
    private final File baseDir;
    private final String type;
    private final Function<String, Process> browserRunner;
    private Process browserProcess;
    private Server server;
    private int port;
    private AtomicInteger idGenerator = new AtomicInteger(0);
    private BlockingQueue<Session> wsSessionQueue = new LinkedBlockingQueue<Session>();
    private ConcurrentMap<Integer, CallbackWrapper> awaitingRuns = new ConcurrentHashMap<Integer, CallbackWrapper>();
    private ObjectMapper objectMapper = new ObjectMapper();

    BrowserRunStrategy(File baseDir, String type, Function<String, Process> browserRunner) {
        this.baseDir = baseDir;
        this.type = type;
        this.browserRunner = browserRunner;
    }

    @Override
    public void beforeAll() {
        this.runServer();
        this.browserProcess = this.browserRunner.apply("http://localhost:" + this.port + "/index.html");
    }

    private void runServer() {
        this.server = new Server();
        ServerConnector connector = new ServerConnector(this.server);
        this.server.addConnector((Connector)connector);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        this.server.setHandler((Handler)context);
        TestCodeServlet servlet = new TestCodeServlet();
        ServletHolder servletHolder = new ServletHolder((Servlet)servlet);
        servletHolder.setAsyncSupported(true);
        context.addServlet(servletHolder, "/*");
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.port = connector.getLocalPort();
    }

    @Override
    public void afterAll() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.browserProcess != null) {
            this.browserProcess.destroy();
        }
    }

    @Override
    public void runTest(TestRun run) throws IOException {
        while (!this.runTestOnce(run)) {
        }
    }

    private boolean runTestOnce(TestRun run) {
        Session ws;
        try {
            while ((ws = this.wsSessionQueue.poll(1L, TimeUnit.SECONDS)) == null || !ws.isOpen()) {
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return true;
        }
        int id = this.idGenerator.incrementAndGet();
        CountDownLatch latch = new CountDownLatch(1);
        CallbackWrapper callbackWrapper = new CallbackWrapper(latch);
        this.awaitingRuns.put(id, callbackWrapper);
        JsonNodeFactory nf = this.objectMapper.getNodeFactory();
        ObjectNode node = nf.objectNode();
        node.set("id", (JsonNode)nf.numberNode(id));
        ArrayNode array = nf.arrayNode();
        node.set("tests", (JsonNode)array);
        File file = new File(run.getBaseDirectory(), run.getFileName()).getAbsoluteFile();
        String relPath = this.baseDir.getAbsoluteFile().toPath().relativize(file.toPath()).toString();
        ObjectNode testNode = nf.objectNode();
        testNode.set("type", (JsonNode)nf.textNode(this.type));
        testNode.set("name", (JsonNode)nf.textNode(run.getFileName()));
        testNode.set("file", (JsonNode)nf.textNode("tests/" + relPath));
        String[] additionalJs = this.additionalJs(run);
        if (additionalJs.length > 0) {
            ArrayNode additionalJsJson = nf.arrayNode();
            for (String additionalFile : additionalJs) {
                additionalJsJson.add("resources/" + additionalFile);
            }
            testNode.set("additionalFiles", (JsonNode)additionalJsJson);
        }
        if (run.getArgument() != null) {
            testNode.set("argument", (JsonNode)nf.textNode(run.getArgument()));
        }
        array.add((JsonNode)testNode);
        String message = node.toString();
        ws.getRemote().sendStringByFuture(message);
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (ws.isOpen()) {
            this.wsSessionQueue.offer(ws);
        }
        if (callbackWrapper.error != null) {
            Throwable err = callbackWrapper.error;
            if (err instanceof RuntimeException) {
                throw (RuntimeException)err;
            }
            throw new RuntimeException(err);
        }
        return !callbackWrapper.shouldRepeat;
    }

    private String[] additionalJs(TestRun run) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Method method = run.getMethod();
        AttachJavaScript attachAnnot = method.getAnnotation(AttachJavaScript.class);
        if (attachAnnot != null) {
            result.addAll(List.of(attachAnnot.value()));
        }
        for (Class<?> cls = method.getDeclaringClass(); cls != null; cls = cls.getSuperclass()) {
            AttachJavaScript classAttachAnnot = cls.getAnnotation(AttachJavaScript.class);
            if (classAttachAnnot == null) continue;
            result.addAll(List.of(attachAnnot.value()));
        }
        return result.toArray(new String[0]);
    }

    static Process customBrowser(String url) {
        System.out.println("Open link to run tests: " + url + "?logging=true");
        return null;
    }

    static Process chromeBrowser(String url) {
        return BrowserRunStrategy.browserTemplate("chrome", url, (profile, params) -> {
            BrowserRunStrategy.addChromeCommand(params);
            params.addAll(Arrays.asList("--headless", "--disable-gpu", "--remote-debugging-port=9222", "--no-first-run", "--user-data-dir=" + profile));
        });
    }

    static Process firefoxBrowser(String url) {
        return BrowserRunStrategy.browserTemplate("firefox", url, (profile, params) -> {
            BrowserRunStrategy.addFirefoxCommand(params);
            params.addAll(Arrays.asList("--headless", "--profile", profile));
        });
    }

    private static void addChromeCommand(List<String> params) {
        if (BrowserRunStrategy.isMacos()) {
            params.add("/Applications/Google Chrome.app/Contents/MacOS/Google Chrome");
        } else if (BrowserRunStrategy.isWindows()) {
            params.add("cmd.exe");
            params.add("start");
            params.add("/C");
            params.add("chrome");
        } else {
            params.add("google-chrome-stable");
        }
    }

    private static void addFirefoxCommand(List<String> params) {
        if (BrowserRunStrategy.isMacos()) {
            params.add("/Applications/Firefox.app/Contents/MacOS/firefox");
            return;
        }
        if (BrowserRunStrategy.isWindows()) {
            params.add("cmd.exe");
            params.add("/C");
            params.add("start");
        }
        params.add("firefox");
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    private static boolean isMacos() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac");
    }

    private static Process browserTemplate(String name, String url, BiConsumer<String, List<String>> paramsBuilder) {
        try {
            File temp = File.createTempFile("teavm", "teavm");
            temp.delete();
            temp.mkdirs();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> BrowserRunStrategy.deleteDir(temp)));
            System.out.println("Running " + name + " with user data dir: " + temp.getAbsolutePath());
            ArrayList<String> params = new ArrayList<String>();
            paramsBuilder.accept(temp.getAbsolutePath(), params);
            params.add(url);
            ProcessBuilder pb = new ProcessBuilder(params.toArray(new String[0]));
            Process process = pb.start();
            BrowserRunStrategy.logStream(process.getInputStream(), name + " stdout");
            BrowserRunStrategy.logStream(process.getErrorStream(), name + " stderr");
            new Thread(() -> {
                try {
                    System.out.println(name + " process terminated with code: " + process.waitFor());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
            return process;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void logStream(InputStream stream, String name) {
        new Thread(() -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                String line;
                while ((line = reader.readLine()) != null) {
                    System.out.println(name + ": " + line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }).start();
    }

    private static void deleteDir(File dir) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                BrowserRunStrategy.deleteDir(file);
                continue;
            }
            file.delete();
        }
        dir.delete();
    }

    class TestCodeServlet
    extends HttpServlet {
        private WebSocketServletFactory wsFactory;
        private Map<String, String> contentCache = new ConcurrentHashMap<String, String>();

        TestCodeServlet() {
        }

        public void init(ServletConfig config) throws ServletException {
            super.init(config);
            WebSocketPolicy wsPolicy = new WebSocketPolicy(WebSocketBehavior.SERVER);
            this.wsFactory = WebSocketServletFactory.Loader.load((ServletContext)config.getServletContext(), (WebSocketPolicy)wsPolicy);
            this.wsFactory.setCreator((req, resp) -> new TestCodeSocket());
            try {
                this.wsFactory.start();
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }

        protected void service(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            Object path = req.getRequestURI();
            if (path != null) {
                if (!((String)path).startsWith("/")) {
                    path = "/" + (String)path;
                }
                if (req.getMethod().equals("GET")) {
                    InputStream input;
                    String relPath;
                    File file;
                    switch (path) {
                        case "/index.html": 
                        case "/frame.html": {
                            String content = this.getFromCache((String)path, "true".equals(req.getParameter("logging")));
                            if (content == null) break;
                            resp.setStatus(200);
                            resp.setContentType("text/html");
                            resp.getOutputStream().write(content.getBytes(StandardCharsets.UTF_8));
                            resp.getOutputStream().flush();
                            return;
                        }
                        case "/client.js": 
                        case "/frame.js": 
                        case "/deobfuscator.js": {
                            String content = this.getFromCache((String)path, false);
                            if (content == null) break;
                            resp.setStatus(200);
                            resp.setContentType("application/javascript");
                            resp.getOutputStream().write(content.getBytes(StandardCharsets.UTF_8));
                            resp.getOutputStream().flush();
                            return;
                        }
                    }
                    if (((String)path).startsWith("/tests/") && (file = new File(BrowserRunStrategy.this.baseDir, relPath = ((String)path).substring("/tests/".length()))).isFile()) {
                        resp.setStatus(200);
                        if (file.getName().endsWith(".js")) {
                            resp.setContentType("application/javascript");
                        } else if (file.getName().endsWith(".wasm")) {
                            resp.setContentType("application/wasm");
                        }
                        input = new FileInputStream(file);
                        try {
                            ((FileInputStream)input).transferTo((OutputStream)resp.getOutputStream());
                        }
                        finally {
                            ((FileInputStream)input).close();
                        }
                        resp.getOutputStream().flush();
                    }
                    if (((String)path).startsWith("/resources/")) {
                        relPath = ((String)path).substring("/resources/".length());
                        ClassLoader classLoader = BrowserRunStrategy.class.getClassLoader();
                        input = classLoader.getResourceAsStream(relPath);
                        try {
                            if (input != null) {
                                resp.setStatus(200);
                                input.transferTo((OutputStream)resp.getOutputStream());
                            } else {
                                resp.setStatus(404);
                            }
                            resp.getOutputStream().flush();
                        }
                        finally {
                            if (input != null) {
                                input.close();
                            }
                        }
                    }
                }
                if (((String)path).equals("/ws") && this.wsFactory.isUpgradeRequest(req, resp) && (this.wsFactory.acceptWebSocket(req, resp) || resp.isCommitted())) {
                    return;
                }
            }
            resp.setStatus(404);
        }

        private String getFromCache(String fileName, boolean logging) {
            return this.contentCache.computeIfAbsent(fileName, fn -> {
                ClassLoader loader = BrowserRunStrategy.class.getClassLoader();
                try (InputStream input = loader.getResourceAsStream("test-server" + fn);){
                    String string;
                    try (InputStreamReader reader = new InputStreamReader(input);){
                        int charsRead;
                        StringBuilder sb = new StringBuilder();
                        char[] buffer = new char[2048];
                        while ((charsRead = reader.read(buffer)) >= 0) {
                            sb.append(buffer, 0, charsRead);
                        }
                        string = sb.toString().replace("{{PORT}}", String.valueOf(BrowserRunStrategy.this.port)).replace("\"{{LOGGING}}\"", String.valueOf(logging)).replace("\"{{DEOBFUSCATION}}\"", String.valueOf(BrowserRunStrategy.this.decodeStack));
                    }
                    return string;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            });
        }
    }

    static class CallbackWrapper
    implements TestRunCallback {
        private final CountDownLatch latch;
        volatile Throwable error;
        volatile boolean shouldRepeat;

        CallbackWrapper(CountDownLatch latch) {
            this.latch = latch;
        }

        @Override
        public void complete() {
            this.latch.countDown();
        }

        @Override
        public void error(Throwable e) {
            this.error = e;
            this.latch.countDown();
        }

        void repeat() {
            this.latch.countDown();
            this.shouldRepeat = true;
        }
    }

    class TestCodeSocket
    extends WebSocketAdapter {
        TestCodeSocket() {
        }

        public void onWebSocketConnect(Session sess) {
            BrowserRunStrategy.this.wsSessionQueue.offer(sess);
        }

        public void onWebSocketClose(int statusCode, String reason) {
            for (CallbackWrapper run : BrowserRunStrategy.this.awaitingRuns.values()) {
                run.repeat();
            }
        }

        public void onWebSocketText(String message) {
            String status;
            JsonNode node;
            try {
                node = BrowserRunStrategy.this.objectMapper.readTree((Reader)new StringReader(message));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            int id = node.get("id").asInt();
            TestRunCallback run = (TestRunCallback)BrowserRunStrategy.this.awaitingRuns.remove(id);
            if (run == null) {
                System.err.println("Unexpected run id: " + id);
                return;
            }
            JsonNode resultNode = node.get("result");
            JsonNode log = resultNode.get("log");
            if (log != null) {
                for (JsonNode logEntry : log) {
                    String str = logEntry.get("message").asText();
                    switch (logEntry.get("type").asText()) {
                        case "stdout": {
                            System.out.println(str);
                            break;
                        }
                        case "stderr": {
                            System.err.println(str);
                        }
                    }
                }
            }
            if ((status = resultNode.get("status").asText()).equals("OK")) {
                run.complete();
            } else {
                run.error(new RuntimeException(resultNode.get("errorMessage").asText()));
            }
        }
    }
}

