/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.junit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teavm.junit.TeaVMTestRunner;
import org.teavm.junit.TestEntryPoint;
import org.teavm.model.AnnotationReader;
import org.teavm.model.AnnotationValue;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassHolderTransformerContext;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldHolder;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.TryCatchBlock;
import org.teavm.model.ValueType;
import org.teavm.model.emit.PhiEmitter;
import org.teavm.model.emit.ProgramEmitter;
import org.teavm.model.emit.ValueEmitter;
import org.teavm.vm.spi.TeaVMHost;
import org.teavm.vm.spi.TeaVMPlugin;

abstract class TestEntryPointTransformer
implements ClassHolderTransformer,
TeaVMPlugin {
    private String testClassName;
    private int suffixGenerator;

    TestEntryPointTransformer(String testClassName) {
        this.testClassName = testClassName;
    }

    public void install(TeaVMHost host) {
        host.add((ClassHolderTransformer)this);
    }

    public void transformClass(ClassHolder cls, ClassHolderTransformerContext context) {
        if (cls.getName().equals(TestEntryPoint.class.getName())) {
            this.suffixGenerator = 0;
            for (MethodHolder method : cls.getMethods()) {
                switch (method.getName()) {
                    case "createTestCase": {
                        this.generateCreateTestCaseProgram(method, context.getHierarchy());
                        method.getModifiers().remove(ElementModifier.NATIVE);
                        break;
                    }
                    case "launchers": {
                        this.generateLaunchProgram(method, context);
                        method.getModifiers().remove(ElementModifier.NATIVE);
                        break;
                    }
                    case "before": {
                        this.generateBeforeProgram(method, context.getHierarchy());
                        method.getModifiers().remove(ElementModifier.NATIVE);
                        break;
                    }
                    case "after": {
                        this.generateAfterProgram(method, context.getHierarchy());
                        method.getModifiers().remove(ElementModifier.NATIVE);
                    }
                }
            }
        }
    }

    private void generateCreateTestCaseProgram(MethodHolder method, ClassHierarchy hierarchy) {
        ProgramEmitter pe = ProgramEmitter.create((MethodHolder)method, (ClassHierarchy)hierarchy);
        pe.construct(this.testClassName, new ValueEmitter[0]).cast(Object.class).returnValue();
    }

    private void generateBeforeProgram(MethodHolder method, ClassHierarchy hierarchy) {
        ProgramEmitter pe = ProgramEmitter.create((MethodHolder)method, (ClassHierarchy)hierarchy);
        ValueEmitter testCaseVar = pe.getField(TestEntryPoint.class, "testCase", Object.class);
        if (hierarchy.isSuperType("junit.framework.TestCase", this.testClassName, false)) {
            testCaseVar.cast((ValueType)ValueType.object((String)"junit.framework.TestCase")).invokeVirtual(TeaVMTestRunner.JUNIT3_BEFORE, new ValueEmitter[0]);
        }
        List<ClassReader> classes = this.collectSuperClasses(pe.getClassSource(), this.testClassName);
        Collections.reverse(classes);
        classes.stream().flatMap(cls -> cls.getMethods().stream()).filter(m -> m.getAnnotations().get("org.junit.Before") != null || m.getAnnotations().get("org.testng.annotations.BeforeMethod") != null).forEach(m -> testCaseVar.cast((ValueType)ValueType.object((String)m.getOwnerName())).invokeVirtual(m.getReference(), new ValueEmitter[0]));
        pe.exit();
    }

    private Program generateAfterProgram(MethodHolder method, ClassHierarchy hierarchy) {
        ProgramEmitter pe = ProgramEmitter.create((MethodHolder)method, (ClassHierarchy)hierarchy);
        ValueEmitter testCaseVar = pe.getField(TestEntryPoint.class, "testCase", Object.class);
        List<ClassReader> classes = this.collectSuperClasses(pe.getClassSource(), this.testClassName);
        classes.stream().flatMap(cls -> cls.getMethods().stream()).filter(m -> m.getAnnotations().get("org.junit.After") != null || m.getAnnotations().get("org.testng.annotations.AfterMethod") != null).forEach(m -> testCaseVar.cast((ValueType)ValueType.object((String)m.getOwnerName())).invokeVirtual(m.getReference(), new ValueEmitter[0]));
        if (hierarchy.isSuperType("junit.framework.TestCase", this.testClassName, false)) {
            testCaseVar.cast((ValueType)ValueType.object((String)"junit.framework.TestCase")).invokeVirtual(TeaVMTestRunner.JUNIT3_AFTER, new ValueEmitter[0]);
        }
        pe.exit();
        return pe.getProgram();
    }

    private List<ClassReader> collectSuperClasses(ClassReaderSource classSource, String className) {
        ClassReader cls;
        ArrayList<ClassReader> result = new ArrayList<ClassReader>();
        while (className != null && !className.equals("junit.framework.TestCase") && (cls = classSource.get(className)) != null) {
            result.add(cls);
            className = cls.getParent();
        }
        return result;
    }

    protected abstract void generateLaunchProgram(MethodHolder var1, ClassHolderTransformerContext var2);

    protected final void generateSingleMethodLaunchProgram(MethodReference testMethod, ClassHolderTransformerContext context, ProgramEmitter pe) {
        AnnotationValue dataProviderValue;
        ClassHolder launcherClass = this.generateLauncherClass(testMethod, context.getHierarchy());
        context.submit(launcherClass);
        ValueEmitter list = pe.var(2, List.class);
        MethodReader testMethodReader = context.getHierarchy().getClassSource().resolve(testMethod);
        AnnotationReader testNgAnnot = testMethodReader.getAnnotations().get("org.testng.annotations.Test");
        if (testNgAnnot != null && (dataProviderValue = testNgAnnot.getValue("dataProvider")) != null) {
            this.generateAddLaunchersWithProvider(testMethodReader, context.getHierarchy(), pe, list, dataProviderValue.getString(), launcherClass.getName());
            return;
        }
        list.invokeVirtual("add", Boolean.TYPE, new ValueEmitter[]{pe.construct(launcherClass.getName(), new ValueEmitter[0]).cast(Object.class)});
        pe.exit();
    }

    private void generateAddLaunchersWithProvider(MethodReader testMethodReader, ClassHierarchy hierarchy, ProgramEmitter pe, ValueEmitter list, String providerName, String launcherClassName) {
        ValueEmitter data;
        ClassReader owningClass = hierarchy.getClassSource().get(testMethodReader.getOwnerName());
        MethodReader providerMethod = null;
        for (MethodReader method : owningClass.getMethods()) {
            AnnotationReader annot = method.getAnnotations().get("org.testng.annotations.DataProvider");
            if (annot == null || !annot.getValue("name").getString().equals(providerName)) continue;
            providerMethod = method;
            break;
        }
        if ((data = pe.getField(TestEntryPoint.class, "testCase", Object.class).cast((ValueType)ValueType.object((String)testMethodReader.getOwnerName())).invokeSpecial(providerMethod.getReference(), new ValueEmitter[0])).getType() instanceof ValueType.Array) {
            this.generateAddLaunchersWithProviderArray(testMethodReader, pe, list, data, launcherClassName);
        } else {
            this.generateAddLaunchersWithProviderIterator(testMethodReader, pe, list, data, launcherClassName);
        }
    }

    private void generateAddLaunchersWithProviderArray(MethodReader testMethodReader, ProgramEmitter pe, ValueEmitter list, ValueEmitter data, String launcherClassName) {
        ValueEmitter size = data.arrayLength();
        BasicBlock loopHead = pe.getProgram().createBasicBlock();
        BasicBlock loopBody = pe.getProgram().createBasicBlock();
        BasicBlock loopExit = pe.getProgram().createBasicBlock();
        PhiEmitter index = pe.phi(Integer.TYPE, loopHead);
        pe.constant(0).propagateTo(index);
        pe.jump(loopHead);
        pe.enter(loopHead);
        pe.when(index.getValue().isLessThan(size)).thenDo(() -> pe.jump(loopBody)).elseDo(() -> pe.jump(loopExit));
        pe.enter(loopBody);
        ValueEmitter dataRow = data.getElement(index.getValue());
        this.generateAddLauncherWithData(testMethodReader, pe, list, dataRow, launcherClassName);
        index.getValue().add(1).propagateTo(index);
        pe.jump(loopHead);
        pe.enter(loopExit);
        pe.exit();
    }

    private void generateAddLaunchersWithProviderIterator(MethodReader testMethodReader, ProgramEmitter pe, ValueEmitter list, ValueEmitter data, String launcherClassName) {
        BasicBlock loopHead = pe.getProgram().createBasicBlock();
        BasicBlock loopBody = pe.getProgram().createBasicBlock();
        BasicBlock loopExit = pe.getProgram().createBasicBlock();
        pe.jump(loopHead);
        pe.enter(loopHead);
        pe.when(data.invokeVirtual("hasNext", Boolean.TYPE, new ValueEmitter[0]).isTrue()).thenDo(() -> pe.jump(loopBody)).elseDo(() -> pe.jump(loopExit));
        pe.enter(loopBody);
        ValueEmitter dataRow = data.invokeVirtual("next", Object.class, new ValueEmitter[0]).cast(Object[].class);
        this.generateAddLauncherWithData(testMethodReader, pe, list, dataRow, launcherClassName);
        pe.jump(loopHead);
        pe.enter(loopExit);
        pe.exit();
    }

    private void generateAddLauncherWithData(MethodReader testMethodReader, ProgramEmitter pe, ValueEmitter list, ValueEmitter dataRow, String launcherClassName) {
        ArrayList<ValueEmitter> arguments = new ArrayList<ValueEmitter>();
        for (int i = 0; i < testMethodReader.parameterCount(); ++i) {
            ValueType type = testMethodReader.parameterType(i);
            arguments.add(this.convertArgument(dataRow.getElement(i), type));
        }
        list.invokeVirtual("add", Boolean.TYPE, new ValueEmitter[]{pe.construct(launcherClassName, arguments.toArray(new ValueEmitter[0])).cast(Object.class)});
    }

    private ValueEmitter convertArgument(ValueEmitter value, ValueType type) {
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    return value.cast(Boolean.class).invokeVirtual("booleanValue", Boolean.TYPE, new ValueEmitter[0]);
                }
                case CHARACTER: {
                    return value.cast(Character.class).invokeVirtual("charValue", Character.TYPE, new ValueEmitter[0]);
                }
                case BYTE: {
                    return value.cast(Number.class).invokeVirtual("byteValue", Byte.TYPE, new ValueEmitter[0]);
                }
                case SHORT: {
                    return value.cast(Number.class).invokeVirtual("shortValue", Byte.TYPE, new ValueEmitter[0]);
                }
                case INTEGER: {
                    return value.cast(Number.class).invokeVirtual("intValue", Integer.TYPE, new ValueEmitter[0]);
                }
                case LONG: {
                    return value.cast(Number.class).invokeVirtual("longValue", Long.TYPE, new ValueEmitter[0]);
                }
                case FLOAT: {
                    return value.cast(Number.class).invokeVirtual("floatValue", Float.TYPE, new ValueEmitter[0]);
                }
                case DOUBLE: {
                    return value.cast(Number.class).invokeVirtual("doubleValue", Double.TYPE, new ValueEmitter[0]);
                }
            }
        }
        return value.cast(type);
    }

    private ClassHolder generateLauncherClass(MethodReference testMethod, ClassHierarchy hierarchy) {
        ClassHolder cls = new ClassHolder(TestEntryPoint.Launcher.class.getName() + "Impl" + this.suffixGenerator++);
        cls.setParent("java.lang.Object");
        cls.getInterfaces().add(TestEntryPoint.Launcher.class.getName());
        MethodHolder constructor = new MethodHolder("<init>", testMethod.getSignature());
        cls.addMethod(constructor);
        ProgramEmitter pe = ProgramEmitter.create((MethodHolder)constructor, (ClassHierarchy)hierarchy);
        pe.var(0, (ValueType)ValueType.object((String)cls.getName())).invokeSpecial(Object.class, "<init>", new ValueEmitter[0]);
        ValueEmitter self = pe.var(0, (ValueType)ValueType.object((String)cls.getName()));
        for (int i = 0; i < testMethod.parameterCount(); ++i) {
            FieldHolder paramField = new FieldHolder("param_" + i);
            paramField.setType(testMethod.parameterType(i));
            cls.addField(paramField);
            self.setField(paramField.getName(), pe.var(i + 1, testMethod.parameterType(i)));
        }
        pe.exit();
        MethodHolder launchMethod = new MethodHolder("launch", new ValueType[]{ValueType.parse(Object.class), ValueType.VOID});
        cls.addMethod(launchMethod);
        pe = ProgramEmitter.create((MethodHolder)launchMethod, (ClassHierarchy)hierarchy);
        ArrayList<ValueEmitter> arguments = new ArrayList<ValueEmitter>();
        self = pe.var(0, (ValueType)ValueType.object((String)cls.getName()));
        for (int i = 0; i < testMethod.parameterCount(); ++i) {
            arguments.add(self.getField("param_" + i, testMethod.parameterType(i)));
        }
        this.generateRunMethodOnce(testMethod, hierarchy, pe, pe.var(1, Object.class), arguments);
        pe.exit();
        return cls;
    }

    private void generateRunMethodOnce(MethodReference testMethod, ClassHierarchy hierarchy, ProgramEmitter pe, ValueEmitter testCase, List<ValueEmitter> arguments) {
        testCase.cast((ValueType)ValueType.object((String)testMethod.getClassName())).invokeSpecial(testMethod, arguments.toArray(new ValueEmitter[0]));
        MethodReader testMethodReader = hierarchy.getClassSource().resolve(testMethod);
        String[] expectedExceptions = TeaVMTestRunner.getExpectedExceptions(testMethodReader);
        if (expectedExceptions.length != 0) {
            BasicBlock handler = pe.getProgram().createBasicBlock();
            for (String exceptionType : expectedExceptions) {
                TryCatchBlock tryCatch = new TryCatchBlock();
                tryCatch.setExceptionType(exceptionType);
                tryCatch.setHandler(handler);
                pe.getBlock().getTryCatchBlocks().add(tryCatch);
            }
            BasicBlock nextBlock = pe.getProgram().createBasicBlock();
            pe.jump(nextBlock);
            pe.enter(nextBlock);
            pe.construct(AssertionError.class, new ValueEmitter[]{pe.constant("Expected exception not thrown")}).raise();
            pe.enter(handler);
        }
    }
}

