/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.junit;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import junit.framework.TestCase;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;
import org.teavm.apachecommons.io.IOUtils;
import org.teavm.backend.c.CTarget;
import org.teavm.backend.c.generate.CNameProvider;
import org.teavm.backend.javascript.JavaScriptTarget;
import org.teavm.backend.lowlevel.generate.NameProvider;
import org.teavm.backend.wasm.WasmRuntimeType;
import org.teavm.backend.wasm.WasmTarget;
import org.teavm.callgraph.CallGraph;
import org.teavm.debugging.information.DebugInformation;
import org.teavm.debugging.information.DebugInformationBuilder;
import org.teavm.debugging.information.DebugInformationEmitter;
import org.teavm.dependency.DependencyAnalyzerFactory;
import org.teavm.dependency.FastDependencyAnalyzer;
import org.teavm.dependency.PreciseDependencyAnalyzer;
import org.teavm.diagnostics.DefaultProblemTextConsumer;
import org.teavm.diagnostics.Problem;
import org.teavm.diagnostics.ProblemTextConsumer;
import org.teavm.junit.BrowserRunStrategy;
import org.teavm.junit.CRunStrategy;
import org.teavm.junit.HtmlUnitRunStrategy;
import org.teavm.junit.RunKind;
import org.teavm.junit.SkipJVM;
import org.teavm.junit.TeaVMProperties;
import org.teavm.junit.TeaVMProperty;
import org.teavm.junit.TeaVMTestConfiguration;
import org.teavm.junit.TestEntryPointTransformerForSingleMethod;
import org.teavm.junit.TestEntryPointTransformerForWholeClass;
import org.teavm.junit.TestExceptionPlugin;
import org.teavm.junit.TestJsEntryPoint;
import org.teavm.junit.TestNativeEntryPoint;
import org.teavm.junit.TestRun;
import org.teavm.junit.TestRunCallback;
import org.teavm.junit.TestRunStrategy;
import org.teavm.junit.TestRunner;
import org.teavm.junit.WasiRunStrategy;
import org.teavm.junit.WholeClassCompilation;
import org.teavm.model.AnnotationHolder;
import org.teavm.model.AnnotationReader;
import org.teavm.model.AnnotationValue;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderSource;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.PreOptimizingClassHolderSource;
import org.teavm.model.ReferenceCache;
import org.teavm.model.ValueType;
import org.teavm.parsing.ClasspathClassHolderSource;
import org.teavm.tooling.TeaVMProblemRenderer;
import org.teavm.vm.BuildTarget;
import org.teavm.vm.DirectoryBuildTarget;
import org.teavm.vm.TeaVM;
import org.teavm.vm.TeaVMBuilder;
import org.teavm.vm.TeaVMOptimizationLevel;
import org.teavm.vm.TeaVMTarget;
import org.teavm.vm.spi.TeaVMHost;

public class TeaVMTestRunner
extends org.junit.runner.Runner
implements Filterable {
    static final String JUNIT3_BASE_CLASS = "junit.framework.TestCase";
    static final MethodReference JUNIT3_BEFORE = new MethodReference("junit.framework.TestCase", "setUp", new ValueType[]{ValueType.VOID});
    static final MethodReference JUNIT3_AFTER = new MethodReference("junit.framework.TestCase", "tearDown", new ValueType[]{ValueType.VOID});
    static final String JUNIT4_TEST = "org.junit.Test";
    static final String JUNIT4_IGNORE = "org.junit.Ignore";
    static final String TESTNG_TEST = "org.testng.annotations.Test";
    static final String TESTNG_IGNORE = "org.testng.annotations.Ignore";
    static final String JUNIT4_BEFORE = "org.junit.Before";
    static final String TESTNG_BEFORE = "org.testng.annotations.BeforeMethod";
    static final String JUNIT4_AFTER = "org.junit.After";
    static final String TESTNG_AFTER = "org.testng.annotations.AfterMethod";
    static final String TESTNG_PROVIDER = "org.testng.annotations.DataProvider";
    private static final String PATH_PARAM = "teavm.junit.target";
    private static final String JS_RUNNER = "teavm.junit.js.runner";
    private static final String WASM_RUNNER = "teavm.junit.wasm.runner";
    private static final String THREAD_COUNT = "teavm.junit.threads";
    private static final String JS_ENABLED = "teavm.junit.js";
    static final String JS_DECODE_STACK = "teavm.junit.js.decodeStack";
    private static final String C_ENABLED = "teavm.junit.c";
    private static final String WASM_ENABLED = "teavm.junit.wasm";
    private static final String WASI_ENABLED = "teavm.junit.wasi";
    private static final String WASI_RUNNER = "teavm.junit.wasi.runner";
    private static final String C_COMPILER = "teavm.junit.c.compiler";
    private static final String C_LINE_NUMBERS = "teavm.junit.c.lineNumbers";
    private static final String MINIFIED = "teavm.junit.minified";
    private static final String OPTIMIZED = "teavm.junit.optimized";
    private static final String FAST_ANALYSIS = "teavm.junit.fastAnalysis";
    private static final int stopTimeout = 15000;
    private Class<?> testClass;
    private boolean isWholeClassCompilation;
    private ClassHolderSource classSource;
    private ClassLoader classLoader;
    private Description suiteDescription;
    private static Map<ClassLoader, ClassHolderSource> classSources = new WeakHashMap<ClassLoader, ClassHolderSource>();
    private File outputDir;
    private Map<Method, Description> descriptions = new HashMap<Method, Description>();
    private static Map<RunKind, RunnerKindInfo> runners = new HashMap<RunKind, RunnerKindInfo>();
    private static ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
    private CountDownLatch latch;
    private List<Method> filteredChildren;
    private ReferenceCache referenceCache = new ReferenceCache();
    private boolean classCompilationOk;
    private List<TestRun> runsInCurrentClass = new ArrayList<TestRun>();

    public TeaVMTestRunner(Class<?> testClass) throws InitializationError {
        String wasiCommand;
        String cCommand;
        String runStrategyName;
        this.testClass = testClass;
        this.classLoader = TeaVMTestRunner.class.getClassLoader();
        this.classSource = this.getClassSource(this.classLoader);
        String outputPath = System.getProperty(PATH_PARAM);
        if (outputPath != null) {
            this.outputDir = new File(outputPath);
        }
        if ((runStrategyName = System.getProperty(JS_RUNNER)) != null) {
            TestRunStrategy jsRunStrategy;
            switch (runStrategyName) {
                case "htmlunit": {
                    jsRunStrategy = new HtmlUnitRunStrategy();
                    break;
                }
                case "browser": {
                    jsRunStrategy = new BrowserRunStrategy(this.outputDir, "JAVASCRIPT", this::customBrowser);
                    break;
                }
                case "browser-chrome": {
                    jsRunStrategy = new BrowserRunStrategy(this.outputDir, "JAVASCRIPT", this::chromeBrowser);
                    break;
                }
                case "browser-firefox": {
                    jsRunStrategy = new BrowserRunStrategy(this.outputDir, "JAVASCRIPT", this::firefoxBrowser);
                    break;
                }
                case "none": {
                    jsRunStrategy = null;
                    break;
                }
                default: {
                    throw new InitializationError("Unknown run strategy: " + runStrategyName);
                }
            }
            TeaVMTestRunner.runners.get((Object)((Object)RunKind.JAVASCRIPT)).strategy = jsRunStrategy;
        }
        if ((cCommand = System.getProperty(C_COMPILER)) != null) {
            TeaVMTestRunner.runners.get((Object)((Object)RunKind.C)).strategy = new CRunStrategy(cCommand);
        }
        if ((wasiCommand = System.getProperty(WASI_RUNNER)) != null) {
            TeaVMTestRunner.runners.get((Object)((Object)RunKind.WASI)).strategy = new WasiRunStrategy(wasiCommand);
        }
        if ((runStrategyName = System.getProperty(WASM_RUNNER)) != null) {
            BrowserRunStrategy wasmRunStrategy;
            switch (runStrategyName) {
                case "browser": {
                    wasmRunStrategy = new BrowserRunStrategy(this.outputDir, "WASM", this::customBrowser);
                    break;
                }
                case "chrome": 
                case "browser-chrome": {
                    wasmRunStrategy = new BrowserRunStrategy(this.outputDir, "WASM", this::chromeBrowser);
                    break;
                }
                case "browser-firefox": {
                    wasmRunStrategy = new BrowserRunStrategy(this.outputDir, "WASM", this::firefoxBrowser);
                    break;
                }
                default: {
                    throw new InitializationError("Unknown run strategy: " + runStrategyName);
                }
            }
            TeaVMTestRunner.runners.get((Object)((Object)RunKind.WASM)).strategy = wasmRunStrategy;
        }
    }

    private Process customBrowser(String url) {
        System.out.println("Open link to run tests: " + url + "?logging=true");
        return null;
    }

    private Process chromeBrowser(String url) {
        return this.browserTemplate("chrome", url, (profile, params) -> params.addAll(Arrays.asList("google-chrome-stable", "--headless", "--disable-gpu", "--remote-debugging-port=9222", "--no-first-run", "--user-data-dir=" + profile)));
    }

    private Process firefoxBrowser(String url) {
        return this.browserTemplate("firefox", url, (profile, params) -> params.addAll(Arrays.asList("firefox", "--headless", "--profile", profile)));
    }

    private Process browserTemplate(String name, String url, BiConsumer<String, List<String>> paramsBuilder) {
        try {
            File temp = File.createTempFile("teavm", "teavm");
            temp.delete();
            temp.mkdirs();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.deleteDir(temp)));
            System.out.println("Running " + name + " with user data dir: " + temp.getAbsolutePath());
            ArrayList<String> params = new ArrayList<String>();
            paramsBuilder.accept(temp.getAbsolutePath(), params);
            int tabs = Integer.parseInt(System.getProperty(THREAD_COUNT, "1"));
            for (int i = 0; i < tabs; ++i) {
                params.add(url);
            }
            ProcessBuilder pb = new ProcessBuilder(params.toArray(new String[0]));
            Process process = pb.start();
            this.logStream(process.getInputStream(), name + " stdout");
            this.logStream(process.getErrorStream(), name + " stderr");
            new Thread(() -> {
                try {
                    System.out.println(name + " process terminated with code: " + process.waitFor());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
            return process;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void logStream(InputStream stream, String name) {
        new Thread(() -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                String line;
                while ((line = reader.readLine()) != null) {
                    System.out.println(name + ": " + line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }).start();
    }

    private void deleteDir(File dir) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                this.deleteDir(file);
                continue;
            }
            file.delete();
        }
        dir.delete();
    }

    public Description getDescription() {
        if (this.suiteDescription == null) {
            this.suiteDescription = Description.createSuiteDescription(this.testClass);
            for (Method child : this.getFilteredChildren()) {
                this.suiteDescription.addChild(this.describeChild(child));
            }
        }
        return this.suiteDescription;
    }

    public void run(RunNotifier notifier) {
        List<Method> children = this.getFilteredChildren();
        this.latch = new CountDownLatch(children.size());
        notifier.fireTestStarted(this.getDescription());
        this.isWholeClassCompilation = this.testClass.isAnnotationPresent(WholeClassCompilation.class);
        if (this.isWholeClassCompilation) {
            this.classCompilationOk = this.compileWholeClass(children, notifier);
        }
        for (Method child : children) {
            this.runChild(child, notifier);
        }
        this.writeRunsDescriptor();
        this.runsInCurrentClass.clear();
        try {
            while (!this.latch.await(1000L, TimeUnit.MILLISECONDS)) {
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        notifier.fireTestFinished(this.getDescription());
    }

    private List<Method> getChildren() {
        ArrayList<Method> children = new ArrayList<Method>();
        HashSet<String> foundMethods = new HashSet<String>();
        for (Class<?> cls = this.testClass; cls != Object.class && !cls.getName().equals(JUNIT3_BASE_CLASS); cls = cls.getSuperclass()) {
            for (Method method : cls.getDeclaredMethods()) {
                if (!foundMethods.add(method.getName()) || !this.isTestMethod(method)) continue;
                children.add(method);
            }
        }
        return children;
    }

    private boolean isTestMethod(Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            return false;
        }
        if (TestCase.class.isAssignableFrom(method.getDeclaringClass())) {
            return method.getName().startsWith("test") && method.getName().length() > 4 && Character.isUpperCase(method.getName().charAt(4));
        }
        if (this.getClassAnnotation(method, TESTNG_TEST) != null) {
            return method.getName().startsWith("test_");
        }
        return this.getAnnotation(method, JUNIT4_TEST) != null || this.getAnnotation(method, TESTNG_TEST) != null;
    }

    private List<Method> getFilteredChildren() {
        if (this.filteredChildren == null) {
            this.filteredChildren = this.getChildren();
        }
        return this.filteredChildren;
    }

    private Description describeChild(Method child) {
        return this.descriptions.computeIfAbsent(child, method -> Description.createTestDescription(this.testClass, (String)method.getName()));
    }

    private boolean compileWholeClass(List<Method> children, RunNotifier notifier) {
        CompileResult result;
        File outputPath = this.getOutputPathForClass();
        boolean hasErrors = false;
        Description description = this.getDescription();
        for (TeaVMTestConfiguration<JavaScriptTarget> teaVMTestConfiguration : this.getJavaScriptConfigurations()) {
            result = this.compileToJs(this.wholeClass(children), "classTest", teaVMTestConfiguration, outputPath);
            if (result.success) continue;
            hasErrors = true;
            notifier.fireTestFailure(this.createFailure(description, result));
        }
        for (TeaVMTestConfiguration<JavaScriptTarget> teaVMTestConfiguration : this.getCConfigurations()) {
            result = this.compileToC(this.wholeClass(children), "classTest", teaVMTestConfiguration, outputPath);
            if (result.success) continue;
            hasErrors = true;
            notifier.fireTestFailure(this.createFailure(description, result));
        }
        for (TeaVMTestConfiguration<JavaScriptTarget> teaVMTestConfiguration : this.getWasmConfigurations()) {
            result = this.compileToWasm(WasmRuntimeType.TEAVM, this.wholeClass(children), "classTest", teaVMTestConfiguration, outputPath);
            if (result.success) continue;
            hasErrors = true;
            notifier.fireTestFailure(this.createFailure(description, result));
        }
        for (TeaVMTestConfiguration<JavaScriptTarget> teaVMTestConfiguration : this.getWasiConfigurations()) {
            result = this.compileToWasm(WasmRuntimeType.WASI, this.wholeClass(children), "classTest", teaVMTestConfiguration, outputPath);
            if (result.success) continue;
            hasErrors = true;
            notifier.fireTestFailure(this.createFailure(description, result));
        }
        return !hasErrors;
    }

    private void runChild(Method child, RunNotifier notifier) {
        Description description = this.describeChild(child);
        notifier.fireTestStarted(description);
        if (this.isIgnored(child)) {
            notifier.fireTestIgnored(description);
            this.latch.countDown();
            return;
        }
        boolean ran = false;
        boolean success = true;
        if (!child.isAnnotationPresent(SkipJVM.class) && !this.testClass.isAnnotationPresent(SkipJVM.class)) {
            ran = true;
            ClassHolder classHolder = this.classSource.get(child.getDeclaringClass().getName());
            MethodHolder methodHolder = classHolder.getMethod(this.getDescriptor(child));
            success = this.runInJvm(child, notifier, TeaVMTestRunner.getExpectedExceptions((MethodReader)methodHolder));
        }
        if (success && this.outputDir != null) {
            int[] configurationIndex = new int[]{0};
            ArrayList<TestRun> runs = new ArrayList<TestRun>();
            Consumer<Boolean> onSuccess = runSuccess -> {
                if (runSuccess.booleanValue() && configurationIndex[0] < runs.size()) {
                    int n = configurationIndex[0];
                    configurationIndex[0] = n + 1;
                    this.submitRun((TestRun)runs.get(n));
                } else {
                    notifier.fireTestFinished(description);
                    this.latch.countDown();
                }
            };
            if (this.isWholeClassCompilation) {
                if (!this.classCompilationOk) {
                    notifier.fireTestFinished(description);
                    notifier.fireTestFailure(new Failure(description, (Throwable)((Object)new AssertionError((Object)"Could not compile test class"))));
                    this.latch.countDown();
                } else {
                    this.runTestsFromWholeClass(child, notifier, runs, onSuccess);
                    onSuccess.accept(true);
                }
            } else {
                this.runCompiledTest(child, notifier, runs, onSuccess);
            }
        } else {
            if (!ran) {
                notifier.fireTestIgnored(description);
            }
            notifier.fireTestFinished(description);
            this.latch.countDown();
        }
    }

    private void runTestsFromWholeClass(Method child, RunNotifier notifier, List<TestRun> runs, Consumer<Boolean> onSuccess) {
        File htmlPath;
        File testPath;
        File outputPath = this.getOutputPathForClass();
        File outputPathForMethod = this.getOutputPath(child);
        MethodDescriptor descriptor = this.getDescriptor(child);
        MethodReference reference = new MethodReference(child.getDeclaringClass().getName(), descriptor);
        File testFilePath = this.getOutputPath(child);
        testFilePath.mkdirs();
        HashMap<String, String> properties = new HashMap<String, String>();
        for (TeaVMTestConfiguration<JavaScriptTarget> teaVMTestConfiguration : this.getJavaScriptConfigurations()) {
            testPath = this.getOutputFile(outputPath, "classTest", teaVMTestConfiguration.getSuffix(), false, ".js");
            runs.add(this.createTestRun(teaVMTestConfiguration, testPath, child, RunKind.JAVASCRIPT, reference.toString(), notifier, onSuccess));
            htmlPath = this.getOutputFile(outputPathForMethod, "test", teaVMTestConfiguration.getSuffix(), false, ".html");
            properties.put("SCRIPT", "../" + testPath.getName());
            properties.put("IDENTIFIER", reference.toString());
            try {
                this.resourceToFile("teavm-run-test.html", htmlPath, properties);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        for (TeaVMTestConfiguration<JavaScriptTarget> teaVMTestConfiguration : this.getWasmConfigurations()) {
            testPath = this.getOutputFile(outputPath, "classTest", teaVMTestConfiguration.getSuffix(), false, ".wasm");
            runs.add(this.createTestRun(teaVMTestConfiguration, testPath, child, RunKind.WASM, reference.toString(), notifier, onSuccess));
            htmlPath = this.getOutputFile(outputPathForMethod, "test-wasm", teaVMTestConfiguration.getSuffix(), false, ".html");
            properties.put("SCRIPT", "../" + testPath.getName());
            properties.put("IDENTIFIER", reference.toString());
            try {
                this.resourceToFile("teavm-run-test-wasm.html", htmlPath, properties);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        for (TeaVMTestConfiguration<JavaScriptTarget> teaVMTestConfiguration : this.getWasiConfigurations()) {
            testPath = this.getOutputFile(outputPath, "classTest", teaVMTestConfiguration.getSuffix(), false, ".wasm");
            runs.add(this.createTestRun(teaVMTestConfiguration, testPath, child, RunKind.WASI, reference.toString(), notifier, onSuccess));
            htmlPath = this.getOutputFile(outputPathForMethod, "test-wasm", teaVMTestConfiguration.getSuffix(), false, ".html");
            properties.put("SCRIPT", "../" + testPath.getName());
            properties.put("IDENTIFIER", reference.toString());
        }
        for (TeaVMTestConfiguration<JavaScriptTarget> teaVMTestConfiguration : this.getCConfigurations()) {
            testPath = this.getOutputFile(outputPath, "classTest", teaVMTestConfiguration.getSuffix(), true, ".c");
            runs.add(this.createTestRun(teaVMTestConfiguration, testPath, child, RunKind.C, reference.toString(), notifier, onSuccess));
        }
    }

    private void runCompiledTest(Method child, RunNotifier notifier, List<TestRun> runs, Consumer<Boolean> onSuccess) {
        try {
            File htmlPath;
            File testPath;
            TestRun run;
            CompileResult compileResult;
            File outputPath = this.getOutputPath(child);
            HashMap<String, String> properties = new HashMap<String, String>();
            for (TeaVMTestConfiguration<JavaScriptTarget> teaVMTestConfiguration : this.getJavaScriptConfigurations()) {
                run = this.prepareRun(teaVMTestConfiguration, child, compileResult = this.compileToJs(this.singleTest(child), "test", teaVMTestConfiguration, outputPath), notifier, RunKind.JAVASCRIPT, onSuccess);
                if (run == null) continue;
                runs.add(run);
                testPath = this.getOutputFile(outputPath, "test", teaVMTestConfiguration.getSuffix(), false, ".js");
                htmlPath = this.getOutputFile(outputPath, "test", teaVMTestConfiguration.getSuffix(), false, ".html");
                properties.put("SCRIPT", testPath.getName());
                properties.put("IDENTIFIER", "");
                try {
                    this.resourceToFile("teavm-run-test.html", htmlPath, properties);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            for (TeaVMTestConfiguration<JavaScriptTarget> teaVMTestConfiguration : this.getCConfigurations()) {
                run = this.prepareRun(teaVMTestConfiguration, child, compileResult = this.compileToC(this.singleTest(child), "test", teaVMTestConfiguration, outputPath), notifier, RunKind.C, onSuccess);
                if (run == null) continue;
                runs.add(run);
            }
            for (TeaVMTestConfiguration<JavaScriptTarget> teaVMTestConfiguration : this.getWasmConfigurations()) {
                run = this.prepareRun(teaVMTestConfiguration, child, compileResult = this.compileToWasm(WasmRuntimeType.TEAVM, this.singleTest(child), "test", teaVMTestConfiguration, outputPath), notifier, RunKind.WASM, onSuccess);
                if (run == null) continue;
                runs.add(run);
                testPath = this.getOutputFile(outputPath, "test", teaVMTestConfiguration.getSuffix(), false, ".wasm");
                htmlPath = this.getOutputFile(outputPath, "test", teaVMTestConfiguration.getSuffix(), false, ".html");
                properties.put("SCRIPT", testPath.getName());
                properties.put("IDENTIFIER", "");
                try {
                    this.resourceToFile("teavm-run-test-wasm.html", htmlPath, properties);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            for (TeaVMTestConfiguration<JavaScriptTarget> teaVMTestConfiguration : this.getWasiConfigurations()) {
                run = this.prepareRun(teaVMTestConfiguration, child, compileResult = this.compileToWasm(WasmRuntimeType.WASI, this.singleTest(child), "test", teaVMTestConfiguration, outputPath), notifier, RunKind.WASI, onSuccess);
                if (run == null) continue;
                runs.add(run);
                testPath = this.getOutputFile(outputPath, "test", teaVMTestConfiguration.getSuffix(), false, ".wasm");
                properties.put("SCRIPT", testPath.getName());
                properties.put("IDENTIFIER", "");
            }
        }
        catch (Throwable e) {
            notifier.fireTestFailure(new Failure(this.describeChild(child), e));
            notifier.fireTestFinished(this.describeChild(child));
            this.latch.countDown();
            return;
        }
        onSuccess.accept(true);
    }

    static String[] getExpectedExceptions(MethodReader method) {
        AnnotationReader annot = method.getAnnotations().get(JUNIT4_TEST);
        if (annot != null) {
            AnnotationValue expected = annot.getValue("expected");
            if (expected == null) {
                return new String[0];
            }
            ValueType result = expected.getJavaClass();
            return new String[]{((ValueType.Object)result).getClassName()};
        }
        annot = method.getAnnotations().get(TESTNG_TEST);
        if (annot != null) {
            AnnotationValue expected = annot.getValue("expectedExceptions");
            if (expected == null) {
                return new String[0];
            }
            List list = expected.getList();
            String[] result = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                result[i] = ((ValueType.Object)((AnnotationValue)list.get(i)).getJavaClass()).getClassName();
            }
            return result;
        }
        return new String[0];
    }

    private boolean runInJvm(Method testMethod, RunNotifier notifier, String[] expectedExceptions) {
        Runner runner;
        Object instance;
        Description description = this.describeChild(testMethod);
        try {
            instance = this.testClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            notifier.fireTestFailure(new Failure(description, (Throwable)e));
            return false;
        }
        catch (InvocationTargetException e) {
            notifier.fireTestFailure(new Failure(description, e.getTargetException()));
            return false;
        }
        try {
            runner = this.prepareJvmRunner(instance, testMethod, expectedExceptions);
        }
        catch (Throwable e) {
            notifier.fireTestFailure(new Failure(description, e));
            return false;
        }
        try {
            runner.run(new Object[0]);
            return true;
        }
        catch (Throwable e) {
            notifier.fireTestFailure(new Failure(description, e));
            return false;
        }
    }

    private Runner prepareJvmRunner(Object instance, Method testMethod, String[] expectedExceptions) throws Throwable {
        Runner runner = TestCase.class.isAssignableFrom(this.testClass) ? new JUnit3Runner((TestCase)instance, testMethod) : new SimpleMethodRunner(instance, testMethod);
        if (expectedExceptions.length > 0) {
            runner = new WithExpectedExceptionRunner(runner, expectedExceptions);
        }
        runner = this.wrapWithBeforeAndAfter(runner, instance);
        runner = this.wrapWithDataProvider(runner, instance, testMethod);
        return runner;
    }

    private Runner wrapWithBeforeAndAfter(Runner runner, Object instance) {
        ArrayList classes = new ArrayList();
        for (Class<?> cls = instance.getClass(); cls != null; cls = cls.getSuperclass()) {
            classes.add(cls);
        }
        ArrayList<Method> afterMethods = new ArrayList<Method>();
        for (Class clazz : classes) {
            for (Method method : clazz.getMethods()) {
                if (this.getAnnotation(method, JUNIT4_AFTER) == null && this.getAnnotation(method, TESTNG_AFTER) == null) continue;
                afterMethods.add(method);
            }
        }
        ArrayList<Method> beforeMethods = new ArrayList<Method>();
        Collections.reverse(classes);
        for (Class clazz : classes) {
            for (Method method : clazz.getMethods()) {
                if (this.getAnnotation(method, JUNIT4_BEFORE) == null && this.getAnnotation(method, TESTNG_BEFORE) == null) continue;
                beforeMethods.add(method);
            }
        }
        if (beforeMethods.isEmpty() && afterMethods.isEmpty()) {
            return runner;
        }
        return new WithBeforeAndAfterRunner(runner, instance, beforeMethods.toArray(new Method[0]), afterMethods.toArray(new Method[0]));
    }

    private Runner wrapWithDataProvider(Runner runner, Object instance, Method testMethod) throws Throwable {
        Object data;
        AnnotationHolder annot = this.getAnnotation(testMethod, TESTNG_TEST);
        if (annot == null) {
            return runner;
        }
        AnnotationValue dataProviderValue = annot.getValue("dataProvider");
        if (dataProviderValue == null) {
            return runner;
        }
        String providerName = dataProviderValue.getString();
        if (providerName.isEmpty()) {
            return runner;
        }
        Method provider = null;
        for (Method method : testMethod.getDeclaringClass().getDeclaredMethods()) {
            AnnotationHolder providerAnnot = this.getAnnotation(method, TESTNG_PROVIDER);
            if (providerAnnot == null || !providerAnnot.getValue("name").getString().equals(providerName)) continue;
            provider = method;
            break;
        }
        try {
            provider.setAccessible(true);
            data = provider.invoke(instance, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        return new WithDataProviderRunner(runner, data, testMethod.getParameterTypes());
    }

    private TestRun prepareRun(TeaVMTestConfiguration<?> configuration, Method child, CompileResult result, RunNotifier notifier, RunKind kind, Consumer<Boolean> onComplete) {
        Description description = this.describeChild(child);
        if (!result.success) {
            notifier.fireTestFailure(this.createFailure(description, result));
            notifier.fireTestFinished(description);
            this.latch.countDown();
            return null;
        }
        return this.createTestRun(configuration, result.file, child, kind, null, notifier, onComplete);
    }

    private TestRun createTestRun(TeaVMTestConfiguration<?> configuration, File file, Method child, RunKind kind, String argument, final RunNotifier notifier, final Consumer<Boolean> onComplete) {
        final Description description = this.describeChild(child);
        TestRunCallback callback = new TestRunCallback(){

            @Override
            public void complete() {
                onComplete.accept(true);
            }

            @Override
            public void error(Throwable e) {
                notifier.fireTestFailure(new Failure(description, e));
                onComplete.accept(false);
            }
        };
        return new TestRun(this.generateName(child.getName(), configuration), file.getParentFile(), child, description, file.getName(), kind, argument, callback);
    }

    private String generateName(String baseName, TeaVMTestConfiguration<?> configuration) {
        String suffix = configuration.getSuffix();
        if (!suffix.isEmpty()) {
            baseName = (String)baseName + " (" + suffix + ")";
        }
        return baseName;
    }

    private Failure createFailure(Description description, CompileResult result) {
        Object throwable = result.throwable;
        if (throwable == null) {
            throwable = new AssertionError((Object)result.errorMessage);
        }
        return new Failure(description, (Throwable)throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitRun(TestRun run) {
        Class<TeaVMTestRunner> clazz = TeaVMTestRunner.class;
        synchronized (TeaVMTestRunner.class) {
            this.runsInCurrentClass.add(run);
            RunnerKindInfo info = runners.get((Object)run.getKind());
            if (info.strategy == null) {
                run.getCallback().complete();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (info.runner == null) {
                info.runner = new TestRunner(info.strategy);
                try {
                    info.runner.setNumThreads(Integer.parseInt(System.getProperty(THREAD_COUNT, "1")));
                }
                catch (NumberFormatException e) {
                    info.runner.setNumThreads(1);
                }
                info.runner.init();
            }
            info.runner.run(run);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanupRunner(RunKind kind) {
        Class<TeaVMTestRunner> clazz = TeaVMTestRunner.class;
        synchronized (TeaVMTestRunner.class) {
            RunnerKindInfo info = runners.get((Object)kind);
            info.runner.stop();
            info.runner = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private File getOutputPath(Method method) {
        File path = this.outputDir;
        path = new File(path, this.testClass.getName().replace('.', '/'));
        path = new File(path, method.getName());
        path.mkdirs();
        return path;
    }

    private File getOutputPathForClass() {
        File path = this.outputDir;
        path = new File(path, this.testClass.getName().replace('.', '/'));
        path.mkdirs();
        return path;
    }

    private CompileResult compileToJs(Consumer<TeaVM> additionalProcessing, String baseName, TeaVMTestConfiguration<JavaScriptTarget> configuration, File path) {
        boolean decodeStack = Boolean.parseBoolean(System.getProperty(JS_DECODE_STACK, "true"));
        DebugInformationBuilder debugEmitter = new DebugInformationBuilder(new ReferenceCache());
        Supplier<JavaScriptTarget> targetSupplier = () -> {
            JavaScriptTarget target = new JavaScriptTarget();
            target.setStrict(true);
            if (decodeStack) {
                target.setDebugEmitter((DebugInformationEmitter)debugEmitter);
                target.setStackTraceIncluded(true);
            }
            return target;
        };
        CompilePostProcessor postBuild = null;
        if (decodeStack) {
            postBuild = (vm, file) -> {
                DebugInformation debugInfo = debugEmitter.getDebugInformation();
                File sourceMapsFile = new File(file.getPath() + ".map");
                File debugFile = new File(file.getPath() + ".teavmdbg");
                try {
                    try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), StandardCharsets.UTF_8);){
                        writer.write("\n//# sourceMappingURL=");
                        writer.write(sourceMapsFile.getName());
                    }
                    try (OutputStreamWriter sourceMapsOut = new OutputStreamWriter((OutputStream)new FileOutputStream(sourceMapsFile), StandardCharsets.UTF_8);){
                        debugInfo.writeAsSourceMaps((Writer)sourceMapsOut, "", file.getPath());
                    }
                    try (FileOutputStream out = new FileOutputStream(debugFile);){
                        debugInfo.write((OutputStream)out);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            };
        }
        return this.compile(configuration, targetSupplier, TestJsEntryPoint.class.getName(), path, ".js", postBuild, false, additionalProcessing, baseName);
    }

    private CompileResult compileToC(Consumer<TeaVM> additionalProcessing, String baseName, TeaVMTestConfiguration<CTarget> configuration, File path) {
        CompilePostProcessor postBuild = (vm, file) -> {
            try {
                this.resourceToFile("teavm-CMakeLists.txt", new File(file.getParent(), "CMakeLists.txt"), Collections.emptyMap());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        return this.compile(configuration, this::createCTarget, TestNativeEntryPoint.class.getName(), path, ".c", postBuild, true, additionalProcessing, baseName);
    }

    private CTarget createCTarget() {
        CTarget cTarget = new CTarget((NameProvider)new CNameProvider());
        cTarget.setLineNumbersGenerated(Boolean.parseBoolean(System.getProperty(C_LINE_NUMBERS, "false")));
        return cTarget;
    }

    private CompileResult compileToWasm(WasmRuntimeType runtimeType, Consumer<TeaVM> additionalProcessing, String baseName, TeaVMTestConfiguration<WasmTarget> configuration, File path) {
        Supplier<WasmTarget> targetSupplier = () -> {
            WasmTarget target = new WasmTarget();
            target.setRuntimeType(runtimeType);
            return target;
        };
        return this.compile(configuration, targetSupplier, TestNativeEntryPoint.class.getName(), path, ".wasm", null, false, additionalProcessing, baseName);
    }

    private Consumer<TeaVM> singleTest(Method method) {
        ClassHolder classHolder = this.classSource.get(method.getDeclaringClass().getName());
        MethodHolder methodHolder = classHolder.getMethod(this.getDescriptor(method));
        return vm -> {
            Properties properties = new Properties();
            this.applyProperties(method.getDeclaringClass(), properties);
            vm.setProperties(properties);
            new TestEntryPointTransformerForSingleMethod(methodHolder.getReference(), this.testClass.getName()).install((TeaVMHost)vm);
        };
    }

    private Consumer<TeaVM> wholeClass(List<Method> methods) {
        return vm -> {
            Properties properties = new Properties();
            this.applyProperties(this.testClass, properties);
            vm.setProperties(properties);
            ArrayList<MethodReference> methodReferences = new ArrayList<MethodReference>();
            for (Method method : methods) {
                if (this.isIgnored(method)) continue;
                ClassHolder classHolder = this.classSource.get(method.getDeclaringClass().getName());
                MethodHolder methodHolder = classHolder.getMethod(this.getDescriptor(method));
                methodReferences.add(methodHolder.getReference());
            }
            new TestEntryPointTransformerForWholeClass(methodReferences, this.testClass.getName()).install((TeaVMHost)vm);
        };
    }

    private boolean isIgnored(Method method) {
        return this.getAnnotation(method, JUNIT4_IGNORE) != null || this.getAnnotation(method, TESTNG_IGNORE) != null || this.getClassAnnotation(method, JUNIT4_IGNORE) != null || this.getClassAnnotation(method, TESTNG_IGNORE) != null;
    }

    private AnnotationHolder getAnnotation(Method method, String name) {
        ClassHolder cls = this.classSource.get(method.getDeclaringClass().getName());
        if (cls == null) {
            return null;
        }
        MethodDescriptor descriptor = this.getDescriptor(method);
        MethodHolder methodHolder = cls.getMethod(descriptor);
        if (methodHolder == null) {
            return null;
        }
        return methodHolder.getAnnotations().get(name);
    }

    private AnnotationHolder getClassAnnotation(Method method, String name) {
        ClassHolder cls = this.classSource.get(method.getDeclaringClass().getName());
        if (cls == null) {
            return null;
        }
        return cls.getAnnotations().get(name);
    }

    private <T extends TeaVMTarget> CompileResult compile(TeaVMTestConfiguration<T> configuration, Supplier<T> targetSupplier, String entryPoint, File path, String extension, CompilePostProcessor postBuild, boolean separateDir, Consumer<TeaVM> additionalProcessing, String baseName) {
        File outputFile;
        CompileResult result = new CompileResult();
        result.file = outputFile = this.getOutputFile(path, baseName, configuration.getSuffix(), separateDir, extension);
        ClassLoader classLoader = TeaVMTestRunner.class.getClassLoader();
        TeaVMTarget target = (TeaVMTarget)targetSupplier.get();
        configuration.apply(target);
        DependencyAnalyzerFactory dependencyAnalyzerFactory = PreciseDependencyAnalyzer::new;
        boolean fastAnalysis = Boolean.parseBoolean(System.getProperty(FAST_ANALYSIS));
        if (fastAnalysis) {
            dependencyAnalyzerFactory = FastDependencyAnalyzer::new;
        }
        try {
            TeaVM vm = new TeaVMBuilder(target).setClassLoader(classLoader).setClassSource((ClassReaderSource)this.classSource).setReferenceCache(this.referenceCache).setDependencyAnalyzerFactory(dependencyAnalyzerFactory).build();
            configuration.apply(vm);
            additionalProcessing.accept(vm);
            vm.installPlugins();
            new TestExceptionPlugin().install((TeaVMHost)vm);
            vm.entryPoint(entryPoint);
            if (fastAnalysis) {
                vm.setOptimizationLevel(TeaVMOptimizationLevel.SIMPLE);
                vm.addVirtualMethods(m -> true);
            }
            if (!outputFile.getParentFile().exists()) {
                outputFile.getParentFile().mkdirs();
            }
            vm.build((BuildTarget)new DirectoryBuildTarget(outputFile.getParentFile()), outputFile.getName());
            if (!vm.getProblemProvider().getProblems().isEmpty()) {
                result.success = false;
                result.errorMessage = this.buildErrorMessage(vm);
            } else if (postBuild != null) {
                postBuild.process(vm, outputFile);
            }
            return result;
        }
        catch (Exception e) {
            result = new CompileResult();
            result.success = false;
            result.throwable = e;
            return result;
        }
    }

    private File getOutputFile(File path, String baseName, String suffix, boolean separateDir, String extension) {
        File outputFile;
        StringBuilder simpleName = new StringBuilder();
        simpleName.append(baseName);
        if (!suffix.isEmpty() && !separateDir) {
            simpleName.append('-').append(suffix);
        }
        if (separateDir) {
            outputFile = new File(new File(path, simpleName.toString()), "test" + extension);
        } else {
            simpleName.append(extension);
            outputFile = new File(path, simpleName.toString());
        }
        return outputFile;
    }

    private List<TeaVMTestConfiguration<JavaScriptTarget>> getJavaScriptConfigurations() {
        ArrayList<TeaVMTestConfiguration<JavaScriptTarget>> configurations = new ArrayList<TeaVMTestConfiguration<JavaScriptTarget>>();
        if (Boolean.parseBoolean(System.getProperty(JS_ENABLED, "true"))) {
            configurations.add(TeaVMTestConfiguration.JS_DEFAULT);
            if (Boolean.getBoolean(MINIFIED)) {
                configurations.add(TeaVMTestConfiguration.JS_MINIFIED);
            }
            if (Boolean.getBoolean(OPTIMIZED)) {
                configurations.add(TeaVMTestConfiguration.JS_OPTIMIZED);
            }
        }
        return configurations;
    }

    private List<TeaVMTestConfiguration<WasmTarget>> getWasmConfigurations() {
        ArrayList<TeaVMTestConfiguration<WasmTarget>> configurations = new ArrayList<TeaVMTestConfiguration<WasmTarget>>();
        if (Boolean.getBoolean(WASM_ENABLED)) {
            configurations.add(TeaVMTestConfiguration.WASM_DEFAULT);
            if (Boolean.getBoolean(OPTIMIZED)) {
                configurations.add(TeaVMTestConfiguration.WASM_OPTIMIZED);
            }
        }
        return configurations;
    }

    private List<TeaVMTestConfiguration<WasmTarget>> getWasiConfigurations() {
        ArrayList<TeaVMTestConfiguration<WasmTarget>> configurations = new ArrayList<TeaVMTestConfiguration<WasmTarget>>();
        if (Boolean.getBoolean(WASI_ENABLED)) {
            configurations.add(TeaVMTestConfiguration.WASM_DEFAULT);
            if (Boolean.getBoolean(OPTIMIZED)) {
                configurations.add(TeaVMTestConfiguration.WASM_OPTIMIZED);
            }
        }
        return configurations;
    }

    private List<TeaVMTestConfiguration<CTarget>> getCConfigurations() {
        ArrayList<TeaVMTestConfiguration<CTarget>> configurations = new ArrayList<TeaVMTestConfiguration<CTarget>>();
        if (Boolean.getBoolean(C_ENABLED)) {
            configurations.add(TeaVMTestConfiguration.C_DEFAULT);
            if (Boolean.getBoolean(OPTIMIZED)) {
                configurations.add(TeaVMTestConfiguration.C_OPTIMIZED);
            }
        }
        return configurations;
    }

    private void applyProperties(Class<?> cls, Properties result) {
        TeaVMProperties properties;
        if (cls.getSuperclass() != null) {
            this.applyProperties(cls.getSuperclass(), result);
        }
        if ((properties = cls.getAnnotation(TeaVMProperties.class)) != null) {
            for (TeaVMProperty property : properties.value()) {
                result.setProperty(property.key(), property.value());
            }
        }
    }

    private MethodDescriptor getDescriptor(Method method) {
        ValueType[] signature = (ValueType[])Stream.concat(Arrays.stream(method.getParameterTypes()).map(ValueType::parse), Stream.of(ValueType.parse(method.getReturnType()))).toArray(ValueType[]::new);
        return new MethodDescriptor(method.getName(), signature);
    }

    private String buildErrorMessage(TeaVM vm) {
        CallGraph cg = vm.getDependencyInfo().getCallGraph();
        DefaultProblemTextConsumer consumer = new DefaultProblemTextConsumer();
        StringBuilder sb = new StringBuilder();
        for (Problem problem : vm.getProblemProvider().getProblems()) {
            consumer.clear();
            problem.render((ProblemTextConsumer)consumer);
            sb.append(consumer.getText());
            TeaVMProblemRenderer.renderCallStack((CallGraph)cg, (CallLocation)problem.getLocation(), (StringBuilder)sb);
            sb.append("\n");
        }
        return sb.toString();
    }

    private void resourceToFile(String resource, File file, Map<String, String> properties) throws IOException {
        block28: {
            String content;
            if (properties.isEmpty()) {
                try (InputStream input = TeaVMTestRunner.class.getClassLoader().getResourceAsStream(resource);
                     BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));){
                    IOUtils.copy((InputStream)input, (OutputStream)output);
                    break block28;
                }
            }
            try (InputStream input = TeaVMTestRunner.class.getClassLoader().getResourceAsStream(resource);){
                content = IOUtils.toString((InputStream)input, (Charset)StandardCharsets.UTF_8);
            }
            content = TeaVMTestRunner.replaceProperties(content, properties);
            try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));
                 OutputStreamWriter writer = new OutputStreamWriter(output);){
                writer.write(content);
            }
        }
    }

    private static String replaceProperties(String s, Map<String, String> properties) {
        int end;
        int next;
        int i = 0;
        StringBuilder sb = new StringBuilder();
        while (i < s.length() && (next = s.indexOf("${", i)) >= 0 && (end = s.indexOf(125, next + 2)) >= 0) {
            sb.append(s, i, next);
            String property = s.substring(next + 2, end);
            String value = properties.get(property);
            if (value == null) {
                sb.append(s, next, end + 1);
            } else {
                sb.append(value);
            }
            i = end + 1;
        }
        if (i == 0) {
            return s;
        }
        return sb.append(s.substring(i)).toString();
    }

    private ClassHolderSource getClassSource(ClassLoader classLoader) {
        return classSources.computeIfAbsent(classLoader, cl -> new PreOptimizingClassHolderSource((ClassHolderSource)new ClasspathClassHolderSource(classLoader, this.referenceCache)));
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        Iterator<Method> iterator = this.getFilteredChildren().iterator();
        while (iterator.hasNext()) {
            Method method = iterator.next();
            if (filter.shouldRun(this.describeChild(method))) {
                filter.apply((Object)method);
                continue;
            }
            iterator.remove();
        }
    }

    private void writeRunsDescriptor() {
        if (this.runsInCurrentClass.isEmpty()) {
            return;
        }
        File outputDir = this.getOutputPathForClass();
        outputDir.mkdirs();
        File descriptorFile = new File(outputDir, "tests.json");
        try (FileOutputStream output = new FileOutputStream(descriptorFile);
             BufferedOutputStream bufferedOutput = new BufferedOutputStream(output);
             OutputStreamWriter writer = new OutputStreamWriter(bufferedOutput);){
            writer.write("[\n");
            boolean first = true;
            for (TestRun run : this.runsInCurrentClass.toArray(new TestRun[0])) {
                if (!first) {
                    writer.write(",\n");
                }
                first = false;
                writer.write("  {\n");
                writer.write("    \"baseDir\": ");
                TeaVMTestRunner.writeJsonString(writer, run.getBaseDirectory().getAbsolutePath().replace('\\', '/'));
                writer.write(",\n");
                writer.write("    \"fileName\": ");
                TeaVMTestRunner.writeJsonString(writer, run.getFileName());
                writer.write(",\n");
                writer.write("    \"kind\": \"" + run.getKind().name() + "\"");
                if (run.getArgument() != null) {
                    writer.write(",\n");
                    writer.write("    \"argument\": ");
                    TeaVMTestRunner.writeJsonString(writer, run.getArgument());
                }
                writer.write(",\n");
                writer.write("    \"name\": ");
                TeaVMTestRunner.writeJsonString(writer, run.getName());
                writer.write("\n  }");
            }
            writer.write("\n]");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void writeJsonString(Writer writer, String s) throws IOException {
        writer.write(34);
        block9: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    writer.write("\\\"");
                    continue block9;
                }
                case '\\': {
                    writer.write("\\\\");
                    continue block9;
                }
                case '\r': {
                    writer.write("\\r");
                    continue block9;
                }
                case '\n': {
                    writer.write("\\n");
                    continue block9;
                }
                case '\t': {
                    writer.write("\\t");
                    continue block9;
                }
                case '\f': {
                    writer.write("\\f");
                    continue block9;
                }
                case '\b': {
                    writer.write("\\b");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        writer.write("\\u00");
                        writer.write(TeaVMTestRunner.hex(c / 16));
                        writer.write(TeaVMTestRunner.hex(c % 16));
                        continue block9;
                    }
                    writer.write(c);
                }
            }
        }
        writer.write(34);
    }

    private static char hex(int digit) {
        return (char)(digit < 10 ? 48 + digit : 65 + digit - 10);
    }

    static {
        for (RunKind kind : RunKind.values()) {
            runners.put(kind, new RunnerKindInfo());
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            Class<TeaVMTestRunner> clazz = TeaVMTestRunner.class;
            synchronized (TeaVMTestRunner.class) {
                for (RunnerKindInfo info : runners.values()) {
                    if (info.runner == null) continue;
                    info.runner.stop();
                    info.runner.waitForCompletion();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }));
    }

    static class RunnerKindInfo {
        volatile TestRunner runner;
        volatile TestRunStrategy strategy;

        RunnerKindInfo() {
        }
    }

    static class CompileResult {
        boolean success = true;
        String errorMessage;
        File file;
        Throwable throwable;

        CompileResult() {
        }
    }

    static interface Runner {
        public void run(Object[] var1) throws Throwable;
    }

    static class JUnit3Runner
    implements Runner {
        TestCase instance;
        Method testMethod;

        JUnit3Runner(TestCase instance, Method testMethod) {
            this.instance = instance;
            this.testMethod = testMethod;
        }

        @Override
        public void run(Object[] arguments) throws Throwable {
            this.instance.setName(this.testMethod.getName());
            this.instance.runBare();
        }
    }

    static class SimpleMethodRunner
    implements Runner {
        Object instance;
        Method testMethod;

        SimpleMethodRunner(Object instance, Method testMethod) {
            this.instance = instance;
            this.testMethod = testMethod;
        }

        @Override
        public void run(Object[] arguments) throws Throwable {
            try {
                this.testMethod.invoke(this.instance, arguments);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }

    static class WithExpectedExceptionRunner
    implements Runner {
        private Runner underlyingRunner;
        private String[] expectedExceptions;

        WithExpectedExceptionRunner(Runner underlyingRunner, String[] expectedExceptions) {
            this.underlyingRunner = underlyingRunner;
            this.expectedExceptions = expectedExceptions;
        }

        @Override
        public void run(Object[] arguments) throws Throwable {
            boolean caught;
            block4: {
                caught = false;
                try {
                    this.underlyingRunner.run(arguments);
                }
                catch (Exception e) {
                    for (String expected : this.expectedExceptions) {
                        if (!this.isSubtype(e.getClass(), expected)) continue;
                        caught = true;
                        break;
                    }
                    if (caught) break block4;
                    throw e;
                }
            }
            if (!caught) {
                throw new AssertionError((Object)"Expected exception not thrown");
            }
        }

        private boolean isSubtype(Class<?> cls, String superType) {
            while (cls != Throwable.class) {
                if (cls.getName().equals(superType)) {
                    return true;
                }
                cls = cls.getSuperclass();
            }
            return false;
        }
    }

    static class WithBeforeAndAfterRunner
    implements Runner {
        private Runner underlyingRunner;
        private Object instance;
        private Method[] beforeMethods;
        private Method[] afterMethods;

        WithBeforeAndAfterRunner(Runner underlyingRunner, Object instance, Method[] beforeMethods, Method[] afterMethods) {
            this.underlyingRunner = underlyingRunner;
            this.instance = instance;
            this.beforeMethods = beforeMethods;
            this.afterMethods = afterMethods;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(Object[] arguments) throws Throwable {
            for (Method method : this.beforeMethods) {
                try {
                    method.invoke(this.instance, new Object[0]);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            try {
                this.underlyingRunner.run(arguments);
            }
            finally {
                for (Method method : this.afterMethods) {
                    method.invoke(this.instance, new Object[0]);
                }
            }
        }
    }

    static class WithDataProviderRunner
    implements Runner {
        Runner underlyingRunner;
        Object data;
        Class<?>[] types;

        WithDataProviderRunner(Runner underlyingRunner, Object data, Class<?>[] types) {
            this.underlyingRunner = underlyingRunner;
            this.data = data;
            this.types = types;
        }

        @Override
        public void run(Object[] arguments) throws Throwable {
            if (arguments.length > 0) {
                throw new IllegalArgumentException("Expected 0 arguments");
            }
            if (this.data instanceof Iterator) {
                this.runWithIteratorData((Iterator)this.data);
            } else {
                this.runWithArrayData((Object[][])this.data);
            }
        }

        private void runWithArrayData(Object[][] data) throws Throwable {
            for (int i = 0; i < data.length; ++i) {
                this.runWithDataRow(data[i]);
            }
        }

        private void runWithIteratorData(Iterator<?> data) throws Throwable {
            while (data.hasNext()) {
                this.runWithDataRow((Object[])data.next());
            }
        }

        private void runWithDataRow(Object[] dataRow) throws Throwable {
            Object[] args = (Object[])dataRow.clone();
            for (int j = 0; j < args.length; ++j) {
                args[j] = this.convert(args[j], this.types[j]);
            }
            this.underlyingRunner.run(args);
        }

        private Object convert(Object value, Class<?> type) {
            if (type == Byte.TYPE) {
                value = ((Number)value).byteValue();
            } else if (type == Short.TYPE) {
                value = ((Number)value).shortValue();
            } else if (type == Integer.TYPE) {
                value = ((Number)value).intValue();
            } else if (type == Long.TYPE) {
                value = ((Number)value).longValue();
            } else if (type == Float.TYPE) {
                value = Float.valueOf(((Number)value).floatValue());
            } else if (type == Double.TYPE) {
                value = ((Number)value).doubleValue();
            }
            return value;
        }
    }

    static interface CompilePostProcessor {
        public void process(TeaVM var1, File var2);
    }
}

