/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.junit;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.teavm.junit.TestRun;
import org.teavm.junit.TestRunCallback;
import org.teavm.junit.TestRunStrategy;

class BrowserRunStrategy
implements TestRunStrategy {
    private boolean decodeStack = Boolean.parseBoolean(System.getProperty("teavm.junit.js.decodeStack", "true"));
    private final File baseDir;
    private final String type;
    private final Function<String, Process> browserRunner;
    private Process browserProcess;
    private Server server;
    private int port;
    private AtomicInteger idGenerator = new AtomicInteger(0);
    private BlockingQueue<Session> wsSessionQueue = new LinkedBlockingQueue<Session>();
    private ConcurrentMap<Integer, CallbackWrapper> awaitingRuns = new ConcurrentHashMap<Integer, CallbackWrapper>();
    private ObjectMapper objectMapper = new ObjectMapper();

    public BrowserRunStrategy(File baseDir, String type, Function<String, Process> browserRunner) {
        this.baseDir = baseDir;
        this.type = type;
        this.browserRunner = browserRunner;
    }

    @Override
    public void beforeAll() {
        this.runServer();
        this.browserProcess = this.browserRunner.apply("http://localhost:" + this.port + "/index.html");
    }

    private void runServer() {
        this.server = new Server();
        ServerConnector connector = new ServerConnector(this.server);
        this.server.addConnector((Connector)connector);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        this.server.setHandler((Handler)context);
        TestCodeServlet servlet = new TestCodeServlet();
        ServletHolder servletHolder = new ServletHolder((Servlet)servlet);
        servletHolder.setAsyncSupported(true);
        context.addServlet(servletHolder, "/*");
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.port = connector.getLocalPort();
    }

    @Override
    public void afterAll() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.browserProcess != null) {
            this.browserProcess.destroy();
        }
    }

    @Override
    public void beforeThread() {
    }

    @Override
    public void afterThread() {
    }

    @Override
    public void runTest(TestRun run) throws IOException {
        while (!this.runTestOnce(run)) {
        }
    }

    private boolean runTestOnce(TestRun run) {
        Session ws;
        try {
            while ((ws = this.wsSessionQueue.poll(1L, TimeUnit.SECONDS)) == null || !ws.isOpen()) {
            }
        }
        catch (InterruptedException e) {
            run.getCallback().error(e);
            return true;
        }
        int id = this.idGenerator.incrementAndGet();
        CountDownLatch latch = new CountDownLatch(1);
        CallbackWrapper callbackWrapper = new CallbackWrapper(latch, run);
        this.awaitingRuns.put(id, callbackWrapper);
        JsonNodeFactory nf = this.objectMapper.getNodeFactory();
        ObjectNode node = nf.objectNode();
        node.set("id", (JsonNode)nf.numberNode(id));
        ArrayNode array = nf.arrayNode();
        node.set("tests", (JsonNode)array);
        File file = new File(run.getBaseDirectory(), run.getFileName()).getAbsoluteFile();
        String relPath = this.baseDir.getAbsoluteFile().toPath().relativize(file.toPath()).toString();
        ObjectNode testNode = nf.objectNode();
        testNode.set("type", (JsonNode)nf.textNode(this.type));
        testNode.set("name", (JsonNode)nf.textNode(run.getFileName()));
        testNode.set("file", (JsonNode)nf.textNode("tests/" + relPath));
        if (run.getArgument() != null) {
            testNode.set("argument", (JsonNode)nf.textNode(run.getArgument()));
        }
        array.add((JsonNode)testNode);
        String message = node.toString();
        ws.getRemote().sendStringByFuture(message);
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (ws.isOpen()) {
            this.wsSessionQueue.offer(ws);
        }
        return !callbackWrapper.shouldRepeat;
    }

    class TestCodeServlet
    extends HttpServlet {
        private WebSocketServletFactory wsFactory;
        private Map<String, String> contentCache = new ConcurrentHashMap<String, String>();

        TestCodeServlet() {
        }

        public void init(ServletConfig config) throws ServletException {
            super.init(config);
            WebSocketPolicy wsPolicy = new WebSocketPolicy(WebSocketBehavior.SERVER);
            this.wsFactory = WebSocketServletFactory.Loader.load((ServletContext)config.getServletContext(), (WebSocketPolicy)wsPolicy);
            this.wsFactory.setCreator((req, resp) -> new TestCodeSocket());
            try {
                this.wsFactory.start();
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }

        protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            Object path = req.getRequestURI();
            if (path != null) {
                if (!((String)path).startsWith("/")) {
                    path = "/" + (String)path;
                }
                if (req.getMethod().equals("GET")) {
                    String relPath;
                    File file;
                    switch (path) {
                        case "/index.html": 
                        case "/frame.html": {
                            String content = this.getFromCache((String)path, "true".equals(req.getParameter("logging")));
                            if (content == null) break;
                            resp.setStatus(200);
                            resp.setContentType("text/html");
                            resp.getOutputStream().write(content.getBytes(StandardCharsets.UTF_8));
                            resp.getOutputStream().flush();
                            return;
                        }
                        case "/client.js": 
                        case "/frame.js": 
                        case "/deobfuscator.js": {
                            String content = this.getFromCache((String)path, false);
                            if (content == null) break;
                            resp.setStatus(200);
                            resp.setContentType("application/javascript");
                            resp.getOutputStream().write(content.getBytes(StandardCharsets.UTF_8));
                            resp.getOutputStream().flush();
                            return;
                        }
                    }
                    if (((String)path).startsWith("/tests/") && (file = new File(BrowserRunStrategy.this.baseDir, relPath = ((String)path).substring("/tests/".length()))).isFile()) {
                        resp.setStatus(200);
                        if (file.getName().endsWith(".js")) {
                            resp.setContentType("application/javascript");
                        } else if (file.getName().endsWith(".wasm")) {
                            resp.setContentType("application/wasm");
                        }
                        try (FileInputStream input = new FileInputStream(file);){
                            this.copy(input, (OutputStream)resp.getOutputStream());
                        }
                        resp.getOutputStream().flush();
                    }
                }
                if (((String)path).equals("/ws") && this.wsFactory.isUpgradeRequest(req, resp) && (this.wsFactory.acceptWebSocket(req, resp) || resp.isCommitted())) {
                    return;
                }
            }
            resp.setStatus(404);
        }

        private String getFromCache(String fileName, boolean logging) {
            return this.contentCache.computeIfAbsent(fileName, fn -> {
                ClassLoader loader = BrowserRunStrategy.class.getClassLoader();
                try (InputStream input = loader.getResourceAsStream("test-server" + fn);){
                    String string;
                    try (InputStreamReader reader = new InputStreamReader(input);){
                        int charsRead;
                        StringBuilder sb = new StringBuilder();
                        char[] buffer = new char[2048];
                        while ((charsRead = reader.read(buffer)) >= 0) {
                            sb.append(buffer, 0, charsRead);
                        }
                        string = sb.toString().replace("{{PORT}}", String.valueOf(BrowserRunStrategy.this.port)).replace("\"{{LOGGING}}\"", String.valueOf(logging)).replace("\"{{DEOBFUSCATION}}\"", String.valueOf(BrowserRunStrategy.this.decodeStack));
                    }
                    return string;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            });
        }

        private void copy(InputStream input, OutputStream output) throws IOException {
            int bytes;
            byte[] buffer = new byte[2048];
            while ((bytes = input.read(buffer)) >= 0) {
                output.write(buffer, 0, bytes);
            }
        }
    }

    static class CallbackWrapper
    implements TestRunCallback {
        private final CountDownLatch latch;
        private final TestRun run;
        volatile boolean shouldRepeat;

        CallbackWrapper(CountDownLatch latch, TestRun run) {
            this.latch = latch;
            this.run = run;
        }

        @Override
        public void complete() {
            this.latch.countDown();
            this.run.getCallback().complete();
        }

        @Override
        public void error(Throwable e) {
            this.latch.countDown();
            this.run.getCallback().error(e);
        }

        void repeat() {
            this.latch.countDown();
            this.shouldRepeat = true;
        }
    }

    class TestCodeSocket
    extends WebSocketAdapter {
        TestCodeSocket() {
        }

        public void onWebSocketConnect(Session sess) {
            BrowserRunStrategy.this.wsSessionQueue.offer(sess);
        }

        public void onWebSocketClose(int statusCode, String reason) {
            for (CallbackWrapper run : BrowserRunStrategy.this.awaitingRuns.values()) {
                run.repeat();
            }
        }

        public void onWebSocketText(String message) {
            String status;
            JsonNode node;
            try {
                node = BrowserRunStrategy.this.objectMapper.readTree((Reader)new StringReader(message));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            int id = node.get("id").asInt();
            TestRunCallback run = (TestRunCallback)BrowserRunStrategy.this.awaitingRuns.remove(id);
            if (run == null) {
                System.err.println("Unexpected run id: " + id);
                return;
            }
            JsonNode resultNode = node.get("result");
            JsonNode log = resultNode.get("log");
            if (log != null) {
                for (JsonNode logEntry : log) {
                    String str = logEntry.get("message").asText();
                    switch (logEntry.get("type").asText()) {
                        case "stdout": {
                            System.out.println(str);
                            break;
                        }
                        case "stderr": {
                            System.err.println(str);
                        }
                    }
                }
            }
            if ((status = resultNode.get("status").asText()).equals("OK")) {
                run.complete();
            } else {
                run.error(new RuntimeException(resultNode.get("errorMessage").asText()));
            }
        }
    }
}

