/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.junit;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.teavm.junit.TestRun;
import org.teavm.junit.TestRunStrategy;

class TestRunner {
    private int numThreads = 1;
    private TestRunStrategy strategy;
    private BlockingQueue<Runnable> taskQueue = new LinkedBlockingQueue<Runnable>();
    private CountDownLatch latch;
    private volatile boolean stopped;

    TestRunner(TestRunStrategy strategy) {
        this.strategy = strategy;
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public void init() {
        this.latch = new CountDownLatch(this.numThreads);
        this.strategy.beforeAll();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.strategy.afterAll()));
        for (int i = 0; i < this.numThreads; ++i) {
            Thread thread = new Thread(() -> {
                this.strategy.beforeThread();
                while (!this.stopped || !this.taskQueue.isEmpty()) {
                    Runnable task;
                    try {
                        task = this.taskQueue.poll(100L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    if (task == null) continue;
                    task.run();
                }
                this.strategy.afterThread();
                this.latch.countDown();
            });
            thread.setDaemon(true);
            thread.setName("teavm-test-runner-" + i);
            thread.start();
        }
    }

    private void addTask(Runnable runnable) {
        this.taskQueue.add(runnable);
    }

    public void stop() {
        this.stopped = true;
        this.taskQueue.add(() -> {});
    }

    public void waitForCompletion() {
        try {
            while (!this.latch.await(1000L, TimeUnit.MILLISECONDS)) {
            }
        }
        catch (InterruptedException e) {}
    }

    public void run(TestRun run) {
        this.addTask(() -> this.runImpl(run));
    }

    private void runImpl(TestRun run) {
        try {
            this.strategy.runTest(run);
        }
        catch (Exception e) {
            run.getCallback().error(e);
        }
    }
}

