/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.junit;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import org.teavm.junit.TestRun;
import org.teavm.junit.TestRunStrategy;

class CRunStrategy
implements TestRunStrategy {
    private String compilerCommand;
    private ConcurrentMap<String, Compilation> compilationMap = new ConcurrentHashMap<String, Compilation>();

    CRunStrategy(String compilerCommand) {
        this.compilerCommand = compilerCommand;
    }

    @Override
    public void beforeAll() {
    }

    @Override
    public void afterAll() {
    }

    @Override
    public void beforeThread() {
    }

    @Override
    public void afterThread() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runTest(TestRun run) throws IOException {
        try {
            String exeName = "run_test";
            if (System.getProperty("os.name").toLowerCase().contains("win")) {
                exeName = exeName + ".exe";
            }
            File outputFile = new File(run.getBaseDirectory(), exeName);
            boolean compilerSuccess = this.compile(run.getBaseDirectory());
            if (!compilerSuccess) {
                run.getCallback().error(new RuntimeException("C compiler error"));
                return;
            }
            ArrayList<String> runtimeOutput = new ArrayList<String>();
            ArrayList<String> stdout = new ArrayList<String>();
            outputFile.setExecutable(true);
            CRunStrategy cRunStrategy = this;
            synchronized (cRunStrategy) {
                ArrayList<String> runCommand = new ArrayList<String>();
                runCommand.add(outputFile.getPath());
                if (run.getArgument() != null) {
                    runCommand.add(run.getArgument());
                }
                this.runProcess(new ProcessBuilder(runCommand.toArray(new String[0])).start(), runtimeOutput, stdout);
            }
            if (!stdout.isEmpty() && ((String)stdout.get(stdout.size() - 1)).equals("SUCCESS")) {
                this.writeLines(runtimeOutput);
                run.getCallback().complete();
            } else {
                run.getCallback().error(new RuntimeException("Test failed:\n" + this.mergeLines(runtimeOutput)));
            }
        }
        catch (InterruptedException e) {
            run.getCallback().complete();
        }
    }

    private String mergeLines(List<String> lines) {
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(line).append('\n');
        }
        return sb.toString();
    }

    private void writeLines(List<String> lines) {
        for (String line : lines) {
            System.out.println(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compile(File inputDir) throws IOException, InterruptedException {
        Compilation compilation;
        Compilation compilation2 = compilation = this.compilationMap.computeIfAbsent(inputDir.getPath(), k -> new Compilation());
        synchronized (compilation2) {
            if (!compilation.started) {
                compilation.started = true;
                compilation.success = this.doCompile(inputDir);
            }
        }
        return compilation.success;
    }

    private boolean doCompile(File inputDir) throws IOException, InterruptedException {
        ArrayList<String> compilerOutput = new ArrayList<String>();
        boolean compilerSuccess = this.runCompiler(inputDir, compilerOutput);
        this.writeLines(compilerOutput);
        return compilerSuccess;
    }

    private boolean runCompiler(File inputDir, List<String> output) throws IOException, InterruptedException {
        String command = new File(this.compilerCommand).getAbsolutePath();
        return this.runProcess(new ProcessBuilder(command).directory(inputDir).start(), output, new ArrayList<String>());
    }

    private boolean runProcess(Process process, List<String> output, List<String> stdout) throws InterruptedException {
        BufferedReader stdin = new BufferedReader(new InputStreamReader(process.getInputStream()));
        BufferedReader stderr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        ConcurrentLinkedQueue<String> lines = new ConcurrentLinkedQueue<String>();
        Thread thread = new Thread(() -> {
            try {
                String line;
                while ((line = stderr.readLine()) != null) {
                    lines.add(line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        thread.setDaemon(true);
        thread.start();
        try {
            String line;
            while ((line = stdin.readLine()) != null) {
                lines.add(line);
                stdout.add(line);
                if (lines.size() <= 10000) continue;
                output.addAll(lines);
                process.destroy();
                return false;
            }
        }
        catch (IOException line) {
            // empty catch block
        }
        boolean result = process.waitFor() == 0;
        output.addAll(lines);
        return result;
    }

    static class Compilation {
        volatile boolean started;
        volatile boolean success;

        Compilation() {
        }
    }
}

