/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jetty.websocket.servlet;

import java.io.IOException;
import org.teavm.javaxservlet.ServletContext;
import org.teavm.javaxservlet.ServletException;
import org.teavm.javaxservlet.http.HttpServlet;
import org.teavm.javaxservlet.http.HttpServletRequest;
import org.teavm.javaxservlet.http.HttpServletResponse;
import org.teavm.jetty.websocket.api.WebSocketBehavior;
import org.teavm.jetty.websocket.api.WebSocketPolicy;
import org.teavm.jetty.websocket.servlet.WebSocketServletFactory;

public abstract class WebSocketServlet
extends HttpServlet {
    private WebSocketServletFactory factory;

    public abstract void configure(WebSocketServletFactory var1);

    @Override
    public void destroy() {
        try {
            ServletContext ctx = this.getServletContext();
            ctx.removeAttribute(WebSocketServletFactory.class.getName());
            this.factory.stop();
            this.factory = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void init() throws ServletException {
        try {
            WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.SERVER);
            String max = this.getInitParameter("maxIdleTime");
            if (max != null) {
                policy.setIdleTimeout(Long.parseLong(max));
            }
            if ((max = this.getInitParameter("maxTextMessageSize")) != null) {
                policy.setMaxTextMessageSize(Integer.parseInt(max));
            }
            if ((max = this.getInitParameter("maxBinaryMessageSize")) != null) {
                policy.setMaxBinaryMessageSize(Integer.parseInt(max));
            }
            if ((max = this.getInitParameter("inputBufferSize")) != null) {
                policy.setInputBufferSize(Integer.parseInt(max));
            }
            ServletContext ctx = this.getServletContext();
            this.factory = WebSocketServletFactory.Loader.load(ctx, policy);
            this.configure(this.factory);
            this.factory.start();
            ctx.setAttribute(WebSocketServletFactory.class.getName(), this.factory);
        }
        catch (Exception x) {
            throw new ServletException(x);
        }
    }

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.factory.isUpgradeRequest(request, response)) {
            if (this.factory.acceptWebSocket(request, response)) {
                return;
            }
            if (response.isCommitted()) {
                return;
            }
        }
        super.service(request, response);
    }
}

