/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jetty.websocket.jsr356.server;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.WebSocketContainer;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.teavm.jetty.client.HttpClient;
import org.teavm.jetty.server.handler.ContextHandler;
import org.teavm.jetty.servlet.ServletContextHandler;
import org.teavm.jetty.util.annotation.ManagedObject;
import org.teavm.jetty.util.log.Log;
import org.teavm.jetty.util.log.Logger;
import org.teavm.jetty.websocket.common.events.EventDriverFactory;
import org.teavm.jetty.websocket.common.util.ReflectUtils;
import org.teavm.jetty.websocket.jsr356.ClientContainer;
import org.teavm.jetty.websocket.jsr356.JsrSessionFactory;
import org.teavm.jetty.websocket.jsr356.annotations.AnnotatedEndpointScanner;
import org.teavm.jetty.websocket.jsr356.endpoints.EndpointInstance;
import org.teavm.jetty.websocket.jsr356.metadata.EndpointMetadata;
import org.teavm.jetty.websocket.jsr356.server.AnnotatedServerEndpointMetadata;
import org.teavm.jetty.websocket.jsr356.server.BasicServerEndpointConfig;
import org.teavm.jetty.websocket.jsr356.server.ContainerDefaultConfigurator;
import org.teavm.jetty.websocket.jsr356.server.JsrCreator;
import org.teavm.jetty.websocket.jsr356.server.JsrServerEndpointImpl;
import org.teavm.jetty.websocket.jsr356.server.JsrServerExtendsEndpointImpl;
import org.teavm.jetty.websocket.jsr356.server.ServerEndpointMetadata;
import org.teavm.jetty.websocket.jsr356.server.SimpleServerEndpointMetadata;
import org.teavm.jetty.websocket.server.NativeWebSocketConfiguration;
import org.teavm.jetty.websocket.server.WebSocketServerFactory;
import org.teavm.jetty.websocket.servlet.WebSocketCreator;

@ManagedObject(value="JSR356 Server Container")
public class ServerContainer
extends ClientContainer
implements javax.websocket.server.ServerContainer {
    private static final Logger LOG = Log.getLogger(ServerContainer.class);
    private final NativeWebSocketConfiguration configuration;
    private List<Class<?>> deferredEndpointClasses;
    private List<ServerEndpointConfig> deferredEndpointConfigs;

    public static WebSocketContainer getWebSocketContainer() {
        ContextHandler.Context context = ContextHandler.getCurrentContext();
        if (context == null) {
            return null;
        }
        ContextHandler handler = ContextHandler.getContextHandler(context);
        if (handler == null) {
            return null;
        }
        if (!(handler instanceof ServletContextHandler)) {
            return null;
        }
        return (WebSocketContainer)handler.getServletContext().getAttribute("javax.websocket.server.ServerContainer");
    }

    @Deprecated
    public ServerContainer(NativeWebSocketConfiguration configuration, Executor executor) {
        this(configuration, (HttpClient)null);
    }

    public ServerContainer(NativeWebSocketConfiguration configuration, HttpClient httpClient) {
        super(configuration.getFactory(), httpClient);
        this.configuration = configuration;
        EventDriverFactory eventDriverFactory = this.configuration.getFactory().getEventDriverFactory();
        eventDriverFactory.addImplementation(new JsrServerEndpointImpl());
        eventDriverFactory.addImplementation(new JsrServerExtendsEndpointImpl());
        this.configuration.getFactory().addSessionFactory(new JsrSessionFactory(this));
        this.addBean(this.configuration);
    }

    public EndpointInstance newClientEndpointInstance(Object endpoint, ServerEndpointConfig config, String path) {
        EndpointMetadata metadata = this.getClientEndpointMetadata(endpoint.getClass(), (EndpointConfig)config);
        Object cec = config;
        if (config == null) {
            cec = metadata instanceof AnnotatedServerEndpointMetadata ? ((AnnotatedServerEndpointMetadata)metadata).getConfig() : new BasicServerEndpointConfig(this, endpoint.getClass(), path);
        }
        return new EndpointInstance(endpoint, (EndpointConfig)cec, metadata);
    }

    private void validateEndpointConfig(ServerEndpointConfig config) throws DeploymentException {
        if (config == null) {
            throw new DeploymentException("Unable to deploy null ServerEndpointConfig");
        }
        ServerEndpointConfig.Configurator configurator = config.getConfigurator();
        if (configurator == null) {
            throw new DeploymentException("Unable to deploy with null ServerEndpointConfig.Configurator");
        }
        Class endpointClass = config.getEndpointClass();
        if (endpointClass == null) {
            throw new DeploymentException("Unable to deploy null endpoint class from ServerEndpointConfig: " + config.getClass().getName());
        }
        if (configurator.getClass() == ContainerDefaultConfigurator.class && !ReflectUtils.isDefaultConstructable(endpointClass)) {
            throw new DeploymentException("Cannot access default constructor for the class: " + endpointClass.getName());
        }
    }

    public void addEndpoint(Class<?> endpointClass) throws DeploymentException {
        if (endpointClass == null) {
            throw new DeploymentException("Unable to deploy null endpoint class");
        }
        if (this.isStarted() || this.isStarting()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("addEndpoint({})", endpointClass);
            }
            ServerEndpointMetadata metadata = this.getServerEndpointMetadata(endpointClass, null);
            this.validateEndpointConfig(metadata.getConfig());
            this.addEndpoint(metadata);
        } else {
            if (this.deferredEndpointClasses == null) {
                this.deferredEndpointClasses = new ArrayList();
            }
            this.deferredEndpointClasses.add(endpointClass);
        }
    }

    private void addEndpoint(ServerEndpointMetadata metadata) {
        JsrCreator creator = new JsrCreator(this, metadata, this.configuration.getFactory().getExtensionFactory());
        this.configuration.addMapping("uri-template|" + metadata.getPath(), (WebSocketCreator)creator);
    }

    public void addEndpoint(ServerEndpointConfig config) throws DeploymentException {
        this.validateEndpointConfig(config);
        if (this.isStarted() || this.isStarting()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("addEndpoint({}) path={} endpoint={}", config, config.getPath(), config.getEndpointClass());
            }
            ServerEndpointMetadata metadata = this.getServerEndpointMetadata(config.getEndpointClass(), config);
            this.addEndpoint(metadata);
        } else {
            if (this.deferredEndpointConfigs == null) {
                this.deferredEndpointConfigs = new ArrayList<ServerEndpointConfig>();
            }
            this.deferredEndpointConfigs.add(config);
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.deferredEndpointClasses != null) {
            for (Class<?> endpointClass : this.deferredEndpointClasses) {
                this.addEndpoint(endpointClass);
            }
            this.deferredEndpointClasses.clear();
        }
        if (this.deferredEndpointConfigs != null) {
            for (ServerEndpointConfig config : this.deferredEndpointConfigs) {
                this.addEndpoint(config);
            }
            this.deferredEndpointConfigs.clear();
        }
    }

    public ServerEndpointMetadata getServerEndpointMetadata(Class<?> endpoint, ServerEndpointConfig config) throws DeploymentException {
        try {
            ServerEndpointMetadata metadata;
            ServerEndpoint anno = endpoint.getAnnotation(ServerEndpoint.class);
            if (anno != null) {
                AnnotatedServerEndpointMetadata ametadata = new AnnotatedServerEndpointMetadata(this, endpoint, config);
                AnnotatedEndpointScanner<ServerEndpoint, ServerEndpointConfig> scanner = new AnnotatedEndpointScanner<ServerEndpoint, ServerEndpointConfig>(ametadata);
                metadata = ametadata;
                scanner.scan();
            } else if (Endpoint.class.isAssignableFrom(endpoint)) {
                Class<?> eendpoint = endpoint;
                metadata = new SimpleServerEndpointMetadata(eendpoint, config);
            } else {
                String err = "Not a recognized websocket [" + endpoint.getName() + "] does not extend @" + ServerEndpoint.class.getName() + " or extend from " + Endpoint.class.getName();
                throw new DeploymentException(err);
            }
            return metadata;
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new DeploymentException(t.getMessage(), t);
        }
    }

    @Override
    public long getDefaultAsyncSendTimeout() {
        return this.configuration.getPolicy().getAsyncWriteTimeout();
    }

    @Override
    public int getDefaultMaxBinaryMessageBufferSize() {
        return this.configuration.getPolicy().getMaxBinaryMessageSize();
    }

    @Override
    public long getDefaultMaxSessionIdleTimeout() {
        return this.configuration.getPolicy().getIdleTimeout();
    }

    @Override
    public int getDefaultMaxTextMessageBufferSize() {
        return this.configuration.getPolicy().getMaxTextMessageSize();
    }

    public WebSocketServerFactory getWebSocketServerFactory() {
        return this.configuration.getFactory();
    }

    @Override
    public void setAsyncSendTimeout(long ms) {
        super.setAsyncSendTimeout(ms);
        this.configuration.getPolicy().setAsyncWriteTimeout(ms);
    }

    @Override
    public void setDefaultMaxBinaryMessageBufferSize(int max) {
        super.setDefaultMaxBinaryMessageBufferSize(max);
        this.configuration.getPolicy().setMaxBinaryMessageSize(max);
        this.configuration.getPolicy().setMaxBinaryMessageBufferSize(max);
    }

    @Override
    public void setDefaultMaxSessionIdleTimeout(long ms) {
        super.setDefaultMaxSessionIdleTimeout(ms);
        this.configuration.getPolicy().setIdleTimeout(ms);
    }

    @Override
    public void setDefaultMaxTextMessageBufferSize(int max) {
        super.setDefaultMaxTextMessageBufferSize(max);
        this.configuration.getPolicy().setMaxTextMessageSize(max);
        this.configuration.getPolicy().setMaxTextMessageBufferSize(max);
    }
}

