/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jetty.websocket.jsr356.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.websocket.Decoder;
import javax.websocket.DeploymentException;
import javax.websocket.Encoder;
import javax.websocket.Extension;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.teavm.jetty.websocket.common.scopes.WebSocketContainerScope;
import org.teavm.jetty.websocket.jsr356.server.ContainerDefaultConfigurator;

public class AnnotatedServerEndpointConfig
implements ServerEndpointConfig {
    private final Class<?> endpointClass;
    private final String path;
    private final List<Class<? extends Decoder>> decoders;
    private final List<Class<? extends Encoder>> encoders;
    private final ServerEndpointConfig.Configurator configurator;
    private final List<String> subprotocols;
    private Map<String, Object> userProperties;
    private List<Extension> extensions;

    public AnnotatedServerEndpointConfig(WebSocketContainerScope containerScope, Class<?> endpointClass, ServerEndpoint anno) throws DeploymentException {
        this(containerScope, endpointClass, anno, null);
    }

    public AnnotatedServerEndpointConfig(WebSocketContainerScope containerScope, Class<?> endpointClass, ServerEndpoint anno, ServerEndpointConfig baseConfig) throws DeploymentException {
        ServerEndpointConfig.Configurator resolvedConfigurator;
        ServerEndpointConfig.Configurator manualConfigurator = null;
        if (baseConfig != null) {
            manualConfigurator = baseConfig.getConfigurator();
        }
        this.decoders = baseConfig != null && baseConfig.getDecoders() != null && baseConfig.getDecoders().size() > 0 ? Collections.unmodifiableList(baseConfig.getDecoders()) : Collections.unmodifiableList(Arrays.asList(anno.decoders()));
        this.encoders = baseConfig != null && baseConfig.getEncoders() != null && baseConfig.getEncoders().size() > 0 ? Collections.unmodifiableList(baseConfig.getEncoders()) : Collections.unmodifiableList(Arrays.asList(anno.encoders()));
        this.subprotocols = baseConfig != null && baseConfig.getSubprotocols() != null && baseConfig.getSubprotocols().size() > 0 ? Collections.unmodifiableList(baseConfig.getSubprotocols()) : Collections.unmodifiableList(Arrays.asList(anno.subprotocols()));
        this.path = baseConfig != null && baseConfig.getPath() != null && baseConfig.getPath().length() > 0 ? baseConfig.getPath() : anno.value();
        this.extensions = new ArrayList<Extension>();
        this.endpointClass = endpointClass;
        this.userProperties = new HashMap<String, Object>();
        if (baseConfig != null && baseConfig.getUserProperties() != null && baseConfig.getUserProperties().size() > 0) {
            this.userProperties.putAll(baseConfig.getUserProperties());
        }
        if (manualConfigurator != null && !(manualConfigurator instanceof ContainerDefaultConfigurator)) {
            resolvedConfigurator = manualConfigurator;
        } else if (anno.configurator() == ServerEndpointConfig.Configurator.class) {
            resolvedConfigurator = new ContainerDefaultConfigurator();
        } else {
            try {
                resolvedConfigurator = (ServerEndpointConfig.Configurator)anno.configurator().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                StringBuilder err = new StringBuilder();
                err.append("Unable to instantiate ClientEndpoint.configurator() of ");
                err.append(anno.configurator().getName());
                err.append(" defined as annotation in ");
                err.append(anno.getClass().getName());
                throw new DeploymentException(err.toString(), (Throwable)e);
            }
        }
        this.configurator = containerScope.getObjectFactory().decorate(resolvedConfigurator);
    }

    public ServerEndpointConfig.Configurator getConfigurator() {
        return this.configurator;
    }

    public List<Class<? extends Decoder>> getDecoders() {
        return this.decoders;
    }

    public List<Class<? extends Encoder>> getEncoders() {
        return this.encoders;
    }

    public Class<?> getEndpointClass() {
        return this.endpointClass;
    }

    public List<Extension> getExtensions() {
        return this.extensions;
    }

    public String getPath() {
        return this.path;
    }

    public List<String> getSubprotocols() {
        return this.subprotocols;
    }

    public Map<String, Object> getUserProperties() {
        return this.userProperties;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AnnotatedServerEndpointConfig[endpointClass=");
        builder.append(this.endpointClass);
        builder.append(",path=");
        builder.append(this.path);
        builder.append(",decoders=");
        builder.append(this.decoders);
        builder.append(",encoders=");
        builder.append(this.encoders);
        builder.append(",subprotocols=");
        builder.append(this.subprotocols);
        builder.append(",extensions=");
        builder.append(this.extensions);
        builder.append("]");
        return builder.toString();
    }
}

