/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jetty.websocket.jsr356.endpoints;

import javax.websocket.Endpoint;
import org.teavm.jetty.websocket.api.WebSocketPolicy;
import org.teavm.jetty.websocket.common.events.EventDriver;
import org.teavm.jetty.websocket.common.events.EventDriverImpl;
import org.teavm.jetty.websocket.jsr356.endpoints.EndpointInstance;
import org.teavm.jetty.websocket.jsr356.endpoints.JsrEndpointEventDriver;

public class JsrEndpointImpl
implements EventDriverImpl {
    @Override
    public EventDriver create(Object websocket, WebSocketPolicy policy) {
        if (!(websocket instanceof EndpointInstance)) {
            throw new IllegalStateException(String.format("Websocket %s must be an %s", websocket.getClass().getName(), EndpointInstance.class.getName()));
        }
        return new JsrEndpointEventDriver(policy, (EndpointInstance)websocket);
    }

    @Override
    public String describeRule() {
        return "class extends " + Endpoint.class.getName();
    }

    @Override
    public boolean supports(Object websocket) {
        if (!(websocket instanceof EndpointInstance)) {
            return false;
        }
        EndpointInstance ei = (EndpointInstance)websocket;
        Object endpoint = ei.getEndpoint();
        return endpoint instanceof Endpoint;
    }
}

