/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jetty.websocket.jsr356.decoders;

import javax.websocket.DecodeException;
import javax.websocket.Decoder;
import org.teavm.jetty.websocket.jsr356.decoders.AbstractDecoder;

public class IntegerDecoder
extends AbstractDecoder
implements Decoder.Text<Integer> {
    public static final IntegerDecoder INSTANCE = new IntegerDecoder();

    public Integer decode(String s) throws DecodeException {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new DecodeException(s, "Unable to parse Integer", (Throwable)e);
        }
    }

    public boolean willDecode(String s) {
        if (s == null) {
            return false;
        }
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

