/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jetty.websocket.jsr356.annotations;

import java.lang.reflect.Method;
import javax.websocket.Decoder;
import javax.websocket.Encoder;
import org.teavm.jetty.websocket.common.events.annotated.InvalidSignatureException;
import org.teavm.jetty.websocket.common.util.ReflectUtils;
import org.teavm.jetty.websocket.jsr356.EncoderFactory;
import org.teavm.jetty.websocket.jsr356.JsrSession;
import org.teavm.jetty.websocket.jsr356.annotations.JsrCallable;
import org.teavm.jetty.websocket.jsr356.annotations.Param;

public class OnMessageCallable
extends JsrCallable {
    protected final Class<?> returnType;
    protected Encoder returnEncoder;
    protected Class<?> decodingType;
    protected Decoder decoder;
    protected int idxPartialMessageFlag = -1;
    protected int idxMessageObject = -1;
    protected boolean messageRoleAssigned = false;

    public OnMessageCallable(Class<?> pojo, Method method) {
        super(pojo, method);
        this.returnType = method.getReturnType();
    }

    public OnMessageCallable(OnMessageCallable copy) {
        super(copy);
        this.returnType = copy.returnType;
        this.decodingType = copy.decodingType;
        this.decoder = copy.decoder;
        this.idxPartialMessageFlag = copy.idxPartialMessageFlag;
        this.idxMessageObject = copy.idxMessageObject;
    }

    protected void assertDecoderRequired() {
        if (this.getDecoder() == null) {
            StringBuilder err = new StringBuilder();
            err.append("Unable to find a valid ");
            err.append(Decoder.class.getName());
            err.append(" for parameter #");
            Param param = this.params[this.idxMessageObject];
            err.append(param.index);
            err.append(" [").append(param.type).append("] in method: ");
            err.append(ReflectUtils.toString(this.pojo, this.method));
            throw new InvalidSignatureException(err.toString());
        }
    }

    private int findMessageObjectIndex() {
        int index = -1;
        for (Param.Role role : Param.Role.getMessageRoles()) {
            index = this.findIndexForRole(role);
            if (index < 0) continue;
            return index;
        }
        return -1;
    }

    public Decoder getDecoder() {
        return this.decoder;
    }

    public Param getMessageObjectParam() {
        if (this.idxMessageObject < 0) {
            this.idxMessageObject = this.findMessageObjectIndex();
            if (this.idxMessageObject < 0) {
                StringBuilder err = new StringBuilder();
                err.append("A message type must be specified [TEXT, BINARY, DECODER, or PONG] : ");
                err.append(ReflectUtils.toString(this.pojo, this.method));
                throw new InvalidSignatureException(err.toString());
            }
        }
        return this.params[this.idxMessageObject];
    }

    public Encoder getReturnEncoder() {
        return this.returnEncoder;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    @Override
    public void init(JsrSession session) {
        super.init(session);
        this.idxPartialMessageFlag = this.findIndexForRole(Param.Role.MESSAGE_PARTIAL_FLAG);
        EncoderFactory.Wrapper encoderWrapper = session.getEncoderFactory().getWrapperFor(this.returnType);
        if (encoderWrapper != null) {
            this.returnEncoder = encoderWrapper.getEncoder();
        }
        if (this.decodingType != null) {
            this.decoder = session.getDecoderFactory().getDecoderFor(this.decodingType);
        }
    }

    public boolean isMessageRoleAssigned() {
        return this.messageRoleAssigned;
    }

    public boolean isPartialMessageSupported() {
        return this.idxPartialMessageFlag >= 0;
    }

    @Override
    public void setDecodingType(Class<?> decodingType) {
        this.decodingType = decodingType;
        this.messageRoleAssigned = true;
    }

    public void setPartialMessageFlag(Param param) {
        this.idxPartialMessageFlag = param.index;
    }
}

