/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jetty.websocket.jsr356.annotations;

import org.teavm.jetty.websocket.common.events.annotated.InvalidSignatureException;
import org.teavm.jetty.websocket.jsr356.annotations.IJsrParamId;
import org.teavm.jetty.websocket.jsr356.annotations.JsrCallable;
import org.teavm.jetty.websocket.jsr356.annotations.JsrParamIdOnMessage;
import org.teavm.jetty.websocket.jsr356.annotations.Param;
import org.teavm.jetty.websocket.jsr356.metadata.DecoderMetadata;

public class JsrParamIdDecoder
extends JsrParamIdOnMessage
implements IJsrParamId {
    private final DecoderMetadata metadata;

    public JsrParamIdDecoder(DecoderMetadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public boolean process(Param param, JsrCallable callable) throws InvalidSignatureException {
        if (param.type.isAssignableFrom(this.metadata.getObjectType())) {
            this.assertPartialMessageSupportDisabled(param, callable);
            switch (this.metadata.getMessageType()) {
                case TEXT: {
                    if (this.metadata.isStreamed()) {
                        param.bind(Param.Role.MESSAGE_TEXT_STREAM);
                        break;
                    }
                    param.bind(Param.Role.MESSAGE_TEXT);
                    break;
                }
                case BINARY: {
                    if (this.metadata.isStreamed()) {
                        param.bind(Param.Role.MESSAGE_BINARY_STREAM);
                        break;
                    }
                    param.bind(Param.Role.MESSAGE_BINARY);
                    break;
                }
                case PONG: {
                    param.bind(Param.Role.MESSAGE_PONG);
                }
            }
            callable.setDecodingType(this.metadata.getObjectType());
            return true;
        }
        return false;
    }
}

