/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jetty.websocket.jsr356.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import javax.websocket.DecodeException;
import javax.websocket.Decoder;
import org.teavm.jetty.websocket.api.InvalidWebSocketException;
import org.teavm.jetty.websocket.common.events.annotated.CallableMethod;
import org.teavm.jetty.websocket.common.events.annotated.InvalidSignatureException;
import org.teavm.jetty.websocket.common.util.ReflectUtils;
import org.teavm.jetty.websocket.jsr356.JsrSession;
import org.teavm.jetty.websocket.jsr356.annotations.Param;

public abstract class JsrCallable
extends CallableMethod {
    protected final Param[] params;
    protected final Object[] args;
    protected int idxSession = -1;
    protected int idxConfig = -1;

    public JsrCallable(Class<?> pojo, Method method) {
        super(pojo, method);
        Class<?>[] ptypes = method.getParameterTypes();
        Annotation[][] pannos = method.getParameterAnnotations();
        int len = ptypes.length;
        this.params = new Param[len];
        for (int i = 0; i < len; ++i) {
            this.params[i] = new Param(i, ptypes[i], pannos[i]);
        }
        this.args = new Object[len];
    }

    public JsrCallable(JsrCallable copy) {
        this(copy.getPojo(), copy.getMethod());
        this.idxSession = copy.idxSession;
        this.idxConfig = copy.idxConfig;
        System.arraycopy(copy.params, 0, this.params, 0, this.params.length);
        System.arraycopy(copy.args, 0, this.args, 0, this.args.length);
    }

    protected void assertRoleRequired(int index, String description) {
        if (index < 0) {
            StringBuilder err = new StringBuilder();
            err.append("Unable to find parameter with role [");
            err.append(description).append("] in method: ");
            err.append(ReflectUtils.toString(this.pojo, this.method));
            throw new InvalidSignatureException(err.toString());
        }
    }

    protected int findIndexForRole(Param.Role role) {
        Param param = this.findParamForRole(role);
        if (param != null) {
            return param.index;
        }
        return -1;
    }

    protected Param findParamForRole(Param.Role role) {
        for (Param param : this.params) {
            if (param.role != role) continue;
            return param;
        }
        return null;
    }

    public Param[] getParams() {
        return this.params;
    }

    public void init(JsrSession session) {
        Map<String, String> pathParams;
        this.idxSession = this.findIndexForRole(Param.Role.SESSION);
        if (this.idxSession >= 0) {
            this.args[this.idxSession] = session;
        }
        this.idxConfig = this.findIndexForRole(Param.Role.ENDPOINT_CONFIG);
        if (this.idxConfig >= 0) {
            this.args[this.idxConfig] = session.getEndpointConfig();
        }
        if ((pathParams = session.getPathParameters()) != null && pathParams.size() > 0) {
            for (Param param : this.params) {
                if (param.role != Param.Role.PATH_PARAM) continue;
                int idx = param.index;
                String rawvalue = pathParams.get(param.getPathParamName());
                Decoder decoder = session.getDecoderFactory().getDecoderFor(param.type);
                if (decoder instanceof Decoder.Text) {
                    Decoder.Text textDecoder = (Decoder.Text)decoder;
                    try {
                        this.args[idx] = textDecoder.decode(rawvalue);
                    }
                    catch (DecodeException e) {
                        session.close(e);
                    }
                    continue;
                }
                throw new InvalidWebSocketException("PathParam decoders must use Decoder.Text");
            }
        }
    }

    public abstract void setDecodingType(Class<?> var1);
}

