/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jetty.websocket.jsr356;

import java.util.List;
import java.util.Map;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.HandshakeResponse;
import org.teavm.jetty.websocket.api.UpgradeRequest;
import org.teavm.jetty.websocket.api.UpgradeResponse;
import org.teavm.jetty.websocket.client.io.UpgradeListener;
import org.teavm.jetty.websocket.jsr356.JsrHandshakeResponse;

public class JsrUpgradeListener
implements UpgradeListener {
    private ClientEndpointConfig.Configurator configurator;

    public JsrUpgradeListener(ClientEndpointConfig.Configurator configurator) {
        this.configurator = configurator;
    }

    @Override
    public void onHandshakeRequest(UpgradeRequest request) {
        if (this.configurator == null) {
            return;
        }
        Map<String, List<String>> headers = request.getHeaders();
        this.configurator.beforeRequest(headers);
        request.setHeaders(headers);
    }

    @Override
    public void onHandshakeResponse(UpgradeResponse response) {
        if (this.configurator == null) {
            return;
        }
        JsrHandshakeResponse hr = new JsrHandshakeResponse(response);
        this.configurator.afterResponse((HandshakeResponse)hr);
    }
}

