/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jetty.websocket.jsr356;

import java.net.URI;
import org.teavm.jetty.util.log.Log;
import org.teavm.jetty.util.log.Logger;
import org.teavm.jetty.websocket.common.LogicalConnection;
import org.teavm.jetty.websocket.common.SessionFactory;
import org.teavm.jetty.websocket.common.WebSocketSession;
import org.teavm.jetty.websocket.common.events.EventDriver;
import org.teavm.jetty.websocket.jsr356.ClientContainer;
import org.teavm.jetty.websocket.jsr356.JsrSession;
import org.teavm.jetty.websocket.jsr356.endpoints.AbstractJsrEventDriver;

public class JsrSessionFactory
implements SessionFactory {
    private static final Logger LOG = Log.getLogger(JsrSessionFactory.class);
    private final ClientContainer container;

    public JsrSessionFactory(ClientContainer container) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Container: {}", container);
        }
        this.container = container;
    }

    @Override
    public WebSocketSession createSession(URI requestURI, EventDriver websocket, LogicalConnection connection) {
        return new JsrSession(this.container, connection.getId(), requestURI, websocket, connection);
    }

    @Override
    public boolean supports(EventDriver websocket) {
        return websocket instanceof AbstractJsrEventDriver;
    }
}

