/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jetty.websocket.jsr356;

import java.lang.reflect.Method;
import javax.websocket.ContainerProvider;
import javax.websocket.WebSocketContainer;
import org.teavm.jetty.util.component.ContainerLifeCycle;
import org.teavm.jetty.util.log.Log;
import org.teavm.jetty.util.log.Logger;
import org.teavm.jetty.util.thread.ShutdownThread;
import org.teavm.jetty.websocket.api.WebSocketPolicy;
import org.teavm.jetty.websocket.common.scopes.SimpleContainerScope;
import org.teavm.jetty.websocket.jsr356.ClientContainer;

public class JettyClientContainerProvider
extends ContainerProvider {
    private static final Logger LOG = Log.getLogger(JettyClientContainerProvider.class);
    private static boolean useSingleton = false;
    private static boolean useServerContainer = false;
    private static WebSocketContainer INSTANCE;
    private static Object lock;

    public static void useSingleton(boolean flag) {
        useSingleton = flag;
    }

    public static boolean willUseSingleton() {
        return useSingleton;
    }

    public static void useServerContainer(boolean flag) {
        useServerContainer = flag;
    }

    public static boolean willUseServerContainer() {
        return useServerContainer;
    }

    public Object getContextHandler() {
        try {
            Class<?> clazzContextHandler = Class.forName("org.teavm.jetty.server.handler.ContextHandler");
            Method methodGetContext = clazzContextHandler.getMethod("getCurrentContext", new Class[0]);
            Object objContext = methodGetContext.invoke(null, new Object[0]);
            if (objContext == null) {
                return null;
            }
            Class<?> clazzServletContext = Class.forName("org.teavm.javaxservlet.ServletContext");
            Method methodGetContextHandler = clazzContextHandler.getMethod("getContextHandler", clazzServletContext);
            return methodGetContextHandler.invoke(null, objContext);
        }
        catch (Throwable ignore) {
            LOG.ignore(ignore);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WebSocketContainer getContainer() {
        Object object = lock;
        synchronized (object) {
            ClientContainer webSocketContainer = null;
            Object contextHandler = this.getContextHandler();
            if (useServerContainer && contextHandler != null) {
                try {
                    Method methodGetAttribute;
                    Object objServerContainer;
                    Method methodGetServletContext = contextHandler.getClass().getMethod("getServletContext", new Class[0]);
                    Object objServletContext = methodGetServletContext.invoke(contextHandler, new Object[0]);
                    if (objServletContext != null && (objServerContainer = (methodGetAttribute = objServletContext.getClass().getMethod("getAttribute", String.class)).invoke(objServletContext, "javax.websocket.server.ServerContainer")) != null && objServerContainer instanceof WebSocketContainer) {
                        webSocketContainer = (WebSocketContainer)objServerContainer;
                    }
                }
                catch (Throwable ignore) {
                    LOG.ignore(ignore);
                }
            }
            if (useSingleton && INSTANCE != null) {
                return INSTANCE;
            }
            if (webSocketContainer == null) {
                SimpleContainerScope containerScope = new SimpleContainerScope(WebSocketPolicy.newClientPolicy());
                ClientContainer clientContainer = new ClientContainer(containerScope);
                if (contextHandler != null && contextHandler instanceof ContainerLifeCycle) {
                    ((ContainerLifeCycle)contextHandler).addManaged(clientContainer);
                } else {
                    ShutdownThread.register(clientContainer);
                }
                if (!clientContainer.isStarted()) {
                    try {
                        clientContainer.start();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to start Client Container", e);
                    }
                }
                webSocketContainer = clientContainer;
            }
            if (useSingleton) {
                INSTANCE = webSocketContainer;
            }
            return webSocketContainer;
        }
    }

    static {
        lock = new Object();
    }
}

