/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jetty.websocket.jsr356;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import javax.websocket.ClientEndpoint;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.WebSocketContainer;
import org.teavm.jetty.client.HttpClient;
import org.teavm.jetty.io.ByteBufferPool;
import org.teavm.jetty.util.DecoratedObjectFactory;
import org.teavm.jetty.util.annotation.ManagedObject;
import org.teavm.jetty.util.component.ContainerLifeCycle;
import org.teavm.jetty.util.log.Log;
import org.teavm.jetty.util.log.Logger;
import org.teavm.jetty.util.ssl.SslContextFactory;
import org.teavm.jetty.util.thread.ShutdownThread;
import org.teavm.jetty.websocket.api.InvalidWebSocketException;
import org.teavm.jetty.websocket.api.Session;
import org.teavm.jetty.websocket.api.WebSocketBehavior;
import org.teavm.jetty.websocket.api.WebSocketPolicy;
import org.teavm.jetty.websocket.api.extensions.ExtensionFactory;
import org.teavm.jetty.websocket.client.ClientUpgradeRequest;
import org.teavm.jetty.websocket.client.WebSocketClient;
import org.teavm.jetty.websocket.common.WebSocketSession;
import org.teavm.jetty.websocket.common.WebSocketSessionListener;
import org.teavm.jetty.websocket.common.scopes.DelegatedContainerScope;
import org.teavm.jetty.websocket.common.scopes.WebSocketContainerScope;
import org.teavm.jetty.websocket.jsr356.DecoderFactory;
import org.teavm.jetty.websocket.jsr356.EncoderFactory;
import org.teavm.jetty.websocket.jsr356.JsrExtension;
import org.teavm.jetty.websocket.jsr356.JsrExtensionConfig;
import org.teavm.jetty.websocket.jsr356.JsrSession;
import org.teavm.jetty.websocket.jsr356.JsrSessionFactory;
import org.teavm.jetty.websocket.jsr356.JsrSessionListener;
import org.teavm.jetty.websocket.jsr356.JsrSessionTracker;
import org.teavm.jetty.websocket.jsr356.JsrUpgradeListener;
import org.teavm.jetty.websocket.jsr356.annotations.AnnotatedEndpointScanner;
import org.teavm.jetty.websocket.jsr356.client.AnnotatedClientEndpointMetadata;
import org.teavm.jetty.websocket.jsr356.client.EmptyClientEndpointConfig;
import org.teavm.jetty.websocket.jsr356.client.SimpleEndpointMetadata;
import org.teavm.jetty.websocket.jsr356.decoders.PrimitiveDecoderMetadataSet;
import org.teavm.jetty.websocket.jsr356.encoders.PrimitiveEncoderMetadataSet;
import org.teavm.jetty.websocket.jsr356.endpoints.EndpointInstance;
import org.teavm.jetty.websocket.jsr356.endpoints.JsrEventDriverFactory;
import org.teavm.jetty.websocket.jsr356.metadata.EndpointMetadata;

@ManagedObject(value="JSR356 Client Container")
public class ClientContainer
extends ContainerLifeCycle
implements WebSocketContainer,
WebSocketContainerScope {
    private static final Logger LOG = Log.getLogger(ClientContainer.class);
    private final WebSocketContainerScope scopeDelegate;
    private final DecoderFactory decoderFactory;
    private final EncoderFactory encoderFactory;
    private final WebSocketClient client;
    private final boolean internalClient;
    private final Map<Class<?>, EndpointMetadata> endpointClientMetadataCache;
    private final JsrSessionTracker sessionTracker = new JsrSessionTracker();

    public ClientContainer() {
        this(new WebSocketClient());
    }

    public ClientContainer(HttpClient httpClient) {
        this(new WebSocketClient(httpClient));
    }

    public ClientContainer(WebSocketContainerScope scope) {
        this(scope, null);
    }

    protected ClientContainer(WebSocketContainerScope scope, HttpClient httpClient) {
        String jsr356TrustAll = System.getProperty("org.teavm.jetty.websocket.jsr356.ssl-trust-all");
        WebSocketContainerScope clientScope = scope.getPolicy().getBehavior() == WebSocketBehavior.CLIENT ? scope : new DelegatedContainerScope(WebSocketPolicy.newClientPolicy(), scope);
        this.scopeDelegate = clientScope;
        this.client = new WebSocketClient(this.scopeDelegate, new JsrEventDriverFactory(this.scopeDelegate), new JsrSessionFactory(this), httpClient);
        this.client.addSessionListener(new JsrSessionListenerBridge(this.sessionTracker));
        if (jsr356TrustAll != null) {
            boolean trustAll = Boolean.parseBoolean(jsr356TrustAll);
            this.client.getSslContextFactory().setTrustAll(trustAll);
        }
        this.internalClient = true;
        this.endpointClientMetadataCache = new ConcurrentHashMap();
        this.decoderFactory = new DecoderFactory(this, PrimitiveDecoderMetadataSet.INSTANCE);
        this.encoderFactory = new EncoderFactory(this, PrimitiveEncoderMetadataSet.INSTANCE);
        this.addBean(this.sessionTracker);
    }

    public ClientContainer(WebSocketClient client) {
        Objects.requireNonNull(client, "WebSocketClient");
        this.scopeDelegate = client;
        this.client = client;
        this.addBean(this.client);
        this.client.setEventDriverFactory(new JsrEventDriverFactory(this.scopeDelegate));
        this.client.setSessionFactory(new JsrSessionFactory(this));
        this.internalClient = false;
        this.endpointClientMetadataCache = new ConcurrentHashMap();
        this.decoderFactory = new DecoderFactory(this, PrimitiveDecoderMetadataSet.INSTANCE);
        this.encoderFactory = new EncoderFactory(this, PrimitiveEncoderMetadataSet.INSTANCE);
        this.client.addSessionListener(new JsrSessionListenerBridge(this.sessionTracker));
        this.addBean(this.sessionTracker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private javax.websocket.Session connect(EndpointInstance instance, URI path) throws IOException {
        WebSocketClient webSocketClient = this.client;
        synchronized (webSocketClient) {
            if (this.internalClient && !this.client.isStarted()) {
                try {
                    this.client.start();
                    this.addManaged(this.client);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to start Client", e);
                }
            }
        }
        Objects.requireNonNull(instance, "EndpointInstance cannot be null");
        Objects.requireNonNull(path, "Path cannot be null");
        ClientEndpointConfig config = (ClientEndpointConfig)instance.getConfig();
        ClientUpgradeRequest req = new ClientUpgradeRequest();
        JsrUpgradeListener upgradeListener = null;
        for (Extension ext : config.getExtensions()) {
            req.addExtensions(new JsrExtensionConfig(ext));
        }
        if (config.getPreferredSubprotocols().size() > 0) {
            req.setSubProtocols(config.getPreferredSubprotocols());
        }
        if (config.getConfigurator() != null) {
            upgradeListener = new JsrUpgradeListener(config.getConfigurator());
        }
        Future<Session> futSess = this.client.connect(instance, path, req, upgradeListener);
        try {
            return (JsrSession)futSess.get();
        }
        catch (InterruptedException e) {
            throw new IOException("Connect failure", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException("Connect failure", cause);
        }
    }

    public javax.websocket.Session connectToServer(Class<? extends Endpoint> endpointClass, ClientEndpointConfig config, URI path) throws DeploymentException, IOException {
        EndpointInstance instance = this.newClientEndpointInstance(endpointClass, config);
        return this.connect(instance, path);
    }

    public javax.websocket.Session connectToServer(Class<?> annotatedEndpointClass, URI path) throws DeploymentException, IOException {
        EndpointInstance instance = this.newClientEndpointInstance(annotatedEndpointClass, null);
        return this.connect(instance, path);
    }

    public javax.websocket.Session connectToServer(Endpoint endpoint, ClientEndpointConfig config, URI path) throws DeploymentException, IOException {
        EndpointInstance instance = this.newClientEndpointInstance(endpoint, config);
        return this.connect(instance, path);
    }

    public javax.websocket.Session connectToServer(Object endpoint, URI path) throws DeploymentException, IOException {
        EndpointInstance instance = this.newClientEndpointInstance(endpoint, null);
        return this.connect(instance, path);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        EmptyClientEndpointConfig empty = new EmptyClientEndpointConfig();
        this.decoderFactory.init((EndpointConfig)empty);
        this.encoderFactory.init((EndpointConfig)empty);
    }

    @Override
    protected void doStop() throws Exception {
        ShutdownThread.deregister(this);
        this.encoderFactory.destroy();
        this.decoderFactory.destroy();
        this.endpointClientMetadataCache.clear();
        super.doStop();
    }

    @Override
    public ByteBufferPool getBufferPool() {
        return this.scopeDelegate.getBufferPool();
    }

    public WebSocketClient getClient() {
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointMetadata getClientEndpointMetadata(Class<?> endpoint, EndpointConfig config) {
        Map<Class<?>, EndpointMetadata> map = this.endpointClientMetadataCache;
        synchronized (map) {
            EndpointMetadata metadata = this.endpointClientMetadataCache.get(endpoint);
            if (metadata != null) {
                return metadata;
            }
            ClientEndpoint anno = endpoint.getAnnotation(ClientEndpoint.class);
            if (anno != null) {
                AnnotatedClientEndpointMetadata annoMetadata = new AnnotatedClientEndpointMetadata(this, endpoint);
                AnnotatedEndpointScanner<ClientEndpoint, ClientEndpointConfig> scanner = new AnnotatedEndpointScanner<ClientEndpoint, ClientEndpointConfig>(annoMetadata);
                scanner.scan();
                metadata = annoMetadata;
            } else if (Endpoint.class.isAssignableFrom(endpoint)) {
                Class<?> eendpoint = endpoint;
                metadata = new SimpleEndpointMetadata(eendpoint, config);
            } else {
                StringBuilder err = new StringBuilder();
                err.append("Not a recognized websocket [");
                err.append(endpoint.getName());
                err.append("] does not extend @").append(ClientEndpoint.class.getName());
                err.append(" or extend from ").append(Endpoint.class.getName());
                throw new InvalidWebSocketException(err.toString());
            }
            this.endpointClientMetadataCache.put(endpoint, metadata);
            return metadata;
        }
    }

    public DecoderFactory getDecoderFactory() {
        return this.decoderFactory;
    }

    public long getDefaultAsyncSendTimeout() {
        return this.client.getAsyncWriteTimeout();
    }

    public int getDefaultMaxBinaryMessageBufferSize() {
        return this.client.getMaxBinaryMessageBufferSize();
    }

    public long getDefaultMaxSessionIdleTimeout() {
        return this.client.getMaxIdleTimeout();
    }

    public int getDefaultMaxTextMessageBufferSize() {
        return this.client.getMaxTextMessageBufferSize();
    }

    public EncoderFactory getEncoderFactory() {
        return this.encoderFactory;
    }

    @Override
    public Executor getExecutor() {
        return this.scopeDelegate.getExecutor();
    }

    public Set<Extension> getInstalledExtensions() {
        HashSet<Extension> ret = new HashSet<Extension>();
        ExtensionFactory extensions = this.client.getExtensionFactory();
        for (String name : extensions.getExtensionNames()) {
            ret.add(new JsrExtension(name));
        }
        return ret;
    }

    @Override
    public DecoratedObjectFactory getObjectFactory() {
        return this.scopeDelegate.getObjectFactory();
    }

    public Set<javax.websocket.Session> getOpenSessions() {
        return this.sessionTracker.getSessions();
    }

    @Override
    public WebSocketPolicy getPolicy() {
        return this.client.getPolicy();
    }

    @Override
    public SslContextFactory getSslContextFactory() {
        return this.scopeDelegate.getSslContextFactory();
    }

    @Override
    public void addSessionListener(WebSocketSessionListener listener) {
        this.client.addSessionListener(listener);
    }

    @Override
    public void removeSessionListener(WebSocketSessionListener listener) {
        this.client.removeSessionListener(listener);
    }

    @Override
    public Collection<WebSocketSessionListener> getSessionListeners() {
        return this.client.getSessionListeners();
    }

    private EndpointInstance newClientEndpointInstance(Class<?> endpointClass, ClientEndpointConfig config) {
        try {
            return this.newClientEndpointInstance(endpointClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), config);
        }
        catch (Exception e) {
            throw new InvalidWebSocketException("Unable to instantiate websocket: " + endpointClass.getClass(), e);
        }
    }

    public EndpointInstance newClientEndpointInstance(Object endpoint, ClientEndpointConfig config) {
        EndpointMetadata metadata = this.getClientEndpointMetadata(endpoint.getClass(), (EndpointConfig)config);
        Object cec = config;
        if (config == null) {
            cec = metadata instanceof AnnotatedClientEndpointMetadata ? ((AnnotatedClientEndpointMetadata)metadata).getConfig() : new EmptyClientEndpointConfig();
        }
        return new EndpointInstance(endpoint, (EndpointConfig)cec, metadata);
    }

    public void setAsyncSendTimeout(long ms) {
        this.client.setAsyncWriteTimeout(ms);
    }

    public void setDefaultMaxBinaryMessageBufferSize(int max) {
        this.client.setMaxBinaryMessageBufferSize(max);
        this.client.getPolicy().setMaxBinaryMessageSize(max);
    }

    public void setDefaultMaxSessionIdleTimeout(long ms) {
        this.client.setMaxIdleTimeout(ms);
    }

    public void setDefaultMaxTextMessageBufferSize(int max) {
        this.client.setMaxTextMessageBufferSize(max);
        this.client.getPolicy().setMaxTextMessageSize(max);
    }

    private static class JsrSessionListenerBridge
    implements WebSocketSessionListener {
        private final JsrSessionListener listener;

        public JsrSessionListenerBridge(JsrSessionListener listener) {
            this.listener = listener;
        }

        @Override
        public void onSessionOpened(WebSocketSession session) {
            if (session instanceof JsrSession) {
                this.listener.onSessionOpened((JsrSession)session);
            }
        }

        @Override
        public void onSessionClosed(WebSocketSession session) {
            if (session instanceof JsrSession) {
                this.listener.onSessionClosed((JsrSession)session);
            }
        }
    }
}

