/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jetty.websocket.common.extensions.compress;

import java.nio.ByteBuffer;
import org.teavm.jetty.io.ByteBufferAccumulator;
import org.teavm.jetty.io.ByteBufferPool;
import org.teavm.jetty.util.BufferUtil;
import org.teavm.jetty.websocket.api.MessageTooLargeException;

@Deprecated
public class ByteAccumulator
implements AutoCloseable {
    private static final int MIN_SPACE = 8;
    private final ByteBufferAccumulator accumulator;
    private final int maxSize;
    private int length = 0;

    public ByteAccumulator(int maxOverallBufferSize) {
        this(maxOverallBufferSize, null);
    }

    public ByteAccumulator(int maxOverallBufferSize, ByteBufferPool byteBufferPool) {
        this.maxSize = maxOverallBufferSize;
        this.accumulator = new ByteBufferAccumulator(byteBufferPool, false);
    }

    public int getLength() {
        return this.length;
    }

    public ByteBuffer ensureBuffer(int minAllocationSize) {
        return this.accumulator.ensureBuffer(8, minAllocationSize);
    }

    public void addLength(int read) {
        this.length += read;
        if (this.length > this.maxSize) {
            String err = String.format("Resulting message size [%d] is too large for configured max of [%d]", this.length, this.maxSize);
            throw new MessageTooLargeException(err);
        }
    }

    public void copyChunk(byte[] buf, int offset, int length) {
        this.copyChunk(BufferUtil.toBuffer(buf, offset, length));
    }

    public void copyChunk(ByteBuffer buffer) {
        int remaining = buffer.remaining();
        if (this.length + remaining > this.maxSize) {
            String err = String.format("Resulting message size [%d] is too large for configured max of [%d]", this.length + remaining, this.maxSize);
            throw new MessageTooLargeException(err);
        }
        this.length += remaining;
        this.accumulator.copyBuffer(buffer);
    }

    public void transferTo(ByteBuffer buffer) {
        BufferUtil.flipToFlush(buffer, 0);
        int availableSpace = BufferUtil.space(buffer);
        if (availableSpace < this.length) {
            String err = String.format("Not enough space in ByteBuffer remaining [%d] for accumulated buffers length [%d]", availableSpace, this.length);
            throw new IllegalArgumentException(err);
        }
        this.accumulator.writeTo(buffer);
        this.close();
    }

    @Override
    public void close() {
        this.accumulator.close();
    }
}

