/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jetty.websocket.client;

import java.util.concurrent.Executor;
import org.teavm.jetty.client.HttpClient;
import org.teavm.jetty.io.ByteBufferPool;
import org.teavm.jetty.io.MappedByteBufferPool;
import org.teavm.jetty.util.ssl.SslContextFactory;
import org.teavm.jetty.util.thread.QueuedThreadPool;
import org.teavm.jetty.websocket.common.scopes.WebSocketContainerScope;

class DefaultHttpClientProvider {
    DefaultHttpClientProvider() {
    }

    public static HttpClient newHttpClient(WebSocketContainerScope scope) {
        SslContextFactory sslContextFactory = null;
        Executor executor = null;
        ByteBufferPool bufferPool = null;
        if (scope != null) {
            sslContextFactory = scope.getSslContextFactory();
            executor = scope.getExecutor();
            bufferPool = scope.getBufferPool();
        }
        if (sslContextFactory == null) {
            sslContextFactory = new SslContextFactory.Client();
            sslContextFactory.setTrustAll(false);
            sslContextFactory.setEndpointIdentificationAlgorithm("HTTPS");
        }
        HttpClient client = new HttpClient(sslContextFactory);
        if (executor == null) {
            QueuedThreadPool threadPool = new QueuedThreadPool();
            String name = "WebSocketClient@" + client.hashCode();
            threadPool.setName(name);
            threadPool.setDaemon(true);
            executor = threadPool;
        }
        client.setExecutor(executor);
        if (bufferPool == null) {
            bufferPool = new MappedByteBufferPool();
        }
        client.setByteBufferPool(bufferPool);
        return client;
    }
}

