/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jetty.websocket.client;

import java.io.IOException;
import java.util.List;
import org.teavm.jetty.client.HttpResponse;
import org.teavm.jetty.http.HttpField;
import org.teavm.jetty.http.HttpFields;
import org.teavm.jetty.http.HttpHeader;
import org.teavm.jetty.websocket.api.extensions.ExtensionConfig;
import org.teavm.jetty.websocket.common.UpgradeResponseAdapter;

public class ClientUpgradeResponse
extends UpgradeResponseAdapter {
    private List<ExtensionConfig> extensions;

    public ClientUpgradeResponse() {
    }

    public ClientUpgradeResponse(HttpResponse response) {
        this.setStatusCode(response.getStatus());
        this.setStatusReason(response.getReason());
        HttpFields fields = response.getHeaders();
        for (HttpField field : fields) {
            this.addHeader(field.getName(), field.getValue());
        }
        HttpField extensionsField = fields.getField(HttpHeader.SEC_WEBSOCKET_EXTENSIONS);
        if (extensionsField != null) {
            this.extensions = ExtensionConfig.parseList(extensionsField.getValues());
        }
        this.setAcceptedSubProtocol(fields.get(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL));
    }

    @Override
    public boolean isSuccess() {
        return true;
    }

    @Override
    public List<ExtensionConfig> getExtensions() {
        return this.extensions;
    }

    @Override
    public void sendForbidden(String message) throws IOException {
        throw new UnsupportedOperationException("Not supported on client implementation");
    }
}

