/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jetty.plus.webapp;

import org.teavm.jetty.plus.annotation.InjectionCollection;
import org.teavm.jetty.plus.annotation.LifeCycleCallbackCollection;
import org.teavm.jetty.util.Decorator;
import org.teavm.jetty.util.log.Log;
import org.teavm.jetty.util.log.Logger;
import org.teavm.jetty.webapp.WebAppContext;

public class PlusDecorator
implements Decorator {
    private static final Logger LOG = Log.getLogger(PlusDecorator.class);
    protected WebAppContext _context;

    public PlusDecorator(WebAppContext context) {
        this._context = context;
    }

    public Object decorate(Object o) {
        LifeCycleCallbackCollection callbacks;
        InjectionCollection injections = (InjectionCollection)this._context.getAttribute("org.teavm.jetty.injectionCollection");
        if (injections != null) {
            injections.inject(o);
        }
        if ((callbacks = (LifeCycleCallbackCollection)this._context.getAttribute("org.teavm.jetty.lifecyleCallbackCollection")) != null) {
            try {
                callbacks.callPostConstructCallback(o);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return o;
    }

    @Override
    public void destroy(Object o) {
        LifeCycleCallbackCollection callbacks = (LifeCycleCallbackCollection)this._context.getAttribute("org.teavm.jetty.lifecyleCallbackCollection");
        if (callbacks != null) {
            try {
                callbacks.callPreDestroyCallback(o);
            }
            catch (Exception e) {
                LOG.warn("Destroying instance of " + o.getClass(), e);
            }
        }
    }
}

