/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jetty.plus.webapp;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import org.teavm.jetty.plus.jndi.Transaction;
import org.teavm.jetty.plus.webapp.PlusDecorator;
import org.teavm.jetty.plus.webapp.PlusDescriptorProcessor;
import org.teavm.jetty.util.log.Log;
import org.teavm.jetty.util.log.Logger;
import org.teavm.jetty.util.thread.ThreadClassLoaderScope;
import org.teavm.jetty.webapp.AbstractConfiguration;
import org.teavm.jetty.webapp.WebAppContext;

public class PlusConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = Log.getLogger(PlusConfiguration.class);
    private Integer _key;

    @Override
    public void preConfigure(WebAppContext context) throws Exception {
        context.getObjectFactory().addDecorator(new PlusDecorator(context));
    }

    @Override
    public void cloneConfigure(WebAppContext template, WebAppContext context) throws Exception {
        context.getObjectFactory().addDecorator(new PlusDecorator(context));
    }

    @Override
    public void configure(WebAppContext context) throws Exception {
        this.bindUserTransaction(context);
        context.getMetaData().addDescriptorProcessor(new PlusDescriptorProcessor());
    }

    @Override
    public void postConfigure(WebAppContext context) throws Exception {
        this.lockCompEnv(context);
    }

    @Override
    public void deconfigure(WebAppContext context) throws Exception {
        this.unlockCompEnv(context);
        this._key = null;
        context.setAttribute("org.teavm.jetty.injectionCollection", null);
        context.setAttribute("org.teavm.jetty.lifecyleCallbackCollection", null);
    }

    public void bindUserTransaction(WebAppContext context) throws Exception {
        try {
            Transaction.bindToENC();
        }
        catch (NameNotFoundException e) {
            LOG.debug("No Transaction manager found - if your webapp requires one, please configure one.", new Object[0]);
        }
    }

    protected void lockCompEnv(WebAppContext wac) throws Exception {
        try (ThreadClassLoaderScope scope = new ThreadClassLoaderScope(wac.getClassLoader());){
            this._key = (int)((long)this.hashCode() ^ System.nanoTime());
            InitialContext context = new InitialContext();
            Context compCtx = (Context)context.lookup("java:comp");
            compCtx.addToEnvironment("org.teavm.jetty.jndi.lock", this._key);
        }
    }

    protected void unlockCompEnv(WebAppContext wac) throws Exception {
        if (this._key != null) {
            try (ThreadClassLoaderScope scope = new ThreadClassLoaderScope(wac.getClassLoader());){
                InitialContext context = new InitialContext();
                Context compCtx = (Context)context.lookup("java:comp");
                compCtx.addToEnvironment("org.teavm.jetty.jndi.unlock", this._key);
            }
        }
    }
}

