/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jetty.client;

import org.teavm.jetty.client.HttpClient;
import org.teavm.jetty.client.HttpRedirector;
import org.teavm.jetty.client.ProtocolHandler;
import org.teavm.jetty.client.api.Request;
import org.teavm.jetty.client.api.Response;
import org.teavm.jetty.client.api.Result;
import org.teavm.jetty.http.HttpField;
import org.teavm.jetty.http.HttpHeader;

public class RedirectProtocolHandler
extends Response.Listener.Adapter
implements ProtocolHandler {
    public static final String NAME = "redirect";
    private final HttpRedirector redirector;

    public RedirectProtocolHandler(HttpClient client) {
        this.redirector = new HttpRedirector(client);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean accept(Request request, Response response) {
        return this.redirector.isRedirect(response) && request.isFollowRedirects();
    }

    @Override
    public Response.Listener getResponseListener() {
        return this;
    }

    @Override
    public boolean onHeader(Response response, HttpField field) {
        return field.getHeader() != HttpHeader.CONTENT_ENCODING;
    }

    @Override
    public void onComplete(Result result) {
        Request request = result.getRequest();
        Response response = result.getResponse();
        if (result.isSucceeded()) {
            this.redirector.redirect(request, response, null);
        } else {
            this.redirector.fail(request, response, result.getFailure());
        }
    }
}

