/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jetty.annotations;

import org.teavm.jetty.annotations.AbstractDiscoverableAnnotationHandler;
import org.teavm.jetty.annotations.AnnotationParser;
import org.teavm.jetty.annotations.WebServletAnnotation;
import org.teavm.jetty.util.log.Log;
import org.teavm.jetty.util.log.Logger;
import org.teavm.jetty.webapp.WebAppContext;

public class WebServletAnnotationHandler
extends AbstractDiscoverableAnnotationHandler {
    private static final Logger LOG = Log.getLogger(WebServletAnnotationHandler.class);

    public WebServletAnnotationHandler(WebAppContext context) {
        super(context);
    }

    @Override
    public void handle(AnnotationParser.ClassInfo info, String annotationName) {
        if (annotationName == null || !"org.teavm.javaxservlet.annotation.WebServlet".equals(annotationName)) {
            return;
        }
        WebServletAnnotation annotation = new WebServletAnnotation(this._context, info.getClassName(), info.getContainingResource());
        this.addAnnotation(annotation);
    }

    @Override
    public void handle(AnnotationParser.FieldInfo info, String annotationName) {
        if (annotationName == null || !"org.teavm.javaxservlet.annotation.WebServlet".equals(annotationName)) {
            return;
        }
        LOG.warn("@WebServlet annotation not supported for fields", new Object[0]);
    }

    @Override
    public void handle(AnnotationParser.MethodInfo info, String annotationName) {
        if (annotationName == null || !"org.teavm.javaxservlet.annotation.WebServlet".equals(annotationName)) {
            return;
        }
        LOG.warn("@WebServlet annotation not supported for methods", new Object[0]);
    }
}

