/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jetty.annotations;

import org.teavm.jetty.annotations.AbstractDiscoverableAnnotationHandler;
import org.teavm.jetty.annotations.AnnotationParser;
import org.teavm.jetty.annotations.WebListenerAnnotation;
import org.teavm.jetty.util.log.Log;
import org.teavm.jetty.util.log.Logger;
import org.teavm.jetty.webapp.WebAppContext;

public class WebListenerAnnotationHandler
extends AbstractDiscoverableAnnotationHandler {
    private static final Logger LOG = Log.getLogger(WebListenerAnnotationHandler.class);

    public WebListenerAnnotationHandler(WebAppContext context) {
        super(context);
    }

    @Override
    public void handle(AnnotationParser.ClassInfo info, String annotationName) {
        if (annotationName == null || !"org.teavm.javaxservlet.annotation.WebListener".equals(annotationName)) {
            return;
        }
        WebListenerAnnotation wlAnnotation = new WebListenerAnnotation(this._context, info.getClassName(), info.getContainingResource());
        this.addAnnotation(wlAnnotation);
    }

    @Override
    public void handle(AnnotationParser.FieldInfo info, String annotationName) {
        if (annotationName == null || !"org.teavm.javaxservlet.annotation.WebListener".equals(annotationName)) {
            return;
        }
        LOG.warn("@WebListener is not applicable to fields: " + info.getClassInfo().getClassName() + "." + info.getFieldName(), new Object[0]);
    }

    @Override
    public void handle(AnnotationParser.MethodInfo info, String annotationName) {
        if (annotationName == null || !"org.teavm.javaxservlet.annotation.WebListener".equals(annotationName)) {
            return;
        }
        LOG.warn("@WebListener is not applicable to methods: " + info.getClassInfo().getClassName() + "." + info.getMethodName() + " " + info.getSignature(), new Object[0]);
    }
}

